/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.server;

import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_3218;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.world.server.SpongeLocatableBlock;
import org.spongepowered.math.vector.Vector3i;

public final class SpongeLocatableBlockBuilder
extends AbstractDataBuilder<LocatableBlock>
implements LocatableBlock.Builder {
    Supplier<? extends BlockState> blockState;
    Supplier<? extends ResourceKey> world;
    Supplier<? extends Vector3i> position;
    Supplier<? extends ServerWorld> worldReference;

    public SpongeLocatableBlockBuilder() {
        super(LocatableBlock.class, 1);
    }

    public SpongeLocatableBlockBuilder state(BlockState blockState) {
        Objects.requireNonNull(blockState, "BlockState cannot be null!");
        this.blockState = () -> blockState;
        return this;
    }

    public SpongeLocatableBlockBuilder location(ServerLocation location) {
        Objects.requireNonNull(location, "LocationBridge cannot be null!");
        this.blockState = () -> ((ServerLocation)location).block();
        this.position = () -> ((ServerLocation)location).blockPosition();
        this.world = () -> ((ServerWorld)location.world()).key();
        WeakReference<ServerWorld> worldRef = new WeakReference<ServerWorld>((ServerWorld)location.world());
        this.worldReference = () -> Objects.requireNonNull((ServerWorld)worldRef.get(), "ServerWorld refrence dereferenced");
        return this;
    }

    public SpongeLocatableBlockBuilder position(Vector3i position) {
        Objects.requireNonNull(position, "Position cannot be null!");
        this.position = () -> position;
        return this;
    }

    public SpongeLocatableBlockBuilder position(int x, int y, int z) {
        Vector3i position = new Vector3i(x, y, z);
        this.position = () -> position;
        return this;
    }

    public SpongeLocatableBlockBuilder world(Supplier<class_3218> worldSupplier) {
        Objects.requireNonNull(worldSupplier, "Supplier cannot be null!");
        Objects.requireNonNull(worldSupplier.get(), "ServerWorld reference cannot be null!");
        this.worldReference = worldSupplier;
        this.world = () -> ((ServerWorld)worldSupplier.get()).key();
        return this;
    }

    public SpongeLocatableBlockBuilder world(ServerWorld world) {
        Objects.requireNonNull(world, "World cannot be null!");
        WeakReference<ServerWorld> reference = new WeakReference<ServerWorld>(world);
        this.worldReference = () -> Objects.requireNonNull((ServerWorld)reference.get(), "ServerWorld refrence dereferenced");
        this.world = () -> this.worldReference.get().key();
        return this;
    }

    public SpongeLocatableBlockBuilder from(LocatableBlock value) {
        Objects.requireNonNull(value, "LocatableBlock cannot be null!");
        this.position = () -> ((LocatableBlock)value).blockPosition();
        this.world = () -> ((ServerWorld)value.serverLocation().world()).key();
        WeakReference<ServerWorld> worldRef = new WeakReference<ServerWorld>((ServerWorld)value.serverLocation().world());
        this.worldReference = () -> Objects.requireNonNull((ServerWorld)worldRef.get(), "ServerWorld refrence dereferenced");
        return this;
    }

    public LocatableBlock build() {
        Objects.requireNonNull(this.position, "Position cannot be null!");
        Objects.requireNonNull(this.world, "World UUID cannot be null!");
        Objects.requireNonNull(this.worldReference, "World reference cannot be null!");
        return new SpongeLocatableBlock(this);
    }

    public SpongeLocatableBlockBuilder reset() {
        this.position = null;
        this.world = null;
        this.worldReference = null;
        this.blockState = null;
        return this;
    }

    protected Optional<LocatableBlock> buildContent(DataView container) throws InvalidDataException {
        ResourceKey worldKey = (ResourceKey)container.getResourceKey(Queries.WORLD_KEY).orElseThrow(() -> new InvalidDataException("Could not locate a world key"));
        int x = (Integer)container.getInt(Queries.POSITION_X).orElseThrow(() -> new InvalidDataException("Could not locate an \"x\" coordinate in the container!"));
        int y = (Integer)container.getInt(Queries.POSITION_Y).orElseThrow(() -> new InvalidDataException("Could not locate an \"y\" coordinate in the container!"));
        int z = (Integer)container.getInt(Queries.POSITION_Z).orElseThrow(() -> new InvalidDataException("Could not locate an \"z\" coordinate in the container!"));
        BlockState blockState = (BlockState)container.getSerializable(Constants.Block.BLOCK_STATE, BlockState.class).orElseThrow(() -> new InvalidDataException("Could not locate a BlockState"));
        return Sponge.server().worldManager().world(worldKey).map(world -> new SpongeLocatableBlockBuilder().position(x, y, z).world((ServerWorld)world).state(blockState).build());
    }
}

