/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.server;

import java.time.Duration;
import java.time.temporal.TemporalUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.fluid.FluidType;
import org.spongepowered.api.scheduler.ScheduledUpdate;
import org.spongepowered.api.scheduler.TaskPriority;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.storage.ChunkLayout;
import org.spongepowered.common.data.holder.SpongeMutableDataHolder;
import org.spongepowered.common.util.MissingImplementationException;
import org.spongepowered.common.world.SpongeLocation;
import org.spongepowered.common.world.server.SpongeLocatableBlockBuilder;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public final class SpongeServerLocation
extends SpongeLocation<ServerWorld, ServerLocation>
implements ServerLocation,
SpongeMutableDataHolder {
    SpongeServerLocation(ServerWorld world, ChunkLayout chunkLayout, Vector3d position) {
        super(world, chunkLayout, position);
    }

    SpongeServerLocation(ServerWorld worldRef, Vector3d position, Vector3i chunkPosition, Vector3i biomePosition) {
        super(worldRef, position, chunkPosition, biomePosition);
    }

    @Override
    public ServerLocation withWorld(ServerWorld world) {
        return new SpongeServerLocation(world, this.position(), this.chunkPosition(), this.biomePosition());
    }

    @Override
    public ServerLocation withPosition(Vector3d position) {
        ChunkLayout chunkLayout = ((ServerWorld)this.world()).engine().chunkLayout();
        return new SpongeServerLocation((ServerWorld)this.world(), chunkLayout, position);
    }

    @Override
    public ServerLocation withBlockPosition(Vector3i position) {
        ChunkLayout chunkLayout = ((ServerWorld)this.world()).engine().chunkLayout();
        return new SpongeServerLocation((ServerWorld)this.world(), chunkLayout, position.toDouble());
    }

    @Override
    public ServerLocation sub(Vector3d v) {
        return this.withPosition(this.position().sub(v));
    }

    @Override
    public ServerLocation sub(Vector3i v) {
        return this.withBlockPosition(this.blockPosition().sub(v));
    }

    @Override
    public ServerLocation sub(double x, double y, double z) {
        return this.withPosition(this.position().sub(x, y, z));
    }

    @Override
    public ServerLocation add(Vector3d v) {
        return this.withPosition(this.position().add(v));
    }

    @Override
    public ServerLocation add(Vector3i v) {
        return this.withBlockPosition(this.blockPosition().add(v));
    }

    @Override
    public ServerLocation add(double x, double y, double z) {
        return this.withPosition(this.position().add(x, y, z));
    }

    @Override
    public ServerLocation relativeTo(Direction direction) {
        return this.add(direction.asOffset());
    }

    @Override
    public ServerLocation relativeToBlock(Direction direction) {
        return this.add(direction.asBlockOffset());
    }

    public ResourceKey worldKey() {
        return ((ServerWorld)this.world()).key();
    }

    public LocatableBlock asLocatableBlock() {
        return new SpongeLocatableBlockBuilder().location(this).build();
    }

    public <T> T map(BiFunction<ServerWorld, Vector3d, T> mapper) {
        throw new MissingImplementationException("ServerLocation", "map");
    }

    public <T> T mapBlock(BiFunction<ServerWorld, Vector3i, T> mapper) {
        throw new MissingImplementationException("ServerLocation", "mapBlock");
    }

    public <T> T mapChunk(BiFunction<ServerWorld, Vector3i, T> mapper) {
        throw new MissingImplementationException("ServerLocation", "mapChunk");
    }

    public <T> T mapBiome(BiFunction<ServerWorld, Vector3i, T> mapper) {
        throw new MissingImplementationException("ServerLocation", "mapBiome");
    }

    public boolean restoreSnapshot(BlockSnapshot snapshot, boolean force, BlockChangeFlag flag) {
        return false;
    }

    public boolean removeBlock() {
        return ((ServerWorld)this.world()).removeBlock(this.blockPosition());
    }

    public <E extends Entity> E createEntity(EntityType<E> type) {
        return (E)((ServerWorld)this.world()).createEntity(type, this.position());
    }

    public boolean spawnEntity(Entity entity) {
        return ((ServerWorld)this.world()).spawnEntity(entity);
    }

    public Collection<Entity> spawnEntities(Iterable<? extends Entity> entities) {
        return ((ServerWorld)this.world()).spawnEntities(entities);
    }

    public ServerLocation asHighestLocation() {
        return this.withBlockPosition(((ServerWorld)this.world()).highestPositionAt(this.blockPosition()));
    }

    public BlockSnapshot createSnapshot() {
        return ((ServerWorld)this.world()).createSnapshot(this.blockPosition());
    }

    public Collection<? extends ScheduledUpdate<BlockType>> scheduledBlockUpdates() {
        return ((ServerWorld)this.world()).scheduledBlockUpdates().scheduledAt(this.blockPosition());
    }

    public ScheduledUpdate<BlockType> scheduleBlockUpdate(int delay, TemporalUnit temporalUnit) {
        return ((ServerWorld)this.world()).scheduledBlockUpdates().schedule(this.blockPosition(), (Object)this.blockType(), delay, temporalUnit);
    }

    public ScheduledUpdate<BlockType> scheduleBlockUpdate(Ticks delay, TaskPriority priority) {
        return ((ServerWorld)this.world()).scheduledBlockUpdates().schedule(this.blockPosition(), (Object)this.blockType(), delay, priority);
    }

    public ScheduledUpdate<BlockType> scheduleBlockUpdate(int delay, TemporalUnit temporalUnit, TaskPriority priority) {
        return ((ServerWorld)this.world()).scheduledBlockUpdates().schedule(this.blockPosition(), (Object)this.blockType(), delay, temporalUnit, priority);
    }

    public ScheduledUpdate<BlockType> scheduleBlockUpdate(Ticks delay) {
        return ((ServerWorld)this.world()).scheduledBlockUpdates().schedule(this.blockPosition(), (Object)this.blockType(), delay);
    }

    public ScheduledUpdate<BlockType> scheduleBlockUpdate(Duration delay) {
        return ((ServerWorld)this.world()).scheduledBlockUpdates().schedule(this.blockPosition(), (Object)this.blockType(), delay);
    }

    public ScheduledUpdate<BlockType> scheduleBlockUpdate(Duration delay, TaskPriority priority) {
        return ((ServerWorld)this.world()).scheduledBlockUpdates().schedule(this.blockPosition(), (Object)this.blockType(), delay, priority);
    }

    public Collection<? extends ScheduledUpdate<FluidType>> scheduledFluidUpdates() {
        return ((ServerWorld)this.world()).scheduledFluidUpdates().scheduledAt(this.blockPosition());
    }

    public ScheduledUpdate<FluidType> scheduleFluidUpdate(int delay, TemporalUnit temporalUnit) {
        return ((ServerWorld)this.world()).scheduledFluidUpdates().schedule(this.blockPosition(), (Object)this.fluid().type(), delay, temporalUnit);
    }

    public ScheduledUpdate<FluidType> scheduleFluidUpdate(int delay, TemporalUnit temporalUnit, TaskPriority priority) {
        return ((ServerWorld)this.world()).scheduledFluidUpdates().schedule(this.blockPosition(), (Object)this.fluid().type(), delay, temporalUnit, priority);
    }

    public ScheduledUpdate<FluidType> scheduleFluidUpdate(Ticks ticks) {
        return ((ServerWorld)this.world()).scheduledFluidUpdates().schedule(this.blockPosition(), (Object)this.fluid().type(), ticks);
    }

    public ScheduledUpdate<FluidType> scheduleFluidUpdate(Ticks ticks, TaskPriority priority) {
        return ((ServerWorld)this.world()).scheduledFluidUpdates().schedule(this.blockPosition(), (Object)this.fluid().type(), ticks, priority);
    }

    public ScheduledUpdate<FluidType> scheduleFluidUpdate(Duration delay) {
        return ((ServerWorld)this.world()).scheduledFluidUpdates().schedule(this.blockPosition(), (Object)this.fluid().type(), delay);
    }

    public ScheduledUpdate<FluidType> scheduleFluidUpdate(Duration delay, TaskPriority priority) {
        return ((ServerWorld)this.world()).scheduledFluidUpdates().schedule(this.blockPosition(), (Object)this.fluid().type(), delay, priority);
    }

    public <E> Optional<E> get(Direction direction, Key<? extends Value<E>> key) {
        return this.get(key);
    }

    @Override
    public List<DataHolder> impl$delegateDataHolder() {
        Optional<BlockEntity> be = this.blockEntity();
        if (be.isPresent()) {
            return Arrays.asList(this, (DataHolder)be.get(), this.block(), this.block().type());
        }
        return Arrays.asList(this, this.block(), this.block().type());
    }

    public int contentVersion() {
        return 1;
    }

    public DataContainer toContainer() {
        return DataContainer.createNew().set(Queries.WORLD_KEY, (Object)this.worldKey()).set(Queries.POSITION_X, (Object)this.x()).set(Queries.POSITION_Y, (Object)this.y()).set(Queries.POSITION_Z, (Object)this.z());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeServerLocation that = (SpongeServerLocation)o;
        return ((ServerWorld)this.worldRef.get()).equals(that.worldRef.get()) && this.position().equals((Object)that.position()) && this.blockPosition().equals((Object)that.blockPosition());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.worldRef.get(), this.position(), this.blockPosition());
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", SpongeServerLocation.class.getSimpleName() + "[", "]").add("worldRef=" + String.valueOf(this.worldKey())).add("position=" + String.valueOf(this.position())).toString();
    }

    public static final class Factory
    implements ServerLocation.Factory {
        public ServerLocation create(ServerWorld world, Vector3d position) {
            Objects.requireNonNull(world);
            Objects.requireNonNull(position);
            return new SpongeServerLocation(world, world.engine().chunkLayout(), position);
        }

        public ServerLocation create(ServerWorld world, Vector3i blockPosition) {
            Objects.requireNonNull(world);
            Objects.requireNonNull(blockPosition);
            ChunkLayout chunkLayout = world.engine().chunkLayout();
            Vector3d position = blockPosition.toDouble();
            return new SpongeServerLocation(world, chunkLayout, position);
        }

        public ServerLocation create(ResourceKey worldKey, Vector3d position) {
            Objects.requireNonNull(worldKey);
            Objects.requireNonNull(position);
            Optional world = Sponge.server().worldManager().world(worldKey);
            if (!world.isPresent()) {
                throw new IllegalStateException("Unknown world for key: " + worldKey.toString());
            }
            return new SpongeServerLocation((ServerWorld)world.get(), ((ServerWorld)world.get()).engine().chunkLayout(), position);
        }

        public ServerLocation create(ResourceKey worldKey, Vector3i blockPosition) {
            Objects.requireNonNull(worldKey);
            Objects.requireNonNull(blockPosition);
            Optional world = Sponge.server().worldManager().world(worldKey);
            if (!world.isPresent()) {
                throw new IllegalStateException("Unknown world for key: " + worldKey.toString());
            }
            return new SpongeServerLocation((ServerWorld)world.get(), ((ServerWorld)world.get()).engine().chunkLayout(), blockPosition.toDouble());
        }
    }
}

