/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.server;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.minecraft.class_1267;
import net.minecraft.class_128;
import net.minecraft.class_1419;
import net.minecraft.class_148;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1928;
import net.minecraft.class_1932;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_1940;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2794;
import net.minecraft.class_2891;
import net.minecraft.class_2897;
import net.minecraft.class_2910;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_31;
import net.minecraft.class_32;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3230;
import net.minecraft.class_3532;
import net.minecraft.class_3769;
import net.minecraft.class_3902;
import net.minecraft.class_3949;
import net.minecraft.class_3990;
import net.minecraft.class_4274;
import net.minecraft.class_4543;
import net.minecraft.class_4802;
import net.minecraft.class_5219;
import net.minecraft.class_5268;
import net.minecraft.class_5281;
import net.minecraft.class_5285;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_6804;
import net.minecraft.class_7134;
import net.minecraft.class_7225;
import net.minecraft.class_7712;
import net.minecraft.class_7924;
import net.minecraft.class_8895;
import net.minecraft.server.MinecraftServer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Server;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.datapack.DataPackEntry;
import org.spongepowered.api.datapack.DataPackTypes;
import org.spongepowered.api.datapack.DataPacks;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.world.LoadWorldEvent;
import org.spongepowered.api.event.world.UnloadWorldEvent;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.util.file.DeleteFileVisitor;
import org.spongepowered.api.world.DefaultWorldKeys;
import org.spongepowered.api.world.WorldType;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.server.WorldManager;
import org.spongepowered.api.world.server.WorldTemplate;
import org.spongepowered.api.world.server.storage.ServerWorldProperties;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.server.MinecraftServerAccessor;
import org.spongepowered.common.accessor.server.level.ServerLevelAccessor;
import org.spongepowered.common.bridge.core.MappedRegistryBridge;
import org.spongepowered.common.bridge.server.level.ServerLevelBridge;
import org.spongepowered.common.bridge.world.level.chunk.storage.IOWorkerBridge;
import org.spongepowered.common.bridge.world.level.dimension.LevelStemBridge;
import org.spongepowered.common.bridge.world.level.storage.LevelStorageAccessBridge;
import org.spongepowered.common.bridge.world.level.storage.PrimaryLevelDataBridge;
import org.spongepowered.common.bridge.world.level.storage.ServerLevelDataBridge;
import org.spongepowered.common.config.core.SpongeConfigs;
import org.spongepowered.common.config.inheritable.InheritableConfigHandle;
import org.spongepowered.common.config.inheritable.WorldConfig;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.hooks.PlatformHooks;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.common.user.SpongeUserManager;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.FutureUtil;
import org.spongepowered.common.world.server.SpongeWorldTemplate;

public class SpongeWorldManager
implements WorldManager {
    private final MinecraftServer server;
    private final Path defaultWorldDirectory;
    private final Path customWorldsDirectory;
    private final Map<class_5321<class_1937>, class_3218> worlds;

    public SpongeWorldManager(MinecraftServer server) {
        this.server = server;
        this.defaultWorldDirectory = ((MinecraftServerAccessor)this.server).accessor$storageSource().method_54543().comp_732();
        this.customWorldsDirectory = this.defaultWorldDirectory.resolve("dimensions");
        try {
            Files.createDirectories(this.customWorldsDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.worlds = ((MinecraftServerAccessor)this.server).accessor$levels();
    }

    public Server server() {
        return (Server)this.server;
    }

    public Path getDefaultWorldDirectory() {
        return this.defaultWorldDirectory;
    }

    public Optional<ServerWorld> world(ResourceKey key) {
        return Optional.ofNullable((ServerWorld)this.worlds.get(SpongeWorldManager.createRegistryKey(Objects.requireNonNull(key, "key"))));
    }

    public Path worldDirectory(ResourceKey key) {
        Objects.requireNonNull(key, "key");
        return this.getDirectory(key);
    }

    public Collection<ServerWorld> worlds() {
        return Collections.unmodifiableCollection(this.worlds.values());
    }

    public List<ResourceKey> worldKeys() {
        ArrayList<ResourceKey> worldKeys = new ArrayList<ResourceKey>();
        worldKeys.add(DefaultWorldKeys.DEFAULT);
        if (Files.exists(this.getDirectory(DefaultWorldKeys.THE_NETHER), new LinkOption[0])) {
            worldKeys.add(DefaultWorldKeys.THE_NETHER);
        }
        if (Files.exists(this.getDirectory(DefaultWorldKeys.THE_END), new LinkOption[0])) {
            worldKeys.add(DefaultWorldKeys.THE_END);
        }
        try {
            for (Path namespacedDirectory : Files.list(this.customWorldsDirectory).toList()) {
                if (this.customWorldsDirectory.equals(namespacedDirectory)) continue;
                for (Path valueDirectory : Files.list(namespacedDirectory).toList()) {
                    if (namespacedDirectory.equals(valueDirectory)) continue;
                    worldKeys.add(ResourceKey.of((String)namespacedDirectory.getFileName().toString(), (String)valueDirectory.getFileName().toString()));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Collections.unmodifiableList(worldKeys);
    }

    public boolean worldExists(ResourceKey key) {
        class_5321<class_1937> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(key, "key"));
        if (class_1937.field_25179.equals(registryKey)) {
            return true;
        }
        if (this.worlds.get(registryKey) != null) {
            return true;
        }
        return Files.exists(this.getDirectory(key), new LinkOption[0]);
    }

    public Optional<ResourceKey> worldKey(UUID uniqueId) {
        Objects.requireNonNull(uniqueId, "uniqueId");
        return this.worlds.values().stream().filter(w -> ((ServerWorld)w).uniqueId().equals(uniqueId)).map(w -> (ServerWorld)w).map(ServerWorld::key).findAny();
    }

    public Collection<ServerWorld> worldsOfType(WorldType type) {
        Objects.requireNonNull(type, "type");
        return this.worlds().stream().filter(w -> w.worldType() == type).collect(Collectors.toList());
    }

    public CompletableFuture<ServerWorld> loadWorld(WorldTemplate template) {
        ResourceKey key = Objects.requireNonNull(template, "template").key();
        class_5321<class_1937> registryKey = SpongeWorldManager.createRegistryKey(key);
        if (class_1937.field_25179.equals(registryKey)) {
            return FutureUtil.completedWithException(new IllegalArgumentException("The default world cannot be told to load!"));
        }
        class_3218 serverWorld = this.worlds.get(registryKey);
        if (serverWorld != null) {
            return CompletableFuture.completedFuture((ServerWorld)serverWorld);
        }
        this.saveTemplate(template);
        return this.loadWorld0(registryKey, ((SpongeWorldTemplate)template).levelStem());
    }

    public CompletableFuture<ServerWorld> loadWorld(ResourceKey key) {
        if (DefaultWorldKeys.DEFAULT.equals((Object)key)) {
            return FutureUtil.completedWithException(new IllegalArgumentException("The default world cannot be told to load!"));
        }
        class_5321<class_1937> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(key, "key"));
        class_3218 world = this.worlds.get(registryKey);
        if (world != null) {
            return CompletableFuture.completedFuture((ServerWorld)world);
        }
        class_5321 stemKey = class_5321.method_29179((class_5321)class_7924.field_41224, (class_2960)((class_2960)key));
        @Nullable class_5363 levelStem = (class_5363)SpongeCommon.vanillaRegistry(class_7924.field_41224).method_29107(stemKey);
        if (levelStem != null) {
            return this.loadWorld0(registryKey, levelStem);
        }
        DataPack<WorldTemplate> pack = this.findPack(key);
        return this.loadTemplate(pack, key).thenCompose(template -> {
            if (template.isEmpty()) {
                return FutureUtil.completedWithException(new IOException(String.format("Failed to load a template for '%s'!", key)));
            }
            return this.loadWorld0(registryKey, ((SpongeWorldTemplate)template.get()).levelStem());
        });
    }

    private CompletableFuture<ServerWorld> loadWorld0(class_5321<class_1937> registryKey, class_5363 levelStem) {
        class_3218 level;
        ResourceKey worldKey = (ResourceKey)registryKey.method_29177();
        MinecraftServerAccessor.accessor$LOGGER().info("Loading world '{}'", (Object)worldKey);
        try {
            level = this.createNonDefaultLevel(registryKey, levelStem, worldKey);
        }
        catch (IOException e) {
            return FutureUtil.completedWithException(new RuntimeException(String.format("Failed to create level data for world '%s'!", worldKey), e));
        }
        return ((CompletableFuture)((CompletableFuture)SpongeCommon.asyncScheduler().submit(() -> this.prepareLevel(level)).thenApply(w -> {
            ((MinecraftServerAccessor)this.server).invoker$forceDifficulty();
            return w;
        })).thenCompose(w -> this.loadSpawnChunksAsync(level))).thenApply(w -> (ServerWorld)w);
    }

    private class_32.class_5143 createLevelStorageAccess(ResourceKey worldKey) throws IOException {
        class_32.class_5143 storageAccess;
        if (this.isVanillaWorld(worldKey)) {
            String directoryName = this.getDirectoryName(worldKey);
            storageAccess = class_32.method_26999((Path)this.defaultWorldDirectory).method_27002(directoryName);
        } else {
            String name = worldKey.namespace() + File.separator + worldKey.value();
            storageAccess = class_32.method_26999((Path)this.customWorldsDirectory).method_27002(name);
        }
        ((LevelStorageAccessBridge)storageAccess).bridge$setDedicated(true);
        return storageAccess;
    }

    private class_1940 createLevelSettings(class_31 defaultLevelData, class_5363 levelStem, String directoryName) {
        LevelStemBridge levelStemBridge = (LevelStemBridge)levelStem;
        class_1934 gameType = levelStemBridge.bridge$gameMode();
        Boolean hardcore = levelStemBridge.bridge$hardcore();
        class_1267 difficulty = levelStemBridge.bridge$difficulty();
        Boolean allowCommands = levelStemBridge.bridge$allowCommands();
        return new class_1940(directoryName, gameType == null ? defaultLevelData.method_210() : gameType, hardcore == null ? defaultLevelData.method_152() : hardcore.booleanValue(), difficulty == null ? defaultLevelData.method_207() : difficulty, allowCommands == null ? defaultLevelData.method_194() : allowCommands.booleanValue(), defaultLevelData.method_146().method_27325(defaultLevelData.method_45560()), defaultLevelData.method_29589());
    }

    public CompletableFuture<Boolean> unloadWorld(ResourceKey key) {
        class_5321<class_1937> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(key, "key"));
        if (class_1937.field_25179.equals(registryKey)) {
            return CompletableFuture.completedFuture(false);
        }
        class_3218 world = this.worlds.get(registryKey);
        if (world == null) {
            return CompletableFuture.completedFuture(false);
        }
        return this.unloadWorld((ServerWorld)world);
    }

    public CompletableFuture<Boolean> unloadWorld(ServerWorld world) {
        class_5321<class_1937> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(world, "world").key());
        if (class_1937.field_25179.equals(registryKey)) {
            return CompletableFuture.completedFuture(false);
        }
        if (world != this.worlds.get(registryKey)) {
            return CompletableFuture.completedFuture(false);
        }
        return this.unloadWorld0((class_3218)world);
    }

    public CompletableFuture<Optional<ServerWorldProperties>> loadProperties(ResourceKey key) {
        class_31 levelData;
        class_5321<class_1937> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(key, "key"));
        if (this.worlds.get(registryKey) != null) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        if (!this.worldExists(key)) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        try (class_32.class_5143 storageSource = this.createLevelStorageAccess(key);){
            class_31 defaultLevelData = (class_31)this.server.method_27728();
            levelData = this.loadLevelData(defaultLevelData.method_29589(), storageSource.method_54545());
        }
        catch (Exception e) {
            return FutureUtil.completedWithException(e);
        }
        DataPack<WorldTemplate> pack = this.findPack(key);
        return this.loadTemplate(pack, key).thenCompose(template -> {
            if (template.isPresent()) {
                class_5363 scratch = ((SpongeWorldTemplate)template.get()).levelStem();
                ((PrimaryLevelDataBridge)levelData).bridge$populateFromLevelStem(scratch);
            }
            ((PrimaryLevelDataBridge)levelData).bridge$spongeData().setKey(key);
            return CompletableFuture.completedFuture(Optional.of((ServerWorldProperties)levelData));
        });
    }

    public CompletableFuture<Boolean> saveProperties(ServerWorldProperties properties) {
        class_5321<class_1937> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(properties, "properties").key());
        if (this.worlds.get(registryKey) != null) {
            return CompletableFuture.completedFuture(false);
        }
        if (properties instanceof class_5219) {
            class_5219 worldData = (class_5219)properties;
            try {
                this.saveLevelDat(worldData, properties.key());
            }
            catch (Exception ex) {
                return FutureUtil.completedWithException(ex);
            }
        }
        DataPack<WorldTemplate> pack = this.findPack(properties.key());
        return this.loadTemplate(pack, properties.key()).thenCompose(r -> {
            WorldTemplate template = r.orElse(null);
            if (template != null) {
                return this.saveTemplate((WorldTemplate)((WorldTemplate.Builder)WorldTemplate.builder().from((Object)template)).from(properties).build());
            }
            return CompletableFuture.completedFuture(true);
        });
    }

    private void saveLevelDat(class_5219 worldData, ResourceKey key) throws IOException {
        try (class_32.class_5143 storageSource = this.createLevelStorageAccess(key);){
            storageSource.method_27426((class_5455)this.server.method_30611(), worldData, null);
        }
    }

    public CompletableFuture<Boolean> copyWorld(ResourceKey key, ResourceKey copyKey) {
        boolean disableLevelSaving;
        class_5321<class_1937> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(key, "key"));
        class_5321<class_1937> copyRegistryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(copyKey, "copyKey"));
        if (class_1937.field_25179.equals(copyRegistryKey)) {
            return CompletableFuture.completedFuture(false);
        }
        if (!this.worldExists(key)) {
            return CompletableFuture.completedFuture(false);
        }
        if (this.worldExists(copyKey)) {
            return CompletableFuture.completedFuture(false);
        }
        class_3218 loadedWorld = this.worlds.get(registryKey);
        if (loadedWorld != null) {
            disableLevelSaving = loadedWorld.field_13957;
            loadedWorld.method_14176(null, true, loadedWorld.field_13957);
            loadedWorld.field_13957 = true;
        } else {
            disableLevelSaving = false;
        }
        final boolean isDefaultWorld = DefaultWorldKeys.DEFAULT.equals((Object)key);
        return CompletableFuture.runAsync(() -> {
            final Path originalDirectory = this.getDirectory(key);
            final Path copyDirectory = this.getDirectory(copyKey);
            try {
                Files.walkFileTree(originalDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        if (dir.getFileName().toString().equals("dimensions")) {
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        if (isDefaultWorld && SpongeWorldManager.this.isVanillaSubWorld(dir.getFileName().toString())) {
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        Path relativize = originalDirectory.relativize(dir);
                        Path directory = copyDirectory.resolve(relativize);
                        Files.createDirectories(directory, new FileAttribute[0]);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        String fileName = file.getFileName().toString();
                        if (fileName.equals("level_sponge.dat_old")) {
                            return FileVisitResult.CONTINUE;
                        }
                        if (fileName.equals(Constants.World.LEVEL_DAT_OLD)) {
                            return FileVisitResult.CONTINUE;
                        }
                        Files.copy(file, copyDirectory.resolve(originalDirectory.relativize(file)), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                try {
                    Files.walkFileTree(copyDirectory, (FileVisitor<? super Path>)DeleteFileVisitor.INSTANCE);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new CompletionException(e);
            }
            if (loadedWorld != null) {
                loadedWorld.field_13957 = disableLevelSaving;
            }
            Path configFile = this.getConfigFile(key);
            Path copyConfigFile = this.getConfigFile(copyKey);
            try {
                Files.createDirectories(copyConfigFile.getParent(), new FileAttribute[0]);
                Files.copy(configFile, copyConfigFile, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
        }).thenApplyAsync($ -> {
            try {
                this.server().dataPackManager().copy(this.findPack(key), key, copyKey);
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
            return true;
        }, (Executor)SpongeCommon.server());
    }

    public CompletableFuture<Boolean> moveWorld(ResourceKey key, ResourceKey movedKey) {
        class_5321<class_1937> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(key, "key"));
        if (class_1937.field_25179.equals(registryKey)) {
            return CompletableFuture.completedFuture(false);
        }
        if (!this.worldExists(key)) {
            return CompletableFuture.completedFuture(false);
        }
        if (this.worldExists(movedKey)) {
            return CompletableFuture.completedFuture(false);
        }
        class_3218 loadedWorld = this.worlds.get(registryKey);
        if (loadedWorld != null) {
            return this.unloadWorld0(loadedWorld).thenCompose($ -> this.moveWorld0(key, movedKey));
        }
        return this.moveWorld0(key, movedKey);
    }

    private CompletableFuture<Boolean> moveWorld0(ResourceKey key, ResourceKey movedKey) {
        return CompletableFuture.runAsync(() -> {
            Path originalDirectory = this.getDirectory(key);
            Path movedDirectory = this.getDirectory(movedKey);
            try {
                Files.createDirectories(movedDirectory, new FileAttribute[0]);
                Files.move(originalDirectory, movedDirectory, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
            Path configFile = this.getConfigFile(key);
            Path movedConfigFile = this.getConfigFile(movedKey);
            try {
                Files.createDirectories(movedConfigFile.getParent(), new FileAttribute[0]);
                Files.move(configFile, movedConfigFile, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
        }).thenApplyAsync($ -> {
            try {
                this.server().dataPackManager().move(this.findPack(key), key, movedKey);
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
            return true;
        }, (Executor)SpongeCommon.server());
    }

    public CompletableFuture<Boolean> deleteWorld(ResourceKey key) {
        class_5321<class_1937> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(key, "key"));
        if (class_1937.field_25179.equals(registryKey)) {
            return CompletableFuture.completedFuture(false);
        }
        if (!this.worldExists(key)) {
            return CompletableFuture.completedFuture(false);
        }
        class_3218 loadedWorld = this.worlds.get(registryKey);
        if (loadedWorld != null) {
            if (!loadedWorld.method_18766(p -> true).isEmpty()) {
                return CompletableFuture.failedFuture(new IOException(String.format("World '%s' was told to unload but players remain.", registryKey.method_29177())));
            }
            boolean disableLevelSaving = loadedWorld.field_13957;
            loadedWorld.field_13957 = true;
            ((IOWorkerBridge)loadedWorld.method_14178().field_17254.method_39800()).bridge$haltStore(true);
            return ((CompletableFuture)this.unloadWorld0(loadedWorld).thenCompose($ -> this.deleteWorld0(key))).whenComplete(($, e) -> {
                if (e != null) {
                    loadedWorld.field_13957 = disableLevelSaving;
                    ((IOWorkerBridge)loadedWorld.method_14178().field_17254.method_39800()).bridge$haltStore(false);
                }
            });
        }
        return this.deleteWorld0(key);
    }

    private CompletableFuture<Boolean> deleteWorld0(ResourceKey key) {
        class_5321<class_1937> registryKey = SpongeWorldManager.createRegistryKey(key);
        return CompletableFuture.runAsync(() -> {
            Path directory = this.getDirectory(key);
            if (Files.exists(directory, new LinkOption[0])) {
                try {
                    Files.walkFileTree(directory, (FileVisitor<? super Path>)DeleteFileVisitor.INSTANCE);
                }
                catch (IOException e) {
                    throw new CompletionException(e);
                }
            }
            Path configFile = this.getConfigFile(key);
            try {
                Files.deleteIfExists(configFile);
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
        }).thenApplyAsync($ -> {
            try {
                this.server().dataPackManager().delete(this.findPack(key), key);
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
            class_2378 levelStemRegistry = SpongeCommon.vanillaRegistry(class_7924.field_41224);
            class_5321 levelStemKey = class_7924.method_47518((class_5321)registryKey);
            if (levelStemRegistry.method_35842(levelStemKey)) {
                ((MappedRegistryBridge)levelStemRegistry).bridge$forceRemoveValue(class_7924.method_47518((class_5321)registryKey));
            }
            class_32.class_5143 storageSource = ((MinecraftServerAccessor)this.server).accessor$storageSource();
            class_31 levelData = (class_31)this.server.method_27728();
            storageSource.method_27426((class_5455)SpongeCommon.server().method_30611(), (class_5219)levelData, null);
            return true;
        }, (Executor)SpongeCommon.server());
    }

    private DataPack<WorldTemplate> findPack(ResourceKey key) {
        return this.server().dataPackManager().findPack(DataPackTypes.WORLD, key).orElse(DataPacks.WORLD);
    }

    private CompletableFuture<Boolean> unloadWorld0(class_3218 level) {
        class_5321 registryKey = level.method_27983();
        if (!level.method_18766(p -> true).isEmpty()) {
            return CompletableFuture.failedFuture(new IOException(String.format("World '%s' was told to unload but players remain.", registryKey.method_29177())));
        }
        level.method_14176(null, false, level.field_13957);
        return ((IOWorkerBridge)level.method_14178().field_17254.method_39800()).bridge$onIdle().thenComposeAsync($ -> {
            InheritableConfigHandle<WorldConfig> configAdapter;
            if (!level.method_18766(p -> true).isEmpty()) {
                return CompletableFuture.failedFuture(new IOException(String.format("World '%s' was told to unload but players remain.", registryKey.method_29177())));
            }
            SpongeCommon.logger().info("Unloading world '{}'", (Object)registryKey.method_29177());
            UnloadWorldEvent unloadWorldEvent = SpongeEventFactory.createUnloadWorldEvent((Cause)PhaseTracker.getInstance().currentCause(), (ServerWorld)((ServerWorld)level));
            SpongeCommon.post((Event)unloadWorldEvent);
            PlatformHooks.INSTANCE.getWorldHooks().preUnloadWorld(level);
            int lastSpawnChunkRadius = ((ServerLevelAccessor)level).accessor$lastSpawnChunkRadius();
            if (lastSpawnChunkRadius > 1) {
                level.method_14178().method_17300(class_3230.field_14030, new class_1923(level.method_43126()), lastSpawnChunkRadius, (Object)class_3902.field_17274);
                ((ServerLevelAccessor)level).accessor$setLastSpawnChunkRadius(1);
            }
            if ((configAdapter = ((ServerLevelDataBridge)level.method_8401()).bridge$spongeData().configAdapter()) != null) {
                configAdapter.save();
            }
            try {
                level.method_14176(null, true, level.field_13957);
                level.close();
                ((ServerLevelBridge)level).bridge$getLevelSave().close();
            }
            catch (Exception ex) {
                return CompletableFuture.failedFuture(new IOException(ex));
            }
            this.worlds.remove(registryKey);
            return CompletableFuture.completedFuture(true);
        }, (Executor)SpongeCommon.server());
    }

    public void createNonDefaultLevels() {
        class_2378 registry = SpongeCommon.vanillaRegistry(class_7924.field_41224);
        for (class_5363 levelStem : registry) {
            ResourceKey worldKey = (ResourceKey)registry.method_10221((Object)levelStem);
            if (DefaultWorldKeys.DEFAULT.equals((Object)worldKey)) continue;
            LevelStemBridge bridge = (LevelStemBridge)levelStem;
            if (!bridge.bridge$loadOnStartup()) {
                SpongeCommon.logger().warn("World '{}' has been disabled from loading at startup. Skipping...", (Object)worldKey);
                continue;
            }
            MinecraftServerAccessor.accessor$LOGGER().info("Loading world '{}'", (Object)worldKey);
            class_5321<class_1937> registryKey = SpongeWorldManager.createRegistryKey(worldKey);
            try {
                class_3218 level = this.createNonDefaultLevel(registryKey, levelStem, worldKey);
                this.prepareLevel(level);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Failed to create level data for world '%s'!", worldKey), e);
            }
        }
    }

    public void prepareLevels() {
        for (Map.Entry<class_5321<class_1937>, class_3218> entry : this.worlds.entrySet()) {
            this.loadSpawnChunks(entry.getValue());
        }
        ((SpongeUserManager)Sponge.server().userManager()).init();
    }

    private class_31 getOrCreateLevelData(@Nullable Dynamic<?> dynamicLevelData, class_5363 levelStem, String directoryName) {
        class_31 defaultLevelData = (class_31)this.server.method_27728();
        if (dynamicLevelData != null) {
            try {
                return this.loadLevelData(defaultLevelData.method_29589(), dynamicLevelData);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load level data from " + directoryName, e);
            }
        }
        if (this.server.method_3799()) {
            return new class_31(MinecraftServer.field_17704, class_5285.field_40367, SpongeWorldManager.specialWorldProperty(levelStem), Lifecycle.stable());
        }
        class_1940 levelSettings = this.createLevelSettings(defaultLevelData, levelStem, directoryName);
        class_5285 worldGenOptions = defaultLevelData.method_28057();
        Long customSeed = ((LevelStemBridge)levelStem).bridge$seed();
        if (customSeed != null) {
            worldGenOptions = worldGenOptions.method_28024(OptionalLong.of(customSeed));
        }
        return new class_31(levelSettings, worldGenOptions, SpongeWorldManager.specialWorldProperty(levelStem), Lifecycle.stable());
    }

    private class_31 loadLevelData(class_7712 datapackConfig, Dynamic<?> dataTag) {
        class_5455.class_6890 access = this.server.method_30611();
        class_8895 levelData = class_32.method_54523(dataTag, (class_7712)datapackConfig, (class_2378)access.method_30530(class_7924.field_41224), (class_7225.class_7874)access);
        return (class_31)levelData.comp_2008();
    }

    private class_3218 createNonDefaultLevel(class_5321<class_1937> registryKey, class_5363 levelStem, ResourceKey worldKey) throws IOException {
        Dynamic dataTag;
        if (DefaultWorldKeys.DEFAULT.equals((Object)worldKey)) {
            throw new IllegalArgumentException();
        }
        String directoryName = this.getDirectoryName(worldKey);
        class_32.class_5143 storageSource = this.createLevelStorageAccess(worldKey);
        try {
            dataTag = storageSource.method_54545();
        }
        catch (IOException e) {
            dataTag = null;
        }
        class_31 levelData = this.getOrCreateLevelData(dataTag, levelStem, directoryName);
        levelData.method_24285(this.server.getServerModName(), this.server.method_24307().method_39029());
        ((PrimaryLevelDataBridge)levelData).bridge$populateFromLevelStem(levelStem);
        ((PrimaryLevelDataBridge)levelData).bridge$spongeData().setKey(worldKey);
        ImmutableList spawners = levelStem.comp_1012().method_40225(class_7134.field_37666) || levelStem.comp_1012().method_40225(class_7134.field_37669) ? ImmutableList.of((Object)new class_2910(), (Object)new class_3769(), (Object)new class_4274(), (Object)new class_1419(), (Object)new class_3990((class_5268)levelData)) : ImmutableList.of();
        long seed = class_4543.method_27984((long)levelData.method_28057().method_28028());
        Executor executor = ((MinecraftServerAccessor)this.server).accessor$executor();
        class_3949 progressListener = ((MinecraftServerAccessor)this.server).accessor$progressListenerFactory().create(SpongeWorldManager.getSpawnRadius((class_5268)levelData));
        class_3218 level = new class_3218(this.server, executor, storageSource, (class_5268)levelData, registryKey, levelStem, progressListener, levelData.method_45556(), seed, (List)spawners, true, null);
        this.worlds.put(registryKey, level);
        PlatformHooks.INSTANCE.getWorldHooks().postLoadWorld(level);
        return level;
    }

    private class_3218 prepareLevel(class_3218 level) {
        class_5219 worldData;
        if (class_1937.field_25179.equals(level.method_27983())) {
            throw new IllegalArgumentException();
        }
        class_5268 levelData = (class_5268)level.method_8401();
        ServerLevelDataBridge levelDataBridge = (ServerLevelDataBridge)levelData;
        boolean initialized = levelData.method_222();
        LoadWorldEvent loadWorldEvent = SpongeEventFactory.createLoadWorldEvent((Cause)PhaseTracker.getInstance().currentCause(), (ServerWorld)((ServerWorld)level), (boolean)initialized);
        SpongeCommon.post((Event)loadWorldEvent);
        levelDataBridge.bridge$triggerViewDistanceLogic();
        level.method_8621().method_17905(levelData.method_27422());
        if (!initialized) {
            if (levelData instanceof class_5219) {
                worldData = (class_5219)levelData;
                try {
                    boolean isDebugGeneration = worldData.method_45556();
                    boolean hasSpawnAlready = levelDataBridge.bridge$customSpawnPosition();
                    if (!hasSpawnAlready) {
                        if (levelDataBridge.bridge$performsSpawnLogic()) {
                            MinecraftServerAccessor.invoker$setInitialSpawn(level, levelData, worldData.method_28057().method_28030(), isDebugGeneration);
                        } else if (class_1937.field_25181.equals(level.method_27983())) {
                            levelData.method_187(class_3218.field_25144, 0.0f);
                        }
                    } else if (worldData.method_28057().method_28030()) {
                        class_2338 pos = levelData.method_56126();
                        class_2975 bonusChestFeature = (class_2975)SpongeCommon.vanillaRegistry(class_7924.field_41239).method_29107(class_6804.field_35811);
                        bonusChestFeature.method_12862((class_5281)level, level.method_14178().method_12129(), level.field_9229, pos);
                    }
                    levelData.method_223(true);
                    if (isDebugGeneration) {
                        ((MinecraftServerAccessor)this.server).invoker$setupDebugLevel(worldData);
                    }
                }
                catch (Throwable throwable) {
                    class_128 crashReport = class_128.method_560((Throwable)throwable, (String)("Exception initializing world '" + String.valueOf(level.method_27983().method_29177()) + "'"));
                    try {
                        level.method_8538(crashReport);
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    throw new class_148(crashReport);
                }
            }
            levelData.method_223(true);
        }
        this.server.method_3760().method_14591(level);
        if (levelData instanceof class_5219 && (worldData = (class_5219)levelData).method_228() != null) {
            ((ServerLevelBridge)level).bridge$getBossBarManager().method_12972(worldData.method_228(), (class_7225.class_7874)level.method_30349());
        }
        return level;
    }

    private CompletableFuture<class_3218> loadSpawnChunksAsync(class_3218 level) {
        MinecraftServerAccessor.accessor$LOGGER().info("Preparing start region for dimension {}", (Object)level.method_27983().method_29177());
        class_3215 chunkSource = level.method_14178();
        level.method_8554(level.method_43126(), level.method_43127());
        int spawnRadius = SpongeWorldManager.getSpawnRadius((class_5268)level.method_8401());
        int spawnSize = spawnRadius > 0 ? class_3532.method_34954((int)class_3949.method_56041((int)spawnRadius)) : 0;
        CompletableFuture generationFuture = new CompletableFuture();
        Sponge.asyncScheduler().submit(Task.builder().plugin(((Launch)Launch.instance()).platformPlugin()).execute(task -> {
            if (chunkSource.method_17301() >= spawnSize) {
                Sponge.server().scheduler().submit(Task.builder().plugin(((Launch)Launch.instance()).platformPlugin()).execute(() -> generationFuture.complete(level)).build());
                task.cancel();
                MinecraftServerAccessor.accessor$LOGGER().info("Done preparing start region for dimension {}", (Object)level.method_27983().method_29177());
            }
        }).interval(10L, TimeUnit.MILLISECONDS).build());
        return generationFuture.thenApply(v -> {
            SpongeWorldManager.updateForcedChunks(v, v.method_14178());
            return v;
        });
    }

    private void loadSpawnChunks(class_3218 level) {
        int spawnSize;
        MinecraftServerAccessor.accessor$LOGGER().info("Preparing start region for dimension {}", (Object)level.method_27983().method_29177());
        class_2338 spawnPoint = level.method_43126();
        class_1923 chunkPos = new class_1923(spawnPoint);
        class_3949 progressListener = ((ServerLevelBridge)level).bridge$getChunkProgressListener();
        progressListener.method_17669(chunkPos);
        class_3215 chunkSource = level.method_14178();
        ((MinecraftServerAccessor)this.server).accessor$nextTickTimeNanos(class_156.method_648());
        level.method_8554(spawnPoint, level.method_43127());
        int spawnRadius = SpongeWorldManager.getSpawnRadius((class_5268)level.method_8401());
        int n = spawnSize = spawnRadius > 0 ? class_3532.method_34954((int)class_3949.method_56041((int)spawnRadius)) : 0;
        while (chunkSource.method_17301() < spawnSize) {
            ((MinecraftServerAccessor)this.server).accessor$nextTickTimeNanos(class_156.method_648() + 10L * class_4802.field_33869);
            ((MinecraftServerAccessor)this.server).accessor$waitUntilNextTick();
        }
        ((MinecraftServerAccessor)this.server).accessor$nextTickTimeNanos(class_156.method_648() + 10L * class_4802.field_33869);
        ((MinecraftServerAccessor)this.server).accessor$waitUntilNextTick();
        SpongeWorldManager.updateForcedChunks(level, chunkSource);
        ((MinecraftServerAccessor)this.server).accessor$nextTickTimeNanos(class_156.method_648() + 10L * class_4802.field_33869);
        ((MinecraftServerAccessor)this.server).accessor$waitUntilNextTick();
        progressListener.method_17671();
    }

    private static int getSpawnRadius(class_5268 levelData) {
        return ((ServerLevelDataBridge)levelData).bridge$performsSpawnLogic() ? levelData.method_146().method_8356(class_1928.field_48374) : 0;
    }

    private static void updateForcedChunks(class_3218 level, class_3215 serverChunkProvider) {
        class_1932 forcedChunksSaveData = (class_1932)level.method_17983().method_20786(class_1932.method_52570(), "chunks");
        if (forcedChunksSaveData != null) {
            LongIterator longIterator = forcedChunksSaveData.method_8375().iterator();
            while (longIterator.hasNext()) {
                long i = longIterator.nextLong();
                class_1923 forceChunkPos = new class_1923(i);
                serverChunkProvider.method_12124(forceChunkPos, true);
            }
        }
    }

    private CompletionStage<Boolean> saveTemplate(WorldTemplate template) {
        return this.server().dataPackManager().save((DataPackEntry)template).thenApply(b -> true);
    }

    private CompletableFuture<Optional<WorldTemplate>> loadTemplate(DataPack<WorldTemplate> pack, ResourceKey key) {
        if (this.server().dataPackManager().exists(pack, key)) {
            return this.server().dataPackManager().load(pack, key).exceptionally(e -> {
                e.printStackTrace();
                return Optional.empty();
            });
        }
        return CompletableFuture.completedFuture(Optional.empty());
    }

    public static class_5321<class_1937> createRegistryKey(ResourceKey key) {
        return class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)((class_2960)key));
    }

    private String getDirectoryName(ResourceKey key) {
        if (DefaultWorldKeys.DEFAULT.equals((Object)key)) {
            return "";
        }
        if (DefaultWorldKeys.THE_NETHER.equals((Object)key)) {
            return "DIM-1";
        }
        if (DefaultWorldKeys.THE_END.equals((Object)key)) {
            return "DIM1";
        }
        return key.value();
    }

    private Path getDirectory(ResourceKey key) {
        if (DefaultWorldKeys.DEFAULT.equals((Object)key)) {
            return this.defaultWorldDirectory;
        }
        if (DefaultWorldKeys.THE_NETHER.equals((Object)key)) {
            return this.defaultWorldDirectory.resolve("DIM-1");
        }
        if (DefaultWorldKeys.THE_END.equals((Object)key)) {
            return this.defaultWorldDirectory.resolve("DIM1");
        }
        return this.customWorldsDirectory.resolve(key.namespace()).resolve(key.value());
    }

    private boolean isVanillaWorld(ResourceKey key) {
        return DefaultWorldKeys.DEFAULT.equals((Object)key) || DefaultWorldKeys.THE_NETHER.equals((Object)key) || DefaultWorldKeys.THE_END.equals((Object)key);
    }

    private boolean isVanillaSubWorld(String directoryName) {
        return "DIM-1".equals(directoryName) || "DIM1".equals(directoryName);
    }

    private Path getConfigFile(ResourceKey key) {
        return SpongeConfigs.getDirectory().resolve("worlds").resolve(key.namespace()).resolve(key.value() + ".conf");
    }

    private static class_31.class_7729 specialWorldProperty(class_5363 stem) {
        class_2794 generator = stem.comp_1013();
        if (generator instanceof class_2891) {
            return class_31.class_7729.field_40375;
        }
        return generator instanceof class_2897 ? class_31.class_7729.field_40374 : class_31.class_7729.field_40373;
    }
}

