/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.server;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.minecraft.class_1267;
import net.minecraft.class_1934;
import net.minecraft.class_2378;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataManipulator;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.data.persistence.StringDataFormat;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.datapack.DataPacks;
import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.api.world.WorldType;
import org.spongepowered.api.world.WorldTypes;
import org.spongepowered.api.world.biome.provider.BiomeProvider;
import org.spongepowered.api.world.generation.ChunkGenerator;
import org.spongepowered.api.world.generation.config.noise.NoiseGeneratorConfig;
import org.spongepowered.api.world.generation.config.noise.NoiseGeneratorConfigs;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.server.WorldTemplate;
import org.spongepowered.api.world.server.storage.ServerWorldProperties;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.world.level.dimension.LevelStemBridge;
import org.spongepowered.common.bridge.world.level.storage.ServerLevelDataBridge;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.data.fixer.SpongeDataCodec;
import org.spongepowered.common.data.holder.SpongeDataHolder;
import org.spongepowered.common.data.provider.DataProviderLookup;
import org.spongepowered.common.serialization.EnumCodec;
import org.spongepowered.common.serialization.MathCodecs;
import org.spongepowered.common.util.AbstractResourceKeyedBuilder;
import org.spongepowered.math.vector.Vector3i;

public final class SpongeWorldTemplate
extends Record
implements WorldTemplate,
SpongeDataHolder {
    private final ResourceKey key;
    private final class_5363 levelStem;
    private final DataPack<WorldTemplate> pack;
    public static final Codec<class_5363> CODEC = RecordCodecBuilder.create($$0 -> $$0.group((App)class_2874.field_24756.fieldOf("type").forGetter(class_5363::comp_1012), (App)class_2794.field_24746.fieldOf("generator").forGetter(class_5363::comp_1013)).apply((Applicative)$$0, $$0.stable(class_5363::new)));
    private static final Codec<SpongeDataSection> SPONGE_CODEC = RecordCodecBuilder.create(r -> r.group((App)SpongeAdventure.STRING_CODEC.optionalFieldOf("display_name").forGetter(v -> Optional.ofNullable(v.displayName)), (App)class_2960.field_25139.optionalFieldOf("game_mode").forGetter(v -> Optional.ofNullable(v.gameMode).map(t -> class_2960.method_60655((String)"sponge", (String)t.method_8381()))), (App)class_2960.field_25139.optionalFieldOf("difficulty").forGetter(v -> Optional.ofNullable(v.difficulty).map(t -> class_2960.method_60655((String)"sponge", (String)t.method_5460()))), (App)EnumCodec.create(SerializationBehavior.class).optionalFieldOf("serialization_behavior").forGetter(v -> Optional.ofNullable(v.serializationBehavior)), (App)Codec.INT.optionalFieldOf("view_distance").forGetter(v -> Optional.ofNullable(v.viewDistance)), (App)MathCodecs.VECTOR_3i.optionalFieldOf("spawn_position").forGetter(v -> Optional.ofNullable(v.spawnPosition)), (App)Codec.BOOL.optionalFieldOf("load_on_startup").forGetter(v -> Optional.ofNullable(v.loadOnStartup)), (App)Codec.BOOL.optionalFieldOf("performs_spawn_logic").forGetter(v -> Optional.ofNullable(v.performsSpawnLogic)), (App)Codec.BOOL.optionalFieldOf("hardcore").forGetter(v -> Optional.ofNullable(v.hardcore)), (App)Codec.BOOL.optionalFieldOf("commands").forGetter(v -> Optional.ofNullable(v.commands)), (App)Codec.BOOL.optionalFieldOf("pvp").forGetter(v -> Optional.ofNullable(v.pvp)), (App)Codec.LONG.optionalFieldOf("seed").forGetter(v -> Optional.ofNullable(v.seed))).apply((Applicative)r, (f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12) -> new SpongeDataSection(f1.orElse(null), f2.map(l -> class_1934.method_8385((String)l.method_12832())).orElse(null), f3.map(l -> class_1267.method_16691((String)l.method_12832())).orElse(null), f4.orElse(null), f5.orElse(null), f6.orElse(null), f7.orElse(null), f8.orElse(null), f9.orElse(null), f10.orElse(null), f11.orElse(null), f12.orElse(null))));
    public static final Codec<class_5363> DIRECT_CODEC = new MapCodec.MapCodecCodec(new SpongeDataCodec<class_5363, SpongeDataSection>(class_5363.field_25411, SPONGE_CODEC, (type, data) -> ((LevelStemBridge)type).bridge$decorateData((SpongeDataSection)data), type -> ((LevelStemBridge)type).bridge$createData()));

    public SpongeWorldTemplate(ResourceKey key, class_5363 levelStem, DataPack<WorldTemplate> pack) {
        this.key = key;
        this.levelStem = levelStem;
        this.pack = pack;
    }

    @Override
    public List<DataHolder> impl$delegateDataHolder() {
        return List.of((DataHolder)this.levelStem, this);
    }

    public static class_5363 decodeStem(JsonElement pack, class_5455 registryAccess) {
        class_6903 ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)registryAccess);
        SpongeWorldTemplate.fixDimensionDatapack(pack);
        return (class_5363)class_5363.field_25411.parse((DynamicOps)ops, (Object)pack).getOrThrow();
    }

    public static WorldTemplate decode(DataPack<WorldTemplate> pack, ResourceKey key, JsonElement packEntry, class_5455 registryAccess) {
        class_5363 stem = SpongeWorldTemplate.decodeStem(packEntry, registryAccess);
        return new SpongeWorldTemplate(key, stem, pack);
    }

    public static JsonElement encode(WorldTemplate s, class_5455 registryAccess) {
        if (s instanceof SpongeWorldTemplate) {
            SpongeWorldTemplate t = (SpongeWorldTemplate)s;
            class_6903 ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)registryAccess);
            return (JsonElement)DIRECT_CODEC.encodeStart((DynamicOps)ops, (Object)t.levelStem).getOrThrow();
        }
        throw new IllegalArgumentException("WorldTemplate is not a SpongeWorldTemplate");
    }

    private static void fixDimensionDatapack(JsonElement element) {
        try {
            JsonObject biomeSource = element.getAsJsonObject().getAsJsonObject("generator").getAsJsonObject("biome_source");
            if ("minecraft:vanilla_layered".equals(biomeSource.get("type").getAsString())) {
                biomeSource.addProperty("type", "minecraft:multi_noise");
                biomeSource.addProperty("preset", "minecraft:overworld");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int contentVersion() {
        return 0;
    }

    public DataContainer toContainer() {
        JsonElement serialized = SpongeWorldTemplate.encode(this, (class_5455)SpongeCommon.server().method_30611());
        try {
            DataContainer container = ((StringDataFormat)DataFormats.JSON.get()).read(serialized.toString());
            container.set(Queries.CONTENT_VERSION, (Object)this.contentVersion());
            return container;
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read deserialized LevelStem:\n" + String.valueOf(serialized), e);
        }
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SpongeWorldTemplate.class, "key;levelStem;pack", "key", "levelStem", "pack"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SpongeWorldTemplate.class, "key;levelStem;pack", "key", "levelStem", "pack"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SpongeWorldTemplate.class, "key;levelStem;pack", "key", "levelStem", "pack"}, this, o);
    }

    public ResourceKey key() {
        return this.key;
    }

    public class_5363 levelStem() {
        return this.levelStem;
    }

    public DataPack<WorldTemplate> pack() {
        return this.pack;
    }

    public record SpongeDataSection(@Nullable Component displayName, @Nullable class_1934 gameMode, @Nullable class_1267 difficulty, @Nullable SerializationBehavior serializationBehavior, @Nullable Integer viewDistance, @Nullable Vector3i spawnPosition, @Nullable Boolean loadOnStartup, @Nullable Boolean performsSpawnLogic, @Nullable Boolean hardcore, @Nullable Boolean commands, @Nullable Boolean pvp, @Nullable Long seed) {
    }

    public static final class FactoryImpl
    implements WorldTemplate.Factory {
        public WorldTemplate overworld() {
            return (WorldTemplate)((WorldTemplate.Builder)new BuilderImpl().reset().key(ResourceKey.minecraft((String)"overworld"))).add(Keys.WORLD_TYPE, (Object)((WorldType)WorldTypes.OVERWORLD.get())).add(Keys.CHUNK_GENERATOR, (Object)ChunkGenerator.overworld()).add(Keys.PERFORM_SPAWN_LOGIC, (Object)true).build();
        }

        public WorldTemplate overworldCaves() {
            return (WorldTemplate)((WorldTemplate.Builder)new BuilderImpl().reset().key(ResourceKey.minecraft((String)"overworld_caves"))).add(Keys.WORLD_TYPE, (Object)((WorldType)WorldTypes.OVERWORLD.get())).add(Keys.CHUNK_GENERATOR, (Object)ChunkGenerator.noise((BiomeProvider)BiomeProvider.overworld(), (NoiseGeneratorConfig)((NoiseGeneratorConfig)NoiseGeneratorConfigs.CAVES.get()))).add(Keys.PERFORM_SPAWN_LOGIC, (Object)true).build();
        }

        public WorldTemplate theNether() {
            return (WorldTemplate)((WorldTemplate.Builder)new BuilderImpl().reset().key(ResourceKey.minecraft((String)"the_nether"))).add(Keys.WORLD_TYPE, (Object)((WorldType)WorldTypes.THE_NETHER.get())).add(Keys.CHUNK_GENERATOR, (Object)ChunkGenerator.theNether()).build();
        }

        public WorldTemplate theEnd() {
            return (WorldTemplate)((WorldTemplate.Builder)new BuilderImpl().reset().key(ResourceKey.minecraft((String)"the_end"))).add(Keys.WORLD_TYPE, (Object)((WorldType)WorldTypes.THE_END.get())).add(Keys.CHUNK_GENERATOR, (Object)ChunkGenerator.theEnd()).build();
        }
    }

    public static final class BuilderImpl
    extends AbstractResourceKeyedBuilder<WorldTemplate, WorldTemplate.Builder>
    implements WorldTemplate.Builder {
        private static final DataProviderLookup PROVIDER_LOOKUP = SpongeDataManager.getProviderRegistry().getProviderLookup(class_5363.class);
        private DataManipulator.Mutable data = DataManipulator.mutableOf();
        private DataPack<WorldTemplate> pack = DataPacks.WORLD;

        public <V> WorldTemplate.Builder add(Key<? extends Value<V>> key, V value) {
            if (!PROVIDER_LOOKUP.getProvider(key).isSupported(class_5363.class)) {
                throw new IllegalArgumentException(String.valueOf(key) + " is not supported for world templates");
            }
            this.data.set(key, value);
            return this;
        }

        public WorldTemplate.Builder reset() {
            super.reset();
            this.key = null;
            this.data = DataManipulator.mutableOf();
            this.data.set(Keys.WORLD_TYPE, (Object)((WorldType)WorldTypes.OVERWORLD.get()));
            this.data.set(Keys.CHUNK_GENERATOR, (Object)ChunkGenerator.overworld());
            this.pack = DataPacks.WORLD;
            return this;
        }

        public WorldTemplate.Builder from(WorldTemplate template) {
            this.key = Objects.requireNonNull(template, "template").key();
            this.data = DataManipulator.mutableOf((Iterable)template.getValues());
            this.pack = template.pack();
            return this;
        }

        public WorldTemplate.Builder fromDataPack(DataView pack) throws IOException {
            JsonElement json = JsonParser.parseString((String)((StringDataFormat)DataFormats.JSON.get()).write(pack));
            class_5363 levelStem = SpongeWorldTemplate.decodeStem(json, (class_5455)SpongeCommon.server().method_30611());
            return this.from(levelStem);
        }

        public WorldTemplate.Builder from(ServerWorld world) {
            this.from(world.properties());
            this.data.set(Keys.CHUNK_GENERATOR, (Object)world.generator());
            return this;
        }

        public WorldTemplate.Builder pack(DataPack<WorldTemplate> pack) {
            this.pack = pack;
            return this;
        }

        public WorldTemplate.Builder from(ServerWorldProperties properties) {
            ServerLevelDataBridge bridge = (ServerLevelDataBridge)properties;
            this.key = properties.key();
            properties.displayName().ifPresent(name -> this.data.set(Keys.DISPLAY_NAME, name));
            this.data.set(Keys.WORLD_TYPE, (Object)properties.worldType());
            if (bridge.bridge$customGameType()) {
                this.data.set(Keys.GAME_MODE, (Object)properties.gameMode());
            }
            if (bridge.bridge$customDifficulty()) {
                this.data.set(Keys.WORLD_DIFFICULTY, (Object)properties.difficulty());
            }
            bridge.bridge$serializationBehavior().ifPresent(s -> this.data.set(Keys.SERIALIZATION_BEHAVIOR, s));
            bridge.bridge$viewDistance().ifPresent(v -> this.data.set(Keys.VIEW_DISTANCE, v));
            if (bridge.bridge$customSpawnPosition()) {
                this.data.set(Keys.SPAWN_POSITION, (Object)properties.spawnPosition());
            }
            this.data.set(Keys.IS_LOAD_ON_STARTUP, (Object)properties.loadOnStartup());
            this.data.set(Keys.PERFORM_SPAWN_LOGIC, (Object)properties.performsSpawnLogic());
            this.data.set(Keys.HARDCORE, (Object)properties.hardcore());
            this.data.set(Keys.COMMANDS, (Object)properties.commands());
            this.data.set(Keys.PVP, (Object)properties.pvp());
            return this;
        }

        private WorldTemplate.Builder from(class_5363 levelStem) {
            this.data.set((Iterable)((DataHolder)levelStem).getValues());
            return this;
        }

        @Override
        protected WorldTemplate build0() {
            ChunkGenerator chunkGenerator = (ChunkGenerator)this.data.require(Keys.CHUNK_GENERATOR);
            class_6880<class_2874> dimensionType = BuilderImpl.dimensionTypeHolder((WorldType)this.data.require(Keys.WORLD_TYPE));
            class_5363 levelStem = new class_5363(dimensionType, (class_2794)chunkGenerator);
            ((LevelStemBridge)levelStem).bridge$decorateData((DataManipulator)this.data);
            return new SpongeWorldTemplate(this.key, levelStem, this.pack);
        }

        private static @NonNull class_6880<class_2874> dimensionTypeHolder(WorldType worldType) {
            class_2378 dimensionTypeRegistry = SpongeCommon.server().method_30611().method_30530(class_7924.field_41241);
            class_2960 key = dimensionTypeRegistry.method_10221((Object)((class_2874)worldType));
            if (key == null) {
                return class_6880.method_40223((Object)((class_2874)worldType));
            }
            return dimensionTypeRegistry.method_46747(class_5321.method_29179((class_5321)class_7924.field_41241, (class_2960)key));
        }
    }
}

