/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.server;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.OptionalLong;
import java.util.function.Function;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7134;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.DataManipulator;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.data.persistence.StringDataFormat;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.datapack.DataPacks;
import org.spongepowered.api.tag.Tag;
import org.spongepowered.api.util.MinecraftDayTime;
import org.spongepowered.api.util.Range;
import org.spongepowered.api.world.WorldType;
import org.spongepowered.api.world.WorldTypeEffect;
import org.spongepowered.api.world.WorldTypeTemplate;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.world.level.dimension.DimensionTypeBridge;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.data.holder.SpongeDataHolder;
import org.spongepowered.common.data.provider.DataProviderLookup;
import org.spongepowered.common.util.AbstractDataPackEntryBuilder;
import org.spongepowered.common.world.server.SpongeDimensionTypes;

public final class SpongeWorldTypeTemplate
extends Record
implements WorldTypeTemplate,
SpongeDataHolder {
    private final ResourceKey key;
    private final class_2874 dimensionType;
    private final DataPack<WorldTypeTemplate> pack;

    public SpongeWorldTypeTemplate(ResourceKey key, class_2874 dimensionType, DataPack<WorldTypeTemplate> pack) {
        this.key = key;
        this.dimensionType = dimensionType;
        this.pack = pack;
    }

    public static class_2874 decode(JsonElement json, class_5455 registryAccess) {
        class_6903 ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)registryAccess);
        return (class_2874)SpongeDimensionTypes.DIRECT_CODEC.parse((DynamicOps)ops, (Object)json).getOrThrow();
    }

    public static WorldTypeTemplate decode(DataPack<WorldTypeTemplate> pack, ResourceKey key, JsonElement packEntry, class_5455 registryAccess) {
        class_2874 parsed = SpongeWorldTypeTemplate.decode(packEntry, registryAccess);
        return new SpongeWorldTypeTemplate(key, parsed, pack);
    }

    public static JsonElement encode(WorldTypeTemplate template, class_5455 registryAccess) {
        if (template instanceof SpongeWorldTypeTemplate) {
            SpongeWorldTypeTemplate t = (SpongeWorldTypeTemplate)template;
            class_6903 ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)registryAccess);
            return (JsonElement)SpongeDimensionTypes.DIRECT_CODEC.encodeStart((DynamicOps)ops, (Object)t.dimensionType).getOrThrow();
        }
        throw new IllegalArgumentException("WorldTypeTemplate is not a SpongeWorldTypeTemplate");
    }

    public int contentVersion() {
        return 0;
    }

    public DataContainer toContainer() {
        JsonElement serialized = SpongeWorldTypeTemplate.encode(this, (class_5455)SpongeCommon.server().method_30611());
        try {
            DataContainer container = ((StringDataFormat)DataFormats.JSON.get()).read(serialized.toString());
            container.set(Queries.CONTENT_VERSION, (Object)this.contentVersion());
            return container;
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read deserialized DimensionType:\n" + String.valueOf(serialized), e);
        }
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SpongeWorldTypeTemplate.class, "key;dimensionType;pack", "key", "dimensionType", "pack"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SpongeWorldTypeTemplate.class, "key;dimensionType;pack", "key", "dimensionType", "pack"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SpongeWorldTypeTemplate.class, "key;dimensionType;pack", "key", "dimensionType", "pack"}, this, o);
    }

    public ResourceKey key() {
        return this.key;
    }

    public class_2874 dimensionType() {
        return this.dimensionType;
    }

    public DataPack<WorldTypeTemplate> pack() {
        return this.pack;
    }

    public static final class BuilderImpl
    extends AbstractDataPackEntryBuilder<WorldType, WorldTypeTemplate, WorldTypeTemplate.Builder>
    implements WorldTypeTemplate.Builder {
        private static final DataProviderLookup PROVIDER_LOOKUP = SpongeDataManager.getProviderRegistry().getProviderLookup(class_2874.class);
        private DataManipulator.Mutable data = DataManipulator.mutableOf();

        public BuilderImpl() {
            this.reset();
        }

        @Override
        public Function<WorldTypeTemplate, WorldType> valueExtractor() {
            return w -> (WorldType)((SpongeWorldTypeTemplate)w).dimensionType;
        }

        public <V> WorldTypeTemplate.Builder add(Key<? extends Value<V>> key, V value) {
            if (!PROVIDER_LOOKUP.getProvider(key).isSupported(class_2874.class)) {
                throw new IllegalArgumentException(String.valueOf(key) + " is not supported for world types");
            }
            this.data.set(key, value);
            return this;
        }

        public WorldTypeTemplate.Builder reset() {
            this.data = DataManipulator.mutableOf();
            this.key = null;
            this.pack = DataPacks.WORLD_TYPE;
            class_2874 defaultOverworld = (class_2874)SpongeCommon.vanillaRegistry(class_7924.field_41241).method_29107(class_7134.field_37666);
            this.fromValue((WorldType)defaultOverworld);
            return this;
        }

        public WorldTypeTemplate.Builder fromValue(WorldType type) {
            this.data.set((Iterable)type.getValues());
            return this;
        }

        public WorldTypeTemplate.Builder fromDataPack(DataView pack) throws IOException {
            JsonElement json = JsonParser.parseString((String)((StringDataFormat)DataFormats.JSON.get()).write(pack));
            DataResult parsed = class_2874.field_24756.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
            class_2874 dimensionType = (class_2874)((class_6880)parsed.getOrThrow()).comp_349();
            this.fromValue((WorldType)dimensionType);
            return this;
        }

        @Override
        public WorldTypeTemplate.Builder from(WorldType type) {
            this.data.set((Iterable)type.getValues());
            return this;
        }

        @Override
        public @NonNull WorldTypeTemplate build0() {
            @Nullable WorldTypeEffect effect = (WorldTypeEffect)this.data.getOrNull(Keys.WORLD_TYPE_EFFECT);
            boolean scorching = (Boolean)this.data.require(Keys.SCORCHING);
            boolean natural = (Boolean)this.data.require(Keys.NATURAL_WORLD_TYPE);
            double coordinateMultiplier = (Double)this.data.require(Keys.COORDINATE_MULTIPLIER);
            boolean hasSkylight = (Boolean)this.data.require(Keys.HAS_SKYLIGHT);
            boolean hasCeiling = (Boolean)this.data.require(Keys.HAS_CEILING);
            float ambientLighting = ((Float)this.data.require(Keys.AMBIENT_LIGHTING)).floatValue();
            @Nullable MinecraftDayTime fixedTime = (MinecraftDayTime)this.data.getOrNull(Keys.FIXED_TIME);
            boolean bedsUsable = (Boolean)this.data.require(Keys.BEDS_USABLE);
            boolean respawnAnchorsUsable = (Boolean)this.data.require(Keys.RESPAWN_ANCHOR_USABLE);
            int floor = (Integer)this.data.require(Keys.WORLD_FLOOR);
            int height = (Integer)this.data.require(Keys.WORLD_HEIGHT);
            int logicalHeight = (Integer)this.data.require(Keys.WORLD_LOGICAL_HEIGHT);
            @Nullable Tag infiniburn = (Tag)this.data.getOrNull(Keys.INFINIBURN);
            boolean piglinSafe = (Boolean)this.data.require(Keys.PIGLIN_SAFE);
            boolean hasRaids = (Boolean)this.data.require(Keys.HAS_RAIDS);
            int monsterSpawnBlockLightLimit = (Integer)this.data.getOrElse(Keys.SPAWN_LIGHT_LIMIT, (Object)0);
            Range lightRange = (Range)this.data.getOrElse(Keys.SPAWN_LIGHT_RANGE, (Object)Range.intRange((Integer)0, (Integer)7));
            boolean createDragonFight = (Boolean)this.data.getOrElse(Keys.CREATE_DRAGON_FIGHT, (Object)false);
            class_6019 monsterSpawnLightTest = class_6019.method_35017((int)((Integer)lightRange.min()), (int)((Integer)lightRange.max()));
            SpongeDimensionTypes.SpongeDataSection spongeData = new SpongeDimensionTypes.SpongeDataSection(createDragonFight);
            try {
                class_2874 dimensionType;
                class_2874 class_28742 = dimensionType = new class_2874(fixedTime == null ? OptionalLong.empty() : OptionalLong.of(fixedTime.asTicks().ticks()), hasSkylight, hasCeiling, scorching, natural, coordinateMultiplier, bedsUsable, respawnAnchorsUsable, floor, height, logicalHeight, (class_6862)infiniburn, (class_2960)effect.key(), ambientLighting, new class_2874.class_7512(piglinSafe, hasRaids, (class_6017)monsterSpawnLightTest, monsterSpawnBlockLightLimit));
                if (class_28742 instanceof DimensionTypeBridge) {
                    DimensionTypeBridge bridge = (DimensionTypeBridge)class_28742;
                    bridge.bridge$decorateData(spongeData);
                }
                return new SpongeWorldTypeTemplate(this.key, dimensionType, (DataPack<WorldTypeTemplate>)this.pack);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException(String.format("Template '%s' was not valid!", this.key), e);
            }
        }
    }
}

