/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.storage;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Server;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.world.server.SpongeWorldManager;

public final class SpongePlayerDataManager {
    private static final String SPONGE_DATA = "sponge";
    private final Server server;
    private final Path playersDirectory;

    public SpongePlayerDataManager(Server server) {
        this.server = server;
        this.playersDirectory = ((SpongeWorldManager)this.server.worldManager()).getDefaultWorldDirectory().resolve("data").resolve(SPONGE_DATA);
    }

    public void readLegacyPlayerData(ServerPlayer playerEntity, class_2487 compound, @Nullable Instant creation) {
        Path playerFile;
        if (creation == null) {
            creation = Instant.now();
        }
        Instant lastPlayed = creation;
        if (compound.method_10573("bukkit", 10)) {
            class_2487 bukkitCompound = compound.method_10562("bukkit");
            creation = Instant.ofEpochMilli(bukkitCompound.method_10537("firstPlayed"));
            lastPlayed = Instant.ofEpochMilli(bukkitCompound.method_10537("lastPlayed"));
        }
        if (compound.method_10573("Canary", 10)) {
            class_2487 canaryCompound = compound.method_10562("Canary");
            creation = Instant.ofEpochMilli(canaryCompound.method_10537("FirstJoin"));
            lastPlayed = Instant.ofEpochMilli(canaryCompound.method_10537("LastJoin"));
        }
        if (Files.isReadable(playerFile = this.playersDirectory.resolve(String.valueOf(playerEntity.uniqueId()) + ".dat"))) {
            try (InputStream stream = Files.newInputStream(playerFile, new OpenOption[0]);){
                class_2487 playerFileCompound = class_2507.method_10629((InputStream)stream, (class_2505)class_2505.method_53898());
                creation = Instant.ofEpochMilli(playerFileCompound.method_10537(Constants.Sponge.PlayerData.PLAYER_DATA_JOIN.toString()));
                lastPlayed = Instant.ofEpochMilli(playerFileCompound.method_10537(Constants.Sponge.PlayerData.PLAYER_DATA_LAST.toString()));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to decompress playerdata for playerfile " + String.valueOf(playerFile), e);
            }
        }
        playerEntity.offer(Keys.FIRST_DATE_JOINED, (Object)creation);
        playerEntity.offer(Keys.LAST_DATE_JOINED, (Object)lastPlayed);
        playerEntity.offer(Keys.LAST_DATE_PLAYED, (Object)lastPlayed);
    }

    public void deleteLegacyPlayerData(ServerPlayer playerEntity) {
        Path playerFile = this.playersDirectory.resolve(String.valueOf(playerEntity.uniqueId()) + ".dat");
        if (Files.isRegularFile(playerFile, new LinkOption[0])) {
            try {
                Files.delete(playerFile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

