/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.volume;

import java.util.Objects;
import java.util.StringJoiner;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.math.vector.Vector3i;

final class ChunkCursor {
    final int chunkX;
    final int xOffset;
    final int chunkZ;
    final int zOffset;
    final int ySection;
    final int yOffset;

    ChunkCursor(Vector3i pos) {
        this.chunkX = pos.x() >> 4;
        this.xOffset = pos.x() & 0xF;
        this.chunkZ = pos.z() >> 4;
        this.zOffset = pos.z() & 0xF;
        this.ySection = pos.y() >> 4 << 4;
        this.yOffset = pos.y() & 0xF;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChunkCursor that = (ChunkCursor)o;
        return this.chunkX == that.chunkX && this.xOffset == that.xOffset && this.chunkZ == that.chunkZ && this.zOffset == that.zOffset && this.ySection == that.ySection && this.yOffset == that.yOffset;
    }

    public int hashCode() {
        return Objects.hash(this.chunkX, this.xOffset, this.chunkZ, this.zOffset, this.ySection, this.yOffset);
    }

    public String toString() {
        return new StringJoiner(", ", "ChunkCursor[", "]").add("chunkX=" + this.chunkX).add("xOffset=" + this.xOffset).add("chunkZ=" + this.chunkZ).add("zOffset=" + this.zOffset).add("ySection=" + this.ySection).add("yOffset=" + this.yOffset).toString();
    }
}

