/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.volume;

import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2821;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_3218;
import net.minecraft.class_3545;
import net.minecraft.class_3730;
import net.minecraft.class_4076;
import net.minecraft.class_4538;
import net.minecraft.class_5572;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.block.entity.BlockEntityArchetype;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.volume.Volume;
import org.spongepowered.api.world.volume.game.Region;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeElement;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.common.accessor.client.multiplayer.ClientLevelAccessor;
import org.spongepowered.common.accessor.server.level.ServerLevelAccessor;
import org.spongepowered.common.accessor.world.level.block.entity.BlockEntityAccessor;
import org.spongepowered.common.accessor.world.level.entity.PersistentEntitySectionManagerAccessor;
import org.spongepowered.common.accessor.world.level.entity.TransientEntitySectionManagerAccessor;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.volume.ChunkCursor;
import org.spongepowered.common.world.volume.SpongeVolumeStream;
import org.spongepowered.common.world.volume.buffer.biome.ObjectArrayMutableBiomeBuffer;
import org.spongepowered.common.world.volume.buffer.block.ArrayMutableBlockBuffer;
import org.spongepowered.common.world.volume.buffer.blockentity.ObjectArrayMutableBlockEntityBuffer;
import org.spongepowered.common.world.volume.buffer.entity.ObjectArrayMutableEntityBuffer;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public final class VolumeStreamUtils {
    private VolumeStreamUtils() {
    }

    public static <T> Supplier<T> createWeaklyReferencedSupplier(T object, String name) {
        WeakReference weakReference = new WeakReference(object);
        return () -> {
            @Nullable T weaklyReferenced = weakReference.get();
            return Objects.requireNonNull(weaklyReferenced, () -> String.format("%s de-referenced!", name));
        };
    }

    public static <MC, T> Registry<T> nativeToSpongeRegistry(class_2378<MC> registry) {
        return (Registry)registry;
    }

    public static Predicate<Tuple<Vector3d, EntityArchetype>> entityArchetypePositionFilter(Vector3i min, Vector3i max) {
        return VolumeStreamUtils.filterPositions(tuple -> ((Vector3d)tuple.first()).toInt(), min, max);
    }

    public static Predicate<Map.Entry<Vector3i, BlockEntityArchetype>> blockEntityArchetypePositionFilter(Vector3i min, Vector3i max) {
        return VolumeStreamUtils.filterPositions(Map.Entry::getKey, min, max);
    }

    public static <T> Predicate<T> filterPositions(Function<T, Vector3i> pos, Vector3i min, Vector3i max) {
        return entity -> {
            Vector3i apply = (Vector3i)pos.apply(entity);
            return apply.x() >= min.x() && apply.x() <= max.x() && apply.y() >= min.y() && apply.y() <= max.y() && apply.z() >= min.z() && apply.z() <= max.z();
        };
    }

    public static <R extends Region<R>> BiFunction<R, class_1923, @Nullable class_2791> getChunkAccessorByStatus(class_4538 worldReader, boolean shouldGenerate) {
        Supplier<class_4538> readerSupplier = VolumeStreamUtils.createWeaklyReferencedSupplier(worldReader, "IWorldReader");
        return (world, chunkPos) -> {
            class_2806 chunkStatus = shouldGenerate ? class_2806.field_12803 : class_2806.field_12798;
            @Nullable class_2791 ichunk = ((class_4538)readerSupplier.get()).method_8402(chunkPos.field_9181, chunkPos.field_9180, chunkStatus, shouldGenerate);
            if (shouldGenerate) {
                Objects.requireNonNull(ichunk, "Chunk was expected to load fully and generate, but somehow got a null chunk!");
            }
            if (ichunk instanceof class_2821) {
                return ((class_2821)ichunk).method_12240();
            }
            return ichunk;
        };
    }

    public static Function<class_2791, Stream<Map.Entry<class_2338, class_1959>>> getBiomesForChunkByPos(class_4538 reader, Vector3i min, Vector3i max) {
        return VolumeStreamUtils.getElementByPosition(VolumeStreamUtils.chunkSectionBiomeGetter().asTri(reader), min, max);
    }

    public static Function<class_2791, Stream<Map.Entry<class_2338, class_2680>>> getBlockStatesForSections(Vector3i min, Vector3i max) {
        return VolumeStreamUtils.getElementByPosition(VolumeStreamUtils.chunkSectionBlockStateGetter(), min, max);
    }

    public static boolean setBiomeOnNativeChunk(int x, int y, int z, Biome biome, Supplier<@Nullable class_2826> accessor, Runnable finalizer) {
        @Nullable class_2826 section = accessor.get();
        if (section == null) {
            return false;
        }
        int maskedX = x & 3;
        int maskedY = y & 3;
        int maskedZ = z & 3;
        class_6880 old = (class_6880)((class_2841)section.method_38294()).method_12328(maskedX, maskedY, maskedZ, (Object)class_6880.method_40223((Object)((class_1959)biome)));
        if (old.comp_349() == biome) {
            return false;
        }
        finalizer.run();
        return true;
    }

    public static void validateStreamArgs(Vector3i min, Vector3i max, StreamOptions options) {
        Objects.requireNonNull(min, "Minimum coordinates cannot be null");
        Objects.requireNonNull(max, "Maximum coordinates cannot be null");
        Objects.requireNonNull(options, "StreamOptions cannot be null!");
        if (min.x() > max.x()) {
            throw new IllegalArgumentException("Min(x) must be greater than max(x)!");
        }
        if (min.y() > max.y()) {
            throw new IllegalArgumentException("Min(y) must be greater than max y!");
        }
        if (min.z() > max.z()) {
            throw new IllegalArgumentException("Min(z) must be greater than max z!");
        }
    }

    public static void validateStreamArgs(Vector3i min, Vector3i max, Vector3i existingMin, Vector3i existingMax, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(min, max, options);
        if (existingMin.x() > min.x() || existingMin.y() > min.y() || existingMin.z() > min.z()) {
            throw new IllegalArgumentException(String.format("Minimum %s cannot be lower than the current minimum coordinates: %s", min, existingMin));
        }
        if (existingMax.x() < max.x() || existingMax.y() < max.y() || existingMax.z() < max.z()) {
            throw new IllegalArgumentException(String.format("Maximum %s cannot be greater than the current maximum coordinates: %s", max, existingMax));
        }
    }

    public static @NonNull Stream<Map.Entry<class_2338, class_1297>> getEntitiesFromChunk(Vector3i min, Vector3i max, class_2818 chunk) {
        if (chunk.method_12200() instanceof class_3218) {
            return ((PersistentEntitySectionManagerAccessor)((ServerLevelAccessor)chunk.method_12200()).accessor$getEntityManager()).accessor$sectionStorage().method_31782(chunk.method_12004().method_8324()).flatMap(class_5572::method_31766).filter(entity -> VecHelper.inBounds(entity.method_24515(), min, max)).map(entity -> new AbstractMap.SimpleEntry<class_2338, class_1297>(entity.method_24515(), (class_1297)entity));
        }
        if (Sponge.isClientAvailable() && chunk.method_12200() instanceof class_638) {
            return ((TransientEntitySectionManagerAccessor)((ClientLevelAccessor)chunk.method_12200()).accessor$getEntityStorage()).accessor$sectionStorage().method_31782(chunk.method_12004().method_8324()).flatMap(class_5572::method_31766).filter(entity -> VecHelper.inBounds(entity.method_24515(), min, max)).map(entity -> new AbstractMap.SimpleEntry<class_2338, class_1297>(entity.method_24515(), (class_1297)entity));
        }
        throw new UnsupportedOperationException("Unknown Chunk Level Type");
    }

    public static @NonNull BiConsumer<UUID, class_1297> getOrCloneEntityWithVolume(boolean shouldCarbonCopy, @MonotonicNonNull ObjectArrayMutableEntityBuffer backingVolume, class_1937 level) {
        return shouldCarbonCopy ? (pos, entity) -> {
            class_2487 nbt = new class_2487();
            entity.method_5662(nbt);
            @Nullable class_1297 cloned = entity.method_5864().method_5883(level, class_3730.field_16462);
            Objects.requireNonNull(cloned, () -> String.format("EntityType[%s] creates a null Entity!", class_1299.method_5890((class_1299)entity.method_5864()))).method_5651(nbt);
            backingVolume.spawnEntity((Entity)cloned);
        } : (pos, tile) -> {};
    }

    public static @NonNull BiConsumer<class_2338, class_2586> getBlockEntityOrCloneToBackingVolume(boolean shouldCarbonCopy, ObjectArrayMutableBlockEntityBuffer backingVolume, @Nullable class_1937 level) {
        return shouldCarbonCopy ? (pos, tile) -> {
            class_2487 nbt = tile.method_38242((class_7225.class_7874)tile.method_10997().method_30349());
            class_2680 state = tile.method_11010();
            @Nullable class_2586 cloned = tile.method_11017().method_11032(pos, state);
            Objects.requireNonNull(cloned, () -> String.format("TileEntityType[%s] creates a null TileEntity!", class_2591.method_11033((class_2591)tile.method_11017()))).method_58690(nbt, (class_7225.class_7874)tile.method_10997().method_30349());
            if (level != null) {
                ((BlockEntityAccessor)cloned).accessor$level(level);
            }
            backingVolume.addBlockEntity(pos.method_10263(), pos.method_10264(), pos.method_10260(), (BlockEntity)cloned);
        } : (pos, tile) -> {};
    }

    public static BiConsumer<class_2338, class_2680> getOrCopyBlockState(boolean shouldCarbonCopy, ArrayMutableBlockBuffer backingVolume) {
        return (pos, blockState) -> {
            if (shouldCarbonCopy) {
                backingVolume.setBlock((class_2338)pos, (class_2680)blockState);
            }
        };
    }

    public static <R extends Region<R>> BiFunction<class_2338, R, class_3545<class_2338, class_2680>> getBlockStateFromThisOrCopiedVolume(boolean shouldCarbonCopy, ArrayMutableBlockBuffer backingVolume) {
        return (blockPos, world) -> {
            class_2680 tileEntity = shouldCarbonCopy ? backingVolume.getBlock((class_2338)blockPos) : ((class_4538)world).method_8320(blockPos);
            return new class_3545(blockPos, (Object)tileEntity);
        };
    }

    public static Predicate<class_1297> apiToImplPredicate(Predicate<? super class_1297> filter) {
        return entity -> entity instanceof class_1297 && filter.test((class_1297)entity);
    }

    public static boolean setBiome(class_2791 chunk, int x, int y, int z, Biome biome) {
        boolean result = VolumeStreamUtils.setBiome(chunk.method_38259(chunk.method_31602(y)), x, y, z, biome);
        if (result) {
            chunk.method_65063();
        }
        return result;
    }

    public static boolean setBiome(@Nullable class_2826 section, int x, int y, int z, Biome biome) {
        if (section == null) {
            return false;
        }
        int maskedX = x & 3;
        int maskedY = y & 3;
        int maskedZ = z & 3;
        return true;
    }

    private static QuadFunction<class_2791, class_2826, class_2338, class_4538, class_1959> chunkSectionBiomeGetter() {
        return (chunk, chunkSection, pos, world) -> {
            if (chunk.method_38259(chunk.method_31602(pos.method_10264())) == null) {
                if (chunk instanceof class_2818) {
                    return (class_1959)((class_2818)chunk).method_12200().method_16359(pos.method_10263(), pos.method_10264(), pos.method_10260()).comp_349();
                }
                return (class_1959)world.method_22387(pos.method_10263(), pos.method_10264(), pos.method_10260()).comp_349();
            }
            return (class_1959)chunk.method_16359(pos.method_10263(), pos.method_10264(), pos.method_10260()).comp_349();
        };
    }

    private static TriFunction<class_2791, class_2826, class_2338, class_2680> chunkSectionBlockStateGetter() {
        return (chunk, chunkSection, pos) -> chunkSection.method_12254(pos.method_10263() - (chunk.method_12004().field_9181 << 4), pos.method_10264() & 0xF, pos.method_10260() - (chunk.method_12004().field_9180 << 4));
    }

    private static <T> Function<class_2791, Stream<Map.Entry<class_2338, T>>> getElementByPosition(TriFunction<class_2791, class_2826, class_2338, T> elementAccessor, Vector3i min, Vector3i max) {
        ChunkCursor minCursor = new ChunkCursor(min);
        ChunkCursor maxCursor = new ChunkCursor(max);
        return chunk -> {
            class_1923 pos = chunk.method_12004();
            int xStart = pos.field_9181 == minCursor.chunkX ? minCursor.xOffset : 0;
            int xEnd = pos.field_9181 == maxCursor.chunkX ? maxCursor.xOffset : 15;
            int zStart = pos.field_9180 == minCursor.chunkZ ? minCursor.zOffset : 0;
            int zEnd = pos.field_9180 == maxCursor.chunkZ ? maxCursor.zOffset : 15;
            int chunkMinX = pos.field_9181 << 4;
            int chunkMinZ = pos.field_9180 << 4;
            class_2826[] sections = chunk.method_12006();
            return IntStream.range(0, sections.length).filter(i -> {
                int sectionY = class_4076.method_18688((int)chunk.method_31604(i));
                return sectionY >= minCursor.ySection && sectionY <= maxCursor.ySection;
            }).mapToObj(i -> IntStream.rangeClosed(zStart, zEnd).mapToObj(z -> IntStream.rangeClosed(xStart, xEnd).mapToObj(x -> {
                class_2826 chunkSection = sections[i];
                int sectionY = class_4076.method_18688((int)chunk.method_31604(i));
                int yStart = sectionY == minCursor.ySection ? minCursor.yOffset : 0;
                int yEnd = sectionY == maxCursor.ySection ? maxCursor.yOffset : 15;
                return IntStream.rangeClosed(yStart, yEnd).mapToObj(y -> {
                    int adjustedX = x + chunkMinX;
                    int adjustedY = y + sectionY;
                    int adjustedZ = z + chunkMinZ;
                    class_2338 blockPos = new class_2338(adjustedX, adjustedY, adjustedZ);
                    Object apply = Objects.requireNonNull(elementAccessor.apply((class_2791)chunk, chunkSection, blockPos), "Element cannot be null");
                    return new AbstractMap.SimpleEntry(blockPos, apply);
                });
            }))).flatMap(Function.identity()).flatMap(Function.identity()).flatMap(Function.identity());
        };
    }

    public static <W extends Region<W>> VolumeStream<W, BlockState> generateBlockStream(class_4538 reader, Vector3i min, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(Objects.requireNonNull(min, "min"), Objects.requireNonNull(max, "max"), Objects.requireNonNull(options, "options"));
        boolean shouldCarbonCopy = options.carbonCopy();
        Vector3i size = max.sub(min).add(1, 1, 1);
        ArrayMutableBlockBuffer backingVolume = shouldCarbonCopy ? new ArrayMutableBlockBuffer(min, size) : null;
        return VolumeStreamUtils.generateStream(min, max, options, (Region)reader, VolumeStreamUtils.getOrCopyBlockState(shouldCarbonCopy, backingVolume), VolumeStreamUtils.getChunkAccessorByStatus(reader, options.loadingStyle().generateArea()), (key, biome) -> key, VolumeStreamUtils.getBlockStatesForSections(min, max), VolumeStreamUtils.getBlockStateFromThisOrCopiedVolume(shouldCarbonCopy, backingVolume));
    }

    public static <R extends Region<R>> VolumeStream<R, BlockEntity> getBlockEntityStream(class_4538 reader, Vector3i min, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(Objects.requireNonNull(min, "min"), Objects.requireNonNull(max, "max"), Objects.requireNonNull(options, "options"));
        boolean shouldCarbonCopy = options.carbonCopy();
        Vector3i size = max.sub(min).add(1, 1, 1);
        ObjectArrayMutableBlockEntityBuffer backingVolume = shouldCarbonCopy ? new ObjectArrayMutableBlockEntityBuffer(min, size) : null;
        return VolumeStreamUtils.generateStream(min, max, options, (Region)reader, VolumeStreamUtils.getBlockEntityOrCloneToBackingVolume(shouldCarbonCopy, backingVolume, reader instanceof class_1937 ? (class_1937)reader : null), VolumeStreamUtils.getChunkAccessorByStatus(reader, options.loadingStyle().generateArea()), (key, tileEntity) -> key, chunk -> chunk instanceof class_2818 ? ((class_2818)chunk).method_12214().entrySet().stream().filter(entry -> VecHelper.inBounds((class_2338)entry.getKey(), min, max)) : Stream.empty(), (blockPos, world) -> {
            @Nullable class_2586 tileEntity = shouldCarbonCopy ? backingVolume.getTileEntity((class_2338)blockPos) : ((class_4538)world).method_8321(blockPos);
            return new class_3545(blockPos, (Object)tileEntity);
        });
    }

    public static <R extends Region<R>> VolumeStream<R, Biome> getBiomeStream(class_4538 reader, Vector3i min, Vector3i max, StreamOptions options) {
        ObjectArrayMutableBiomeBuffer backingVolume;
        VolumeStreamUtils.validateStreamArgs(Objects.requireNonNull(min, "min"), Objects.requireNonNull(max, "max"), Objects.requireNonNull(options, "options"));
        boolean shouldCarbonCopy = options.carbonCopy();
        Vector3i size = max.sub(min).add(1, 1, 1);
        if (shouldCarbonCopy) {
            class_2378 biomeRegistry = reader.method_30349().method_30530(class_7924.field_41236);
            backingVolume = new ObjectArrayMutableBiomeBuffer(min, size, VolumeStreamUtils.nativeToSpongeRegistry(biomeRegistry));
        } else {
            backingVolume = null;
        }
        return VolumeStreamUtils.generateStream(min, max, options, (Region)reader, (pos, biome) -> {
            if (shouldCarbonCopy) {
                backingVolume.setBiome((class_2338)pos, (class_1959)biome);
            }
        }, VolumeStreamUtils.getChunkAccessorByStatus(reader, options.loadingStyle().generateArea()), (key, biome) -> key, VolumeStreamUtils.getBiomesForChunkByPos(reader, min, max), (blockPos, world) -> {
            class_1959 biome = shouldCarbonCopy ? backingVolume.getNativeBiome(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()) : (class_1959)((class_4538)world).method_23753(blockPos).comp_349();
            return new class_3545(blockPos, (Object)biome);
        });
    }

    public static <R extends Volume, API, MC, Section, KeyReference> VolumeStream<R, API> generateStream(Vector3i min, Vector3i max, StreamOptions options, R ref, BiConsumer<KeyReference, MC> identityFunction, BiFunction<R, class_1923, Section> chunkAccessor, BiFunction<class_2338, MC, KeyReference> entityToKey, Function<Section, Stream<Map.Entry<class_2338, MC>>> entityAccessor, BiFunction<KeyReference, R, class_3545<class_2338, MC>> filteredPositionEntityAccessor) {
        Supplier<R> worldSupplier = VolumeStreamUtils.createWeaklyReferencedSupplier(ref, "World");
        class_2338 chunkMin = new class_2338(min.x() >> 4, 0, min.z() >> 4);
        class_2338 chunkMax = new class_2338(max.x() >> 4, 0, max.z() >> 4);
        Stream<Object> sectionStream = IntStream.rangeClosed(chunkMin.method_10263(), chunkMax.method_10263()).mapToObj(x -> IntStream.rangeClosed(chunkMin.method_10260(), chunkMax.method_10260()).mapToObj(z -> new class_1923(x, z))).flatMap(Function.identity()).map(pos -> chunkAccessor.apply(ref, (class_1923)pos));
        return VolumeStreamUtils.generateStreamInternal(options, identityFunction, entityToKey, entityAccessor, filteredPositionEntityAccessor, worldSupplier, sectionStream);
    }

    public static <R extends Volume, API, MC, Section, KeyReference> VolumeStream<R, API> generateStream(StreamOptions options, R ref, Section section, Function<Section, Stream<Map.Entry<class_2338, MC>>> entityAccessor, BiConsumer<KeyReference, MC> identityFunction, BiFunction<class_2338, MC, KeyReference> entityToKey, BiFunction<KeyReference, R, class_3545<class_2338, @Nullable MC>> filteredPositionEntityAccessor) {
        Supplier<R> worldSupplier = VolumeStreamUtils.createWeaklyReferencedSupplier(ref, "World");
        Stream<Section> sectionStream = Stream.of(section);
        return VolumeStreamUtils.generateStreamInternal(options, identityFunction, entityToKey, entityAccessor, filteredPositionEntityAccessor, worldSupplier, sectionStream);
    }

    private static <R extends Volume, API, MC, Section, KeyReference> SpongeVolumeStream<R, API> generateStreamInternal(StreamOptions options, BiConsumer<KeyReference, MC> identityFunction, BiFunction<class_2338, MC, KeyReference> entityToKey, Function<Section, Stream<Map.Entry<class_2338, MC>>> entityAccessor, BiFunction<KeyReference, R, class_3545<class_2338, MC>> filteredPositionEntityAccessor, Supplier<R> worldSupplier, Stream<Section> sectionStream) {
        Stream<Object> filteredPosStream;
        Function<class_3545, VolumeElement> elementGenerator = tuple -> {
            Supplier<Object> blockEntitySupplier = VolumeStreamUtils.createWeaklyReferencedSupplier(tuple.method_15441(), "Element");
            Vector3d blockEntityPos = VecHelper.toVector3d((class_2338)tuple.method_15442());
            return VolumeElement.of((Supplier)worldSupplier, blockEntitySupplier, (Vector3d)blockEntityPos);
        };
        BiConsumer<Map.Entry, Set> entryConsumer = (entry, poses) -> {
            class_2338 pos = (class_2338)entry.getKey();
            Object keyRef = entityToKey.apply(pos, entry.getValue());
            poses.add(keyRef);
            identityFunction.accept(keyRef, entry.getValue());
        };
        if (options.loadingStyle().immediateLoading()) {
            LinkedHashSet availableTileEntityPositions = new LinkedHashSet();
            sectionStream.filter(Objects::nonNull).map(entityAccessor).forEach(map -> map.forEach(entry -> entryConsumer.accept((Map.Entry)entry, availableTileEntityPositions)));
            filteredPosStream = availableTileEntityPositions.stream();
        } else {
            filteredPosStream = sectionStream.filter(Objects::nonNull).flatMap(chunk -> {
                LinkedHashSet blockEntityPoses = new LinkedHashSet();
                ((Stream)entityAccessor.apply(chunk)).forEach(entry -> entryConsumer.accept((Map.Entry)entry, blockEntityPoses));
                return blockEntityPoses.stream();
            });
        }
        Stream volumeStreamBacker = filteredPosStream.map(pos -> (class_3545)filteredPositionEntityAccessor.apply(pos, (Volume)worldSupplier.get())).filter(Objects::nonNull).filter(tuple -> Objects.nonNull(tuple.method_15441())).map(elementGenerator);
        return new SpongeVolumeStream(volumeStreamBacker, worldSupplier);
    }

    public static interface QuadFunction<A, B, C, D, Out> {
        public Out apply(A var1, B var2, C var3, D var4);

        default public TriFunction<A, B, C, Out> asTri(D d) {
            Supplier<D> dSupplier = VolumeStreamUtils.createWeaklyReferencedSupplier(d, "D");
            return (a, b, c) -> this.apply(a, b, c, dSupplier.get());
        }
    }

    public static interface TriFunction<A, B, C, Out> {
        public Out apply(A var1, B var2, C var3);
    }
}

