/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.volume.buffer.archetype.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.world.volume.Volume;
import org.spongepowered.api.world.volume.archetype.entity.EntityArchetypeEntry;
import org.spongepowered.api.world.volume.archetype.entity.EntityArchetypeVolume;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeElement;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.common.world.volume.SpongeVolumeStream;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.common.world.volume.buffer.AbstractVolumeBuffer;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public class ObjectArrayMutableEntityArchetypeBuffer
extends AbstractVolumeBuffer
implements EntityArchetypeVolume.Mutable {
    private final ArrayList<Tuple<Vector3d, EntityArchetype>> entities = new ArrayList();

    public ObjectArrayMutableEntityArchetypeBuffer(Vector3i start, Vector3i size) {
        super(start, size);
    }

    public Collection<EntityArchetype> entityArchetypes() {
        return this.entities.stream().map(Tuple::second).collect(Collectors.toList());
    }

    public Collection<EntityArchetypeEntry> entityArchetypesByPosition() {
        return this.entities.stream().map(tuple -> EntityArchetypeEntry.of((EntityArchetype)((EntityArchetype)tuple.second()), (Vector3d)((Vector3d)tuple.first()))).collect(Collectors.toList());
    }

    public Collection<EntityArchetype> entityArchetypes(Predicate<EntityArchetype> filter) {
        return this.entities.stream().map(Tuple::second).filter(filter).collect(Collectors.toList());
    }

    public VolumeStream<EntityArchetypeVolume.Mutable, EntityArchetype> entityArchetypeStream(Vector3i min, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(min, max, this.min(), this.max(), options);
        Stream entryStream = options.carbonCopy() ? new ArrayList<Tuple<Vector3d, EntityArchetype>>(this.entities).stream() : this.entities.stream();
        Stream archetypeStream = entryStream.filter(VolumeStreamUtils.entityArchetypePositionFilter(min, max)).map(tuple -> VolumeElement.of((Volume)this, (Object)((EntityArchetype)tuple.second()), (Vector3d)((Vector3d)tuple.first())));
        return new SpongeVolumeStream<EntityArchetypeVolume.Mutable, EntityArchetype>(archetypeStream, () -> this);
    }

    public Stream<EntityArchetypeEntry> entitiesByPosition() {
        return this.entities.stream().map(tuple -> EntityArchetypeEntry.of((EntityArchetype)((EntityArchetype)tuple.second()), (Vector3d)((Vector3d)tuple.first())));
    }

    public void addEntity(EntityArchetypeEntry entry) {
        if (!this.contains(Objects.requireNonNull(entry, "EntityArchetype cannot be null").position().toInt())) {
            String message = String.format("EntityArchetype position is out of bounds: Found %s but is outside bounds (%s, %s)", entry.position(), this.min(), this.max());
            throw new IllegalArgumentException(message);
        }
        this.entities.add((Tuple<Vector3d, EntityArchetype>)Tuple.of((Object)entry.position(), (Object)entry.archetype()));
    }
}

