/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.volume.buffer.block;

import java.util.Objects;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.fluid.FluidState;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.registry.RegistryReference;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.schematic.PaletteType;
import org.spongepowered.api.world.schematic.PaletteTypes;
import org.spongepowered.api.world.volume.Volume;
import org.spongepowered.api.world.volume.block.BlockVolume;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeElement;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.common.world.schematic.CachingPalette;
import org.spongepowered.common.world.schematic.MutableBimapPalette;
import org.spongepowered.common.world.volume.SpongeVolumeStream;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.common.world.volume.buffer.block.AbstractBlockBuffer;
import org.spongepowered.common.world.volume.buffer.block.BlockBackingData;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public class ArrayMutableBlockBuffer
extends AbstractBlockBuffer
implements BlockVolume.Mutable {
    private static final BlockState AIR = (BlockState)((BlockType)BlockTypes.AIR.get()).defaultState();
    private final Palette.Mutable<BlockState, BlockType> palette;
    private final RegistryReference<BlockType> defaultState;
    private BlockBackingData data;
    private final RegistryHolder registries;

    public ArrayMutableBlockBuffer(Vector3i start, Vector3i size) {
        this((Palette<BlockState, BlockType>)new MutableBimapPalette((PaletteType)PaletteTypes.BLOCK_STATE_PALETTE.get(), Sponge.game().registry((RegistryType)RegistryTypes.BLOCK_TYPE)), (RegistryReference<BlockType>)BlockTypes.AIR, start, size);
    }

    public ArrayMutableBlockBuffer(Palette<BlockState, BlockType> palette, RegistryReference<BlockType> defaultState, Vector3i start, Vector3i size) {
        super(start, size);
        CachingPalette.MutableImpl<BlockState, BlockType> mutablePalette = new CachingPalette.MutableImpl<BlockState, BlockType>(palette.asMutable((RegistryHolder)Sponge.game()));
        this.palette = mutablePalette;
        int airId = mutablePalette.orAssign(AIR);
        int dataSize = this.area();
        this.defaultState = defaultState;
        this.data = new BlockBackingData.PackedBackingData(dataSize, palette.highestId());
        if (airId != 0) {
            for (int i = 0; i < dataSize; ++i) {
                this.data.set(i, airId);
            }
        }
        this.registries = Sponge.game();
    }

    public ArrayMutableBlockBuffer(Palette<BlockState, BlockType> palette, Vector3i start, Vector3i size, char[] blocks) {
        super(start, size);
        this.palette = palette.asMutable((RegistryHolder)Sponge.game());
        this.data = new BlockBackingData.CharBackingData(blocks);
        this.defaultState = BlockTypes.AIR;
        this.registries = Sponge.game();
    }

    ArrayMutableBlockBuffer(Palette<BlockState, BlockType> palette, BlockBackingData blocks, Vector3i start, Vector3i size) {
        super(start, size);
        this.palette = palette.asMutable((RegistryHolder)Sponge.game());
        this.data = blocks;
        this.defaultState = BlockTypes.AIR;
        this.registries = Sponge.game();
    }

    @Override
    public Palette<BlockState, BlockType> blockPalette() {
        return this.palette;
    }

    public boolean setBlock(int x, int y, int z, BlockState block) {
        this.checkRange(x, y, z);
        int id = this.palette.orAssign((Object)block);
        if (id > this.data.getMax()) {
            int highId = this.palette.highestId();
            int dataSize = this.area();
            BlockBackingData.PackedBackingData newdata = new BlockBackingData.PackedBackingData(dataSize, highId);
            for (int i = 0; i < dataSize; ++i) {
                newdata.set(i, this.data.get(i));
            }
            this.data = newdata;
        }
        this.data.set(this.getIndex(x, y, z), id);
        return true;
    }

    public boolean removeBlock(int x, int y, int z) {
        this.checkRange(x, y, z);
        return this.setBlock(x, y, z, (BlockState)((BlockType)BlockTypes.AIR.get()).defaultState());
    }

    public BlockState block(int x, int y, int z) {
        this.checkRange(x, y, z);
        int id = this.data.get(this.getIndex(x, y, z));
        return this.palette.get(id, this.registries).orElseGet(() -> (BlockState)((BlockType)this.defaultState.get(new RegistryHolder[]{this.registries})).defaultState());
    }

    public FluidState fluid(int x, int y, int z) {
        return this.block(x, y, z).fluidState();
    }

    public int highestYAt(int x, int z) {
        return 0;
    }

    private int area() {
        return this.size.x() * this.size.y() * this.size.z();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ArrayMutableBlockBuffer that = (ArrayMutableBlockBuffer)o;
        return this.palette.equals(that.palette) && this.data.equals(that.data);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.palette, this.data);
    }

    public VolumeStream<BlockVolume.Mutable, BlockState> blockStateStream(Vector3i min, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(min, max, this.min(), this.max(), options);
        ArrayMutableBlockBuffer buffer = options.carbonCopy() ? this.copy() : this;
        Stream stateStream = IntStream.rangeClosed(min.x(), max.x()).mapToObj(x -> IntStream.rangeClosed(min.z(), max.z()).mapToObj(z -> IntStream.rangeClosed(min.y(), max.y()).mapToObj(y -> VolumeElement.of((Volume)this, () -> buffer.block(x, y, z), (Vector3d)new Vector3d((float)x, (float)y, (float)z)))).flatMap(Function.identity())).flatMap(Function.identity());
        return new SpongeVolumeStream<BlockVolume.Mutable, BlockState>(stateStream, () -> this);
    }

    public void setBlock(class_2338 pos, class_2680 blockState) {
        this.setBlock(pos.method_10263(), pos.method_10264(), pos.method_10260(), (BlockState)blockState);
    }

    public class_2680 getBlock(class_2338 blockPos) {
        return (class_2680)this.block(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
    }

    public ArrayMutableBlockBuffer copy() {
        return new ArrayMutableBlockBuffer((Palette<BlockState, BlockType>)this.palette, this.data.copyOf(), this.start, this.size);
    }

    public BlockBackingData getCopiedBackingData() {
        return this.data.copyOf();
    }
}

