/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.volume.buffer.blockentity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.world.volume.Volume;
import org.spongepowered.api.world.volume.block.entity.BlockEntityVolume;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeElement;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.common.world.volume.SpongeVolumeStream;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.common.world.volume.buffer.blockentity.AbstractMutableBlockEntityBuffer;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public class ObjectArrayMutableBlockEntityBuffer
extends AbstractMutableBlockEntityBuffer {
    private final ArrayList<BlockEntity> blockEntities = new ArrayList();

    public ObjectArrayMutableBlockEntityBuffer(Vector3i start, Vector3i size) {
        super(start, size);
    }

    public void addBlockEntity(int x, int y, int z, BlockEntity blockEntity) {
        this.blockEntities.add(blockEntity);
    }

    public void removeBlockEntity(int x, int y, int z) {
        this.blockEntities.removeIf(be -> {
            Vector3i pos = be.blockPosition();
            return pos.x() == x && pos.z() == z && pos.y() == y;
        });
    }

    public VolumeStream<BlockEntityVolume.Mutable, BlockEntity> blockEntityStream(Vector3i min, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(min, max, this.min(), this.max(), options);
        Stream blockEntityStream = this.blockEntities.stream().map(be -> VolumeElement.of((Volume)this, (Object)be, (Vector3d)be.blockPosition().toDouble()));
        return new SpongeVolumeStream<BlockEntityVolume.Mutable, BlockEntity>(blockEntityStream, () -> this);
    }

    public Collection<? extends BlockEntity> blockEntities() {
        return this.blockEntities;
    }

    public Optional<? extends BlockEntity> blockEntity(int x, int y, int z) {
        return this.blockEntities.stream().filter(be -> {
            Vector3i pos = be.blockPosition();
            return pos.x() == x && pos.y() == y && pos.z() == z;
        }).findFirst();
    }

    public @Nullable class_2586 getTileEntity(class_2338 blockPos) {
        return this.blockEntity(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()).orElse(null);
    }
}

