/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.weather;

import net.minecraft.class_5268;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.api.world.weather.Weather;
import org.spongepowered.api.world.weather.WeatherType;
import org.spongepowered.api.world.weather.WeatherTypes;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.SpongeTicks;
import org.spongepowered.common.world.weather.SpongeWeatherType;

public final class SpongeWeather
implements Weather {
    private final SpongeWeatherType type;
    private final Ticks remainingDuration;
    private final Ticks runningDuration;

    public SpongeWeather(SpongeWeatherType type, Ticks remainingDuration, Ticks runningDuration) {
        this.type = type;
        this.remainingDuration = remainingDuration;
        this.runningDuration = runningDuration;
    }

    public static Weather of(class_5268 levelData) {
        boolean thundering = levelData.method_203();
        if (thundering) {
            Ticks thunderTime = SpongeTicks.ticksOrInfinite(levelData.method_145());
            return new SpongeWeather((SpongeWeatherType)WeatherTypes.THUNDER.get(), thunderTime, (Ticks)(thunderTime.isInfinite() ? thunderTime : new SpongeTicks(6000L - thunderTime.ticks())));
        }
        boolean raining = levelData.method_156();
        if (raining) {
            Ticks rainTime = SpongeTicks.ticksOrInfinite(levelData.method_190());
            return new SpongeWeather((SpongeWeatherType)WeatherTypes.RAIN.get(), rainTime, (Ticks)(rainTime.isInfinite() ? rainTime : new SpongeTicks(6000L - rainTime.ticks())));
        }
        Ticks clearWeatherTime = SpongeTicks.ticksOrInfinite(levelData.method_155());
        return new SpongeWeather((SpongeWeatherType)WeatherTypes.CLEAR.get(), clearWeatherTime, (Ticks)(clearWeatherTime.isInfinite() ? clearWeatherTime : new SpongeTicks(6000L - clearWeatherTime.ticks())));
    }

    public static void apply(class_5268 levelData, Weather weather) {
        int time = SpongeTicks.toSaturatedIntOrInfinite(weather.remainingDuration());
        WeatherType type = weather.type();
        if (type == WeatherTypes.CLEAR.get()) {
            levelData.method_167(time);
            levelData.method_157(false);
            levelData.method_164(0);
            levelData.method_147(false);
            levelData.method_173(0);
        } else if (type == WeatherTypes.RAIN.get()) {
            levelData.method_157(true);
            levelData.method_164(time);
            levelData.method_147(false);
            levelData.method_173(0);
            levelData.method_167(0);
        } else if (type == WeatherTypes.THUNDER.get()) {
            levelData.method_157(true);
            levelData.method_164(time);
            levelData.method_147(true);
            levelData.method_173(time);
            levelData.method_167(0);
        }
    }

    public WeatherType type() {
        return this.type;
    }

    public Ticks remainingDuration() {
        return this.remainingDuration;
    }

    public Ticks runningDuration() {
        return this.runningDuration;
    }

    public int contentVersion() {
        return 0;
    }

    public DataContainer toContainer() {
        return DataContainer.createNew().set(Queries.CONTENT_VERSION, (Object)this.contentVersion()).set(Constants.Universe.Weather.TYPE, (Object)this.type.key(RegistryTypes.WEATHER_TYPE)).set(Constants.Universe.Weather.REMAINING_DURATION, (Object)this.remainingDuration.ticks()).set(Constants.Universe.Weather.RUNNING_DURATION, (Object)this.runningDuration.ticks());
    }

    public static class FactoryImpl
    implements Weather.Factory {
        public Weather of(WeatherType type, Ticks remainingDuration, Ticks runningDuration) {
            return new SpongeWeather((SpongeWeatherType)type, remainingDuration, runningDuration);
        }
    }
}

