/*
 * Decompiled with CFR 0.152.
 */
package net.verypersuasiveviksy.eess.item;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.verypersuasiveviksy.eess.procedures.ConsumeMemoryProcedure;
import net.verypersuasiveviksy.eess.procedures.RottingMemoryDeleteInOverworldProcedure;

public class RottingMemoryItem
extends Item {
    public RottingMemoryItem() {
        super(new Item.Properties().stacksTo(64).rarity(Rarity.UNCOMMON).food(new FoodProperties.Builder().nutrition(-1).saturationModifier(-0.6f).alwaysEdible().build()));
    }

    public UseAnim getUseAnimation(ItemStack itemstack) {
        return UseAnim.BOW;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isFoil(ItemStack itemstack) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"item.e2s2.rotting_memory.description_0"));
    }

    public ItemStack finishUsingItem(ItemStack itemstack, Level world, LivingEntity entity) {
        ItemStack retval = super.finishUsingItem(itemstack, world, entity);
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        ConsumeMemoryProcedure.execute((Entity)entity);
        return retval;
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        RottingMemoryDeleteInOverworldProcedure.execute(entity);
    }
}

