/*
 * Decompiled with CFR 0.152.
 */
package net.verypersuasiveviksy.eess.init;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.verypersuasiveviksy.eess.entity.DarkBugEntity;
import net.verypersuasiveviksy.eess.entity.DarkEyeEntity;
import net.verypersuasiveviksy.eess.entity.DarkManEntity;
import net.verypersuasiveviksy.eess.entity.EnderKnightEntity;
import net.verypersuasiveviksy.eess.entity.HeroEntity;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class E2s2ModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"e2s2");
    public static final DeferredHolder<EntityType<?>, EntityType<DarkEyeEntity>> DARK_EYE = E2s2ModEntities.register("dark_eye", EntityType.Builder.of(DarkEyeEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(1.0f, 1.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<DarkManEntity>> DARK_MAN = E2s2ModEntities.register("dark_man", EntityType.Builder.of(DarkManEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<DarkBugEntity>> DARK_BUG = E2s2ModEntities.register("dark_bug", EntityType.Builder.of(DarkBugEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.4f, 0.3f));
    public static final DeferredHolder<EntityType<?>, EntityType<EnderKnightEntity>> ENDER_KNIGHT = E2s2ModEntities.register("ender_knight", EntityType.Builder.of(EnderKnightEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<HeroEntity>> HERO = E2s2ModEntities.register("hero", EntityType.Builder.of(HeroEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 1.8f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        DarkEyeEntity.init(event);
        DarkManEntity.init(event);
        DarkBugEntity.init(event);
        EnderKnightEntity.init(event);
        HeroEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)DARK_EYE.get(), DarkEyeEntity.createAttributes().build());
        event.put((EntityType)DARK_MAN.get(), DarkManEntity.createAttributes().build());
        event.put((EntityType)DARK_BUG.get(), DarkBugEntity.createAttributes().build());
        event.put((EntityType)ENDER_KNIGHT.get(), EnderKnightEntity.createAttributes().build());
        event.put((EntityType)HERO.get(), HeroEntity.createAttributes().build());
    }
}

