/*
 * Decompiled with CFR 0.152.
 */
package net.verypersuasiveviksy.eess.item;

import com.google.common.collect.Iterables;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.RegisterEvent;
import net.verypersuasiveviksy.eess.init.E2s2ModItems;
import net.verypersuasiveviksy.eess.procedures.AgileBootsProcedure;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public abstract class GodspecItem
extends ArmorItem {
    public static Holder<ArmorMaterial> ARMOR_MATERIAL = null;

    @SubscribeEvent
    public static void registerArmorMaterial(RegisterEvent event) {
        event.register(Registries.ARMOR_MATERIAL, registerHelper -> {
            ArmorMaterial armorMaterial = new ArmorMaterial((Map)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
                map.put(ArmorItem.Type.BOOTS, 5);
                map.put(ArmorItem.Type.LEGGINGS, 8);
                map.put(ArmorItem.Type.CHESTPLATE, 12);
                map.put(ArmorItem.Type.HELMET, 5);
                map.put(ArmorItem.Type.BODY, 12);
            }), 50, (Holder)DeferredHolder.create((ResourceKey)Registries.SOUND_EVENT, (ResourceLocation)ResourceLocation.parse((String)"block.vault.insert_item")), () -> Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)E2s2ModItems.GODSOUL_INGOT.get())}), List.of(new ArmorMaterial.Layer(ResourceLocation.parse((String)"e2s2:godspec"))), 5.0f, 1.0f);
            registerHelper.register(ResourceLocation.parse((String)"e2s2:godspec"), (Object)armorMaterial);
            ARMOR_MATERIAL = BuiltInRegistries.ARMOR_MATERIAL.wrapAsHolder((Object)armorMaterial);
        });
    }

    public GodspecItem(ArmorItem.Type type, Item.Properties properties) {
        super(ARMOR_MATERIAL, type, properties);
    }

    public static class Boots
    extends GodspecItem {
        public Boots() {
            super(ArmorItem.Type.BOOTS, new Item.Properties().durability(ArmorItem.Type.BOOTS.getDurability(100)).fireResistant());
        }

        @OnlyIn(value=Dist.CLIENT)
        public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
            super.appendHoverText(itemstack, context, list, flag);
            list.add((Component)Component.translatable((String)"item.e2s2.godspec_boots.description_0"));
            list.add((Component)Component.translatable((String)"item.e2s2.godspec_boots.description_1"));
            list.add((Component)Component.translatable((String)"item.e2s2.godspec_boots.description_2"));
            list.add((Component)Component.translatable((String)"item.e2s2.godspec_boots.description_3"));
            list.add((Component)Component.translatable((String)"item.e2s2.godspec_boots.description_4"));
            list.add((Component)Component.translatable((String)"item.e2s2.godspec_boots.description_5"));
            list.add((Component)Component.translatable((String)"item.e2s2.godspec_boots.description_6"));
        }

        public boolean makesPiglinsNeutral(ItemStack itemstack, LivingEntity entity) {
            return true;
        }

        public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
            Player player;
            super.inventoryTick(itemstack, world, entity, slot, selected);
            if (entity instanceof Player && Iterables.contains((Iterable)(player = (Player)entity).getArmorSlots(), (Object)itemstack)) {
                AgileBootsProcedure.execute(entity);
            }
        }
    }

    public static class Leggings
    extends GodspecItem {
        public Leggings() {
            super(ArmorItem.Type.LEGGINGS, new Item.Properties().durability(ArmorItem.Type.LEGGINGS.getDurability(100)).fireResistant());
        }

        @OnlyIn(value=Dist.CLIENT)
        public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
            super.appendHoverText(itemstack, context, list, flag);
            list.add((Component)Component.translatable((String)"item.e2s2.godspec_leggings.description_0"));
            list.add((Component)Component.translatable((String)"item.e2s2.godspec_leggings.description_1"));
            list.add((Component)Component.translatable((String)"item.e2s2.godspec_leggings.description_2"));
            list.add((Component)Component.translatable((String)"item.e2s2.godspec_leggings.description_3"));
            list.add((Component)Component.translatable((String)"item.e2s2.godspec_leggings.description_4"));
            list.add((Component)Component.translatable((String)"item.e2s2.godspec_leggings.description_5"));
            list.add((Component)Component.translatable((String)"item.e2s2.godspec_leggings.description_6"));
        }

        public boolean makesPiglinsNeutral(ItemStack itemstack, LivingEntity entity) {
            return true;
        }
    }

    public static class Chestplate
    extends GodspecItem {
        public Chestplate() {
            super(ArmorItem.Type.CHESTPLATE, new Item.Properties().durability(ArmorItem.Type.CHESTPLATE.getDurability(100)).fireResistant());
        }

        @OnlyIn(value=Dist.CLIENT)
        public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
            super.appendHoverText(itemstack, context, list, flag);
            list.add((Component)Component.translatable((String)"item.e2s2.godspec_chestplate.description_0"));
            list.add((Component)Component.translatable((String)"item.e2s2.godspec_chestplate.description_1"));
            list.add((Component)Component.translatable((String)"item.e2s2.godspec_chestplate.description_2"));
            list.add((Component)Component.translatable((String)"item.e2s2.godspec_chestplate.description_3"));
            list.add((Component)Component.translatable((String)"item.e2s2.godspec_chestplate.description_4"));
            list.add((Component)Component.translatable((String)"item.e2s2.godspec_chestplate.description_5"));
            list.add((Component)Component.translatable((String)"item.e2s2.godspec_chestplate.description_6"));
        }

        public boolean makesPiglinsNeutral(ItemStack itemstack, LivingEntity entity) {
            return true;
        }
    }

    public static class Helmet
    extends GodspecItem {
        public Helmet() {
            super(ArmorItem.Type.HELMET, new Item.Properties().durability(ArmorItem.Type.HELMET.getDurability(100)).fireResistant());
        }

        @OnlyIn(value=Dist.CLIENT)
        public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
            super.appendHoverText(itemstack, context, list, flag);
            list.add((Component)Component.translatable((String)"item.e2s2.godspec_helmet.description_0"));
            list.add((Component)Component.translatable((String)"item.e2s2.godspec_helmet.description_1"));
            list.add((Component)Component.translatable((String)"item.e2s2.godspec_helmet.description_2"));
            list.add((Component)Component.translatable((String)"item.e2s2.godspec_helmet.description_3"));
            list.add((Component)Component.translatable((String)"item.e2s2.godspec_helmet.description_4"));
            list.add((Component)Component.translatable((String)"item.e2s2.godspec_helmet.description_5"));
            list.add((Component)Component.translatable((String)"item.e2s2.godspec_helmet.description_6"));
        }

        public boolean makesPiglinsNeutral(ItemStack itemstack, LivingEntity entity) {
            return true;
        }
    }
}

