/*
 * Decompiled with CFR 0.152.
 */
package net.sabitron.sillyend.item;

import com.google.common.collect.Iterables;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.registries.ForgeRegistries;
import net.sabitron.sillyend.init.E2s2ModItems;
import net.sabitron.sillyend.procedures.SpikedBootsProcedure;
import net.sabitron.sillyend.procedures.SpikedChestplateProcedure;
import net.sabitron.sillyend.procedures.SpikedHelmetProcedure;
import net.sabitron.sillyend.procedures.SpikedLeggingsProcedure;

public abstract class SpikedEnderItem
extends ArmorItem {
    public SpikedEnderItem(ArmorItem.Type type, Item.Properties properties) {
        super(new ArmorMaterial(){

            public int m_266425_(ArmorItem.Type type) {
                return (new int[]{13, 15, 16, 11})[type.m_266308_().m_20749_()] * 30;
            }

            public int m_7366_(ArmorItem.Type type) {
                return (new int[]{3, 6, 8, 3})[type.m_266308_().m_20749_()];
            }

            public int m_6646_() {
                return 15;
            }

            public SoundEvent m_7344_() {
                return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("item.armor.equip_netherite"));
            }

            public Ingredient m_6230_() {
                return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)E2s2ModItems.VOIDMETAL_INGOT.get())});
            }

            public String m_6082_() {
                return "spiked_ender";
            }

            public float m_6651_() {
                return 3.0f;
            }

            public float m_6649_() {
                return 0.15f;
            }
        }, type, properties);
    }

    public static class Boots
    extends SpikedEnderItem {
        public Boots() {
            super(ArmorItem.Type.BOOTS, new Item.Properties());
        }

        public void m_7373_(ItemStack itemstack, Level world, List<Component> list, TooltipFlag flag) {
            super.m_7373_(itemstack, world, list, flag);
            list.add((Component)Component.m_237113_((String)" \u00a79Spiked \u00a78(+2 Damage)"));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "e2s2:textures/models/armor/ender__layer_1.png";
        }

        public boolean makesPiglinsNeutral(ItemStack itemstack, LivingEntity entity) {
            return false;
        }

        public void m_6883_(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
            Player player;
            super.m_6883_(itemstack, world, entity, slot, selected);
            if (entity instanceof Player && Iterables.contains((Iterable)(player = (Player)entity).m_6168_(), (Object)itemstack)) {
                SpikedBootsProcedure.execute((LevelAccessor)world, entity);
            }
        }
    }

    public static class Leggings
    extends SpikedEnderItem {
        public Leggings() {
            super(ArmorItem.Type.LEGGINGS, new Item.Properties());
        }

        public void m_7373_(ItemStack itemstack, Level world, List<Component> list, TooltipFlag flag) {
            super.m_7373_(itemstack, world, list, flag);
            list.add((Component)Component.m_237113_((String)" \u00a79Spiked \u00a78(+2 Damage)"));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "e2s2:textures/models/armor/ender__layer_2.png";
        }

        public boolean makesPiglinsNeutral(ItemStack itemstack, LivingEntity entity) {
            return false;
        }

        public void m_6883_(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
            Player player;
            super.m_6883_(itemstack, world, entity, slot, selected);
            if (entity instanceof Player && Iterables.contains((Iterable)(player = (Player)entity).m_6168_(), (Object)itemstack)) {
                SpikedLeggingsProcedure.execute((LevelAccessor)world, entity);
            }
        }
    }

    public static class Chestplate
    extends SpikedEnderItem {
        public Chestplate() {
            super(ArmorItem.Type.CHESTPLATE, new Item.Properties());
        }

        public void m_7373_(ItemStack itemstack, Level world, List<Component> list, TooltipFlag flag) {
            super.m_7373_(itemstack, world, list, flag);
            list.add((Component)Component.m_237113_((String)" \u00a79Spiked \u00a78(+2 Damage)"));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "e2s2:textures/models/armor/ender__layer_1.png";
        }

        public boolean makesPiglinsNeutral(ItemStack itemstack, LivingEntity entity) {
            return false;
        }

        public void m_6883_(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
            Player player;
            super.m_6883_(itemstack, world, entity, slot, selected);
            if (entity instanceof Player && Iterables.contains((Iterable)(player = (Player)entity).m_6168_(), (Object)itemstack)) {
                SpikedChestplateProcedure.execute((LevelAccessor)world, entity);
            }
        }
    }

    public static class Helmet
    extends SpikedEnderItem {
        public Helmet() {
            super(ArmorItem.Type.HELMET, new Item.Properties());
        }

        public void m_7373_(ItemStack itemstack, Level world, List<Component> list, TooltipFlag flag) {
            super.m_7373_(itemstack, world, list, flag);
            list.add((Component)Component.m_237113_((String)" \u00a79Spiked \u00a78(+2 Damage)"));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "e2s2:textures/models/armor/ender__layer_1.png";
        }

        public boolean makesPiglinsNeutral(ItemStack itemstack, LivingEntity entity) {
            return false;
        }

        public void m_6883_(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
            Player player;
            super.m_6883_(itemstack, world, entity, slot, selected);
            if (entity instanceof Player && Iterables.contains((Iterable)(player = (Player)entity).m_6168_(), (Object)itemstack)) {
                SpikedHelmetProcedure.execute((LevelAccessor)world, entity);
            }
        }
    }
}

