/*
 * Decompiled with CFR 0.152.
 */
package ru.overwrite.protect.bukkit;

import java.time.LocalDateTime;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.messaging.Messenger;
import ru.overwrite.protect.bukkit.ServerProtectorManager;
import ru.overwrite.protect.bukkit.utils.metrics.bukkit.Metrics;

public final class ServerProtector
extends ServerProtectorManager {
    public void onEnable() {
        long startTime = System.currentTimeMillis();
        this.saveDefaultConfig();
        FileConfiguration config = this.getConfig();
        ConfigurationSection mainSettings = config.getConfigurationSection("main-settings");
        this.setupLogger(config);
        this.setupProxy(mainSettings);
        this.loadConfigs(config);
        PluginManager pluginManager = this.server.getPluginManager();
        this.checkSafe(pluginManager);
        this.checkPaper();
        this.registerListeners(pluginManager);
        this.registerCommands(pluginManager, mainSettings);
        this.startTasks(config);
        this.logEnableDisable(this.getPluginConfig().getLogMessages().enabled(), LocalDateTime.now());
        if (mainSettings.getBoolean("enable-metrics", true)) {
            new Metrics((Plugin)this, 13347);
        }
        this.checkForUpdates(mainSettings);
        long endTime = System.currentTimeMillis();
        this.getPluginLogger().info("Plugin started in " + (endTime - startTime) + " ms");
    }

    public void onDisable() {
        if (this.getMessageFile() != null) {
            this.logEnableDisable(this.getPluginConfig().getLogMessages().disabled(), LocalDateTime.now());
        }
        if (this.getPluginConfig().getMessageSettings().enableBroadcasts()) {
            for (Player onlinePlayer : this.server.getOnlinePlayers()) {
                if (!onlinePlayer.hasPermission("serverprotector.admin") || this.getMessageFile() == null) continue;
                onlinePlayer.sendMessage(this.getPluginConfig().getBroadcasts().disabled());
            }
        }
        this.getRunner().cancelTasks();
        if (this.getPluginMessage() != null) {
            Messenger messenger = this.server.getMessenger();
            messenger.unregisterOutgoingPluginChannel((Plugin)this);
            messenger.unregisterIncomingPluginChannel((Plugin)this);
        }
        if (this.getConfig().getBoolean("secure-settings.shutdown-on-disable")) {
            this.server.shutdown();
        }
    }
}

