/*
 * Decompiled with CFR 0.152.
 */
package ru.overwrite.protect.bukkit.commands.subcommands;

import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import ru.overwrite.protect.bukkit.ServerProtectorManager;
import ru.overwrite.protect.bukkit.commands.subcommands.AbstractSubCommand;
import ru.overwrite.protect.bukkit.configuration.data.UspMessages;

public class RempassSubcommand
extends AbstractSubCommand {
    public RempassSubcommand(ServerProtectorManager plugin) {
        super(plugin, "rempass", "serverprotector.rempass", true);
    }

    @Override
    public boolean execute(CommandSender sender, String label, String[] args) {
        UspMessages uspMessages = this.pluginConfig.getUspMessages();
        if (args.length > 1) {
            String nickname = args[1];
            if (!this.plugin.isAdmin(nickname) && !this.plugin.isAdmin(this.pluginConfig.getGeyserSettings().prefix() + nickname)) {
                sender.sendMessage(uspMessages.notInConfig());
                return true;
            }
            if (args.length < 3) {
                this.removeAdmin(nickname);
                sender.sendMessage(uspMessages.playerRemoved());
                return true;
            }
        }
        this.sendCmdUsage(sender, uspMessages.remPassUsage(), label);
        return true;
    }

    private void removeAdmin(String nick) {
        FileConfiguration dataFile = this.pluginConfig.getFile(this.plugin.getDataFilePath(), this.plugin.getDataFileName());
        if (!this.pluginConfig.getEncryptionSettings().enableEncryption()) {
            dataFile.set("data." + nick + ".pass", null);
        } else {
            dataFile.set("data." + nick + ".encrypted-pass", null);
        }
        dataFile.set("data." + nick, null);
        this.pluginConfig.save(this.plugin.getDataFilePath(), dataFile, this.plugin.getDataFileName(), true);
        this.plugin.setDataFile(dataFile);
        this.pluginConfig.setupPasswords(dataFile);
    }
}

