/*
 * Decompiled with CFR 0.152.
 */
package ru.overwrite.protect.bukkit.commands.subcommands;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import ru.overwrite.protect.bukkit.ServerProtectorManager;
import ru.overwrite.protect.bukkit.commands.subcommands.AbstractSubCommand;
import ru.overwrite.protect.bukkit.configuration.data.SystemMessages;
import ru.overwrite.protect.bukkit.utils.Utils;

public class UpdateSubcommand
extends AbstractSubCommand {
    public UpdateSubcommand(ServerProtectorManager plugin) {
        super(plugin, "update", "serverprotector.update", true);
    }

    @Override
    public boolean execute(CommandSender sender, String label, String[] args) {
        this.checkAndUpdatePlugin(sender, this.plugin);
        return true;
    }

    public void checkAndUpdatePlugin(CommandSender sender, ServerProtectorManager plugin) {
        plugin.getRunner().runAsync(() -> Utils.checkUpdates(plugin, version -> {
            SystemMessages systemMessages = this.pluginConfig.getSystemMessages();
            sender.sendMessage(systemMessages.baselineDefault());
            String currentVersion = plugin.getDescription().getVersion();
            if (currentVersion.equals(version)) {
                sender.sendMessage(systemMessages.updateLatest());
            } else {
                String currentJarName = new File(((Object)((Object)plugin)).getClass().getProtectionDomain().getCodeSource().getLocation().getPath()).getName();
                String downloadUrl = "https://github.com/Overwrite987/UltimateServerProtector/releases/download/" + version + "/UltimateServerProtector.jar";
                try {
                    File updateFolder = Bukkit.getUpdateFolderFile();
                    File targetFile = new File(updateFolder, currentJarName);
                    this.downloadFile(downloadUrl, targetFile, sender);
                    sender.sendMessage(systemMessages.updateSuccess1());
                    sender.sendMessage(systemMessages.updateSuccess2());
                }
                catch (IOException ex) {
                    sender.sendMessage("Unable to download update: " + ex.getMessage());
                }
            }
            sender.sendMessage(systemMessages.baselineDefault());
        }));
    }

    public void downloadFile(String fileURL, File targetFile, CommandSender sender) throws IOException {
        URL url = new URL(fileURL);
        URLConnection connection = url.openConnection();
        int fileSize = connection.getContentLength();
        try (BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
             FileOutputStream out = new FileOutputStream(targetFile);){
            int bytesRead;
            byte[] data = new byte[1024];
            int totalBytesRead = 0;
            int lastPercentage = 0;
            while ((bytesRead = in.read(data, 0, 1024)) != -1) {
                out.write(data, 0, bytesRead);
                int progressPercentage = (int)((double)(totalBytesRead += bytesRead) / (double)fileSize * 100.0);
                if (progressPercentage < lastPercentage + 10) continue;
                lastPercentage = progressPercentage;
                int downloadedKB = totalBytesRead / 1024;
                int fullSizeKB = fileSize / 1024;
                sender.sendMessage(downloadedKB + "/" + fullSizeKB + "KB (" + progressPercentage + "%)");
            }
        }
    }
}

