/*
 * Decompiled with CFR 0.152.
 */
package ru.overwrite.protect.bukkit.listeners;

import java.time.LocalDateTime;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.RegisteredListener;
import ru.overwrite.protect.bukkit.ServerProtectorManager;
import ru.overwrite.protect.bukkit.api.CaptureReason;
import ru.overwrite.protect.bukkit.api.ServerProtectorAPI;
import ru.overwrite.protect.bukkit.api.events.ServerProtectorCaptureEvent;
import ru.overwrite.protect.bukkit.configuration.Config;
import ru.overwrite.protect.bukkit.task.runner.Runner;

public class ConnectionListener
implements Listener {
    private final ServerProtectorManager plugin;
    private final ServerProtectorAPI api;
    private final Config pluginConfig;
    private final Runner runner;

    public ConnectionListener(ServerProtectorManager plugin) {
        this.plugin = plugin;
        this.api = plugin.getApi();
        this.pluginConfig = plugin.getPluginConfig();
        this.runner = plugin.getRunner();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPreLogin(AsyncPlayerPreLoginEvent e) {
        if (!this.plugin.isSafe()) {
            this.plugin.logUnsafe();
            e.setLoginResult(AsyncPlayerPreLoginEvent.Result.KICK_OTHER);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onLogin(PlayerLoginEvent e) {
        Player player = e.getPlayer();
        player.loadData();
        this.runner.runAsync(() -> {
            String playerName = player.getName();
            CaptureReason captureReason = this.plugin.checkPermissions(player);
            if (captureReason == null) {
                if (this.api.isCaptured(playerName)) {
                    this.api.uncapturePlayer(playerName);
                }
                return;
            }
            String ip = e.getAddress().getHostAddress();
            if (this.pluginConfig.getSecureSettings().enableIpWhitelist() && !this.isIPAllowed(ip, this.pluginConfig.getAccessData().ipWhitelist().get(playerName)) && !this.api.isExcluded(playerName, this.pluginConfig.getExcludedPlayers().ipWhitelist())) {
                this.plugin.checkFail(playerName, this.pluginConfig.getCommands().notAdminIp());
            }
            if (this.pluginConfig.getSessionSettings().session() && !this.api.hasSession(playerName, ip) && !this.api.isExcluded(playerName, this.pluginConfig.getExcludedPlayers().adminPass())) {
                ServerProtectorCaptureEvent captureEvent = new ServerProtectorCaptureEvent(player, ip, captureReason);
                RegisteredListener[] listeners = captureEvent.getHandlers().getRegisteredListeners();
                if (listeners.length != 0) {
                    captureEvent.callEvent();
                }
                if (this.pluginConfig.getApiSettings().allowCancelCaptureEvent() && captureEvent.isCancelled()) {
                    return;
                }
                this.api.capturePlayer(playerName);
            }
        });
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onJoin(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        this.runner.runDelayedAsync(() -> {
            CaptureReason captureReason = this.plugin.checkPermissions(player);
            if (captureReason == null) {
                return;
            }
            if (this.api.isCaptured(player)) {
                if (this.pluginConfig.getEffectSettings().enableEffects()) {
                    this.plugin.giveEffects(player);
                }
                this.plugin.applyHide(player);
            }
            if (this.pluginConfig.getLoggingSettings().loggingJoin()) {
                this.plugin.logAction(this.pluginConfig.getLogMessages().joined(), player, LocalDateTime.now());
            }
            if (this.pluginConfig.getBroadcasts() != null) {
                this.plugin.sendAlert(player, this.pluginConfig.getBroadcasts().joined());
            }
        }, 2L);
    }

    private boolean isIPAllowed(String playerIp, List<String> allowedIps) {
        if (allowedIps == null || allowedIps.isEmpty()) {
            return false;
        }
        block0: for (int i = 0; i < allowedIps.size(); ++i) {
            int allowedIpLength;
            String allowedIp = allowedIps.get(i);
            int playerIpLength = playerIp.length();
            if (playerIpLength != (allowedIpLength = allowedIp.length()) && !allowedIp.contains("*")) continue;
            for (int n = 0; n < allowedIpLength; ++n) {
                char currentChar = allowedIp.charAt(n);
                if (currentChar == '*') {
                    return true;
                }
                if (n >= playerIpLength || currentChar != playerIp.charAt(n)) continue block0;
            }
            if (playerIpLength != allowedIpLength) continue;
            return true;
        }
        return false;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onLeave(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.handlePlayerLeave(player);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onKick(PlayerKickEvent event) {
        Player player = event.getPlayer();
        this.handlePlayerLeave(player);
    }

    private void handlePlayerLeave(Player player) {
        String playerName = player.getName();
        if (this.api.isCaptured(player)) {
            this.plugin.removeEffects(player);
            if (this.pluginConfig.getPunishSettings().enableRejoin()) {
                this.handleRejoin(playerName);
            }
        }
        this.plugin.getPerPlayerTime().removeInt((Object)playerName);
        this.api.unsavePlayer(playerName);
    }

    private void handleRejoin(String playerName) {
        if (this.pluginConfig.getPunishSettings().maxRejoins() <= 0) {
            return;
        }
        int attempts = this.api.addRejoin(playerName, 1);
        if (attempts > this.pluginConfig.getPunishSettings().maxRejoins()) {
            this.plugin.checkFail(playerName, this.pluginConfig.getCommands().failedRejoin());
            this.api.clearRejoins(playerName);
        }
    }
}

