/*
 * Decompiled with CFR 0.152.
 */
package ru.overwrite.protect.bukkit.listeners;

import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import ru.overwrite.protect.bukkit.ServerProtectorManager;
import ru.overwrite.protect.bukkit.api.ServerProtectorAPI;
import ru.overwrite.protect.bukkit.configuration.Config;

public class MainListener
implements Listener {
    private final ServerProtectorAPI api;
    private final Config pluginConfig;

    public MainListener(ServerProtectorManager plugin) {
        this.api = plugin.getApi();
        this.pluginConfig = plugin.getPluginConfig();
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onMove(PlayerMoveEvent e) {
        if (!this.api.isAnybodyCaptured()) {
            return;
        }
        if (this.pluginConfig.getBlockingSettings().allowOrientationChange() && this.hasChangedOrientation(e.getFrom(), e.getTo()) && !this.hasChangedPosition(e.getFrom(), e.getTo())) {
            return;
        }
        Player player = e.getPlayer();
        this.api.handleInteraction(player, (Cancellable)e);
    }

    private boolean hasChangedOrientation(Location from, Location to) {
        return from.getPitch() != to.getPitch() || from.getYaw() != to.getYaw();
    }

    public boolean hasChangedPosition(Location from, Location to) {
        return from.getX() != to.getX() || from.getY() != to.getY() || from.getZ() != to.getZ();
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent e) {
        Player player = e.getPlayer();
        this.api.handleInteraction(player, (Cancellable)e);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent e) {
        Player player = e.getPlayer();
        this.api.handleInteraction(player, (Cancellable)e);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onItemDrop(PlayerDropItemEvent e) {
        Player player = e.getPlayer();
        if (this.pluginConfig.getBlockingSettings().blockItemDrop()) {
            this.api.handleInteraction(player, (Cancellable)e);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onItemPickup(EntityPickupItemEvent e) {
        LivingEntity livingEntity = e.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (this.pluginConfig.getBlockingSettings().blockItemPickup()) {
            this.api.handleInteraction(player, (Cancellable)e);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerDamage(EntityDamageEvent e) {
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (this.pluginConfig.getBlockingSettings().blockDamage()) {
            this.api.handleInteraction(player, (Cancellable)e);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerDamageEntity(EntityDamageByEntityEvent e) {
        Entity entity = e.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (this.pluginConfig.getBlockingSettings().blockDamagingEntity()) {
            this.api.handleInteraction(player, (Cancellable)e);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onInventoryOpen(InventoryOpenEvent e) {
        Player player = (Player)e.getPlayer();
        if (this.pluginConfig.getBlockingSettings().blockInventoryOpen()) {
            this.api.handleInteraction(player, (Cancellable)e);
        }
    }
}

