/*
 * Decompiled with CFR 0.152.
 */
package ru.overwrite.protect.bukkit.task;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.time.LocalDateTime;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredListener;
import ru.overwrite.protect.bukkit.PasswordHandler;
import ru.overwrite.protect.bukkit.ServerProtectorManager;
import ru.overwrite.protect.bukkit.api.CaptureReason;
import ru.overwrite.protect.bukkit.api.ServerProtectorAPI;
import ru.overwrite.protect.bukkit.api.events.ServerProtectorCaptureEvent;
import ru.overwrite.protect.bukkit.configuration.Config;
import ru.overwrite.protect.bukkit.configuration.data.BossbarSettings;
import ru.overwrite.protect.bukkit.task.runner.Runner;
import ru.overwrite.protect.bukkit.utils.Utils;

public final class TaskManager {
    private final ServerProtectorManager plugin;
    private final ServerProtectorAPI api;
    private final PasswordHandler passwordHandler;
    private final Config pluginConfig;
    private final Runner runner;

    public TaskManager(ServerProtectorManager plugin) {
        this.plugin = plugin;
        this.api = plugin.getApi();
        this.passwordHandler = plugin.getPasswordHandler();
        this.pluginConfig = plugin.getPluginConfig();
        this.runner = plugin.getRunner();
    }

    public void startMainCheck(long interval) {
        this.runner.runPeriodicalAsync(() -> {
            if (Bukkit.getOnlinePlayers().isEmpty()) {
                return;
            }
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                CaptureReason captureReason;
                if (this.api.isExcluded(onlinePlayer, this.pluginConfig.getExcludedPlayers().adminPass()) || this.api.isCaptured(onlinePlayer) || (captureReason = this.plugin.checkPermissions(onlinePlayer)) == null || this.api.isAuthorised(onlinePlayer)) continue;
                ServerProtectorCaptureEvent captureEvent = new ServerProtectorCaptureEvent(onlinePlayer, Utils.getIp(onlinePlayer), captureReason);
                captureEvent.callEvent();
                RegisteredListener[] listeners = captureEvent.getHandlers().getRegisteredListeners();
                if (listeners.length != 0) {
                    captureEvent.callEvent();
                }
                if (this.pluginConfig.getApiSettings().allowCancelCaptureEvent() && captureEvent.isCancelled()) continue;
                this.api.capturePlayer(onlinePlayer);
                if (this.pluginConfig.getSoundSettings().enableSounds()) {
                    Utils.sendSound(this.pluginConfig.getSoundSettings().onCapture(), onlinePlayer);
                }
                if (this.pluginConfig.getEffectSettings().enableEffects()) {
                    this.plugin.giveEffects(onlinePlayer);
                }
                this.plugin.applyHide(onlinePlayer);
                if (this.pluginConfig.getLoggingSettings().loggingPas()) {
                    this.plugin.logAction(this.pluginConfig.getLogMessages().captured(), onlinePlayer, LocalDateTime.now());
                }
                if (this.pluginConfig.getBroadcasts() == null) continue;
                this.plugin.sendAlert(onlinePlayer, this.pluginConfig.getBroadcasts().captured());
            }
        }, 20L, interval >= 0L ? interval : 40L);
    }

    public void startAdminCheck() {
        this.runner.runPeriodicalAsync(() -> {
            if (!this.api.isAnybodyCaptured()) {
                return;
            }
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                if (!this.api.isCaptured(onlinePlayer) || this.plugin.isAdmin(onlinePlayer.getName())) continue;
                this.plugin.checkFail(onlinePlayer.getName(), this.pluginConfig.getCommands().notInConfig());
            }
        }, 5L, 20L);
    }

    public void startCapturesMessages(FileConfiguration config) {
        this.runner.runPeriodicalAsync(() -> {
            if (!this.api.isAnybodyCaptured()) {
                return;
            }
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                if (!this.api.isCaptured(onlinePlayer)) continue;
                onlinePlayer.sendMessage(this.pluginConfig.getMessages().message());
                if (!this.pluginConfig.getMessageSettings().sendTitle()) continue;
                Utils.sendTitleMessage(this.pluginConfig.getTitles().message(), onlinePlayer);
            }
        }, 5L, (long)config.getInt("message-settings.delay") * 20L);
    }

    public void startOpCheck() {
        this.runner.runPeriodicalAsync(() -> {
            if (Bukkit.getOnlinePlayers().isEmpty()) {
                return;
            }
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                if (!onlinePlayer.isOp() || this.pluginConfig.getAccessData().opWhitelist().contains(onlinePlayer.getName()) || this.api.isExcluded(onlinePlayer, this.pluginConfig.getExcludedPlayers().opWhitelist())) continue;
                this.plugin.checkFail(onlinePlayer.getName(), this.pluginConfig.getCommands().notInOpWhitelist());
            }
        }, 5L, 20L);
    }

    public void startPermsCheck() {
        this.runner.runPeriodicalAsync(() -> {
            if (Bukkit.getOnlinePlayers().isEmpty()) {
                return;
            }
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                for (String blacklistedPerm : this.pluginConfig.getAccessData().blacklistedPerms()) {
                    if (!onlinePlayer.hasPermission(blacklistedPerm) || this.api.isExcluded(onlinePlayer, this.pluginConfig.getExcludedPlayers().blacklistedPerms())) continue;
                    this.plugin.checkFail(onlinePlayer.getName(), this.pluginConfig.getCommands().haveBlacklistedPerm());
                }
            }
        }, 5L, 20L);
    }

    public void startCapturesTimer() {
        this.runner.runPeriodicalAsync(() -> {
            if (!this.api.isAnybodyCaptured()) {
                return;
            }
            BossbarSettings bossbarSettings = this.pluginConfig.getBossbarSettings();
            int time = this.pluginConfig.getPunishSettings().time();
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                if (onlinePlayer.isDead() || !this.api.isCaptured(onlinePlayer)) continue;
                String playerName = onlinePlayer.getName();
                Object2IntOpenHashMap<String> perPlayerTime = this.plugin.getPerPlayerTime();
                int newTime = perPlayerTime.addTo((Object)playerName, 1);
                BossBar bossBar = null;
                if (bossbarSettings.enableBossbar()) {
                    bossBar = this.passwordHandler.getBossbars().get(playerName);
                    if (bossBar == null) {
                        bossBar = Bukkit.createBossBar((String)bossbarSettings.bossbarMessage().replace("%time%", Integer.toString(time)), (BarColor)bossbarSettings.barColor(), (BarStyle)bossbarSettings.barStyle(), (BarFlag[])new BarFlag[0]);
                        this.passwordHandler.getBossbars().put(playerName, bossBar);
                    }
                    int remaining = time - newTime;
                    bossBar.setTitle(bossbarSettings.bossbarMessage().replace("%time%", Integer.toString(remaining)));
                    double percents = (double)remaining / (double)time;
                    if (percents > 0.0) {
                        bossBar.setProgress(percents);
                        bossBar.addPlayer(onlinePlayer);
                    }
                }
                if (time - newTime > 0) continue;
                this.plugin.checkFail(playerName, this.pluginConfig.getCommands().failedTime());
                if (bossBar != null) {
                    bossBar.removePlayer(onlinePlayer);
                }
                perPlayerTime.removeInt((Object)playerName);
            }
        }, 5L, 20L);
    }
}

