/*
 * Decompiled with CFR 0.152.
 */
package ru.overwrite.protect.bukkit.task.runner.impl;

import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.jetbrains.annotations.NotNull;
import ru.overwrite.protect.bukkit.ServerProtectorManager;
import ru.overwrite.protect.bukkit.task.runner.Runner;

public final class BukkitRunner
implements Runner {
    private final ServerProtectorManager plugin;
    private final BukkitScheduler scheduler;

    public BukkitRunner(ServerProtectorManager plugin) {
        this.plugin = plugin;
        this.scheduler = plugin.getServer().getScheduler();
    }

    @Override
    public void runPlayer(@NotNull Runnable task, @NotNull Player player) {
        this.run(task);
    }

    @Override
    public void run(@NotNull Runnable task) {
        this.scheduler.runTask((Plugin)this.plugin, task);
    }

    @Override
    public void runAsync(@NotNull Runnable task) {
        this.scheduler.runTaskAsynchronously((Plugin)this.plugin, task);
    }

    @Override
    public void runDelayed(@NotNull Runnable task, long delayTicks) {
        this.scheduler.runTaskLater((Plugin)this.plugin, task, delayTicks);
    }

    @Override
    public void runDelayedAsync(@NotNull Runnable task, long delayTicks) {
        this.scheduler.runTaskLaterAsynchronously((Plugin)this.plugin, task, delayTicks);
    }

    @Override
    public void runPeriodical(@NotNull Runnable task, long delayTicks, long periodTicks) {
        this.scheduler.runTaskTimer((Plugin)this.plugin, task, delayTicks, periodTicks);
    }

    @Override
    public void runPeriodicalAsync(@NotNull Runnable task, long delayTicks, long periodTicks) {
        this.scheduler.runTaskTimerAsynchronously((Plugin)this.plugin, task, delayTicks, periodTicks);
    }

    @Override
    public void cancelTasks() {
        if (!this.plugin.isCalledFromAllowedApplication()) {
            return;
        }
        this.scheduler.cancelTasks((Plugin)this.plugin);
    }
}

