/*
 * Decompiled with CFR 0.152.
 */
package ru.overwrite.protect.bukkit.task.runner.impl;

import io.papermc.paper.threadedregions.scheduler.AsyncScheduler;
import io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import ru.overwrite.protect.bukkit.ServerProtectorManager;
import ru.overwrite.protect.bukkit.task.runner.Runner;

public final class PaperRunner
implements Runner {
    private final ServerProtectorManager plugin;
    private final AsyncScheduler asyncScheduler;
    private final GlobalRegionScheduler globalScheduler;

    public PaperRunner(ServerProtectorManager plugin) {
        this.plugin = plugin;
        this.asyncScheduler = plugin.getServer().getAsyncScheduler();
        this.globalScheduler = plugin.getServer().getGlobalRegionScheduler();
    }

    @Override
    public void runPlayer(@NotNull Runnable task, @NotNull Player player) {
        player.getScheduler().run((Plugin)this.plugin, PaperRunner.toConsumer(task), null);
    }

    @Override
    public void run(@NotNull Runnable task) {
        this.globalScheduler.run((Plugin)this.plugin, PaperRunner.toConsumer(task));
    }

    @Override
    public void runAsync(@NotNull Runnable task) {
        this.asyncScheduler.runNow((Plugin)this.plugin, PaperRunner.toConsumer(task));
    }

    @Override
    public void runDelayed(@NotNull Runnable task, long delayTicks) {
        this.globalScheduler.runDelayed((Plugin)this.plugin, PaperRunner.toConsumer(task), delayTicks);
    }

    @Override
    public void runDelayedAsync(@NotNull Runnable task, long delayTicks) {
        this.asyncScheduler.runDelayed((Plugin)this.plugin, PaperRunner.toConsumer(task), PaperRunner.toMilli(delayTicks), TimeUnit.MILLISECONDS);
    }

    @Override
    public void runPeriodical(@NotNull Runnable task, long delayTicks, long periodTicks) {
        this.globalScheduler.runAtFixedRate((Plugin)this.plugin, PaperRunner.toConsumer(task), delayTicks, periodTicks);
    }

    @Override
    public void runPeriodicalAsync(@NotNull Runnable task, long delayTicks, long periodTicks) {
        this.asyncScheduler.runAtFixedRate((Plugin)this.plugin, PaperRunner.toConsumer(task), PaperRunner.toMilli(delayTicks), PaperRunner.toMilli(periodTicks), TimeUnit.MILLISECONDS);
    }

    @Override
    public void cancelTasks() {
        if (!this.plugin.isCalledFromAllowedApplication()) {
            return;
        }
        this.globalScheduler.cancelTasks((Plugin)this.plugin);
        this.asyncScheduler.cancelTasks((Plugin)this.plugin);
    }

    private static Consumer<ScheduledTask> toConsumer(Runnable task) {
        return st -> task.run();
    }

    private static long toMilli(long ticks) {
        return ticks * 50L;
    }
}

