/*
 * Decompiled with CFR 0.152.
 */
package ru.overwrite.protect.bukkit.utils;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;
import ru.overwrite.protect.bukkit.ServerProtectorManager;

public final class PluginMessage
implements PluginMessageListener {
    private final ServerProtectorManager plugin;

    public PluginMessage(ServerProtectorManager plugin) {
        this.plugin = plugin;
    }

    public void onPluginMessageReceived(String channel, @NotNull Player player, byte[] message) {
        if (!channel.equals("BungeeCord")) {
            return;
        }
        ByteArrayDataInput input = ByteStreams.newDataInput((byte[])message);
        String subchannel = input.readUTF();
        if (subchannel.equalsIgnoreCase("serverprotector")) {
            String msg = input.readUTF();
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                if (!onlinePlayer.hasPermission("serverprotector.admin")) continue;
                onlinePlayer.sendMessage(msg);
            }
        }
    }

    public void sendCrossProxy(Player player, String message) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("Forward");
        out.writeUTF("ALL");
        out.writeUTF("serverprotector");
        out.writeUTF(message);
        player.sendPluginMessage((Plugin)this.plugin, "BungeeCord", out.toByteArray());
    }
}

