/*
 * Decompiled with CFR 0.152.
 */
package ru.overwrite.protect.bukkit.utils.color.impl;

import ru.overwrite.protect.bukkit.utils.color.Colorizer;

public class LegacyAdvancedColorizer
implements Colorizer {
    private static final boolean[] HEX_CHARS;
    private static final boolean[] COLOR_CHARS_FLAGS;

    @Override
    public String colorize(String message) {
        if (message == null || message.isEmpty()) {
            return message;
        }
        char[] messageChars = message.toCharArray();
        StringBuilder builder = new StringBuilder(messageChars.length + 32);
        boolean isColor = false;
        boolean isHashtag = false;
        boolean isDoubleTag = false;
        int index = 0;
        while (index < messageChars.length) {
            char currentChar = messageChars[index];
            if (isDoubleTag) {
                isDoubleTag = false;
                if (this.processDoubleTag(builder, messageChars, index)) {
                    index += 3;
                    continue;
                }
                builder.append("&##");
                continue;
            }
            if (isHashtag) {
                isHashtag = false;
                if (currentChar == '#') {
                    isDoubleTag = true;
                    ++index;
                    continue;
                }
                if (this.processSingleTag(builder, messageChars, index)) {
                    index += 6;
                    continue;
                }
                builder.append("&#");
                continue;
            }
            if (isColor) {
                isColor = false;
                if (currentChar == '#') {
                    isHashtag = true;
                    ++index;
                    continue;
                }
                if (this.isValidColorCharacter(currentChar)) {
                    builder.append('\u00a7').append(currentChar);
                    ++index;
                    continue;
                }
                builder.append('&');
                continue;
            }
            if (currentChar == '&') {
                isColor = true;
                ++index;
                continue;
            }
            builder.append(currentChar);
            ++index;
        }
        this.appendRemainingColorTags(builder, isColor, isHashtag, isDoubleTag);
        return builder.toString();
    }

    private boolean processDoubleTag(StringBuilder builder, char[] messageChars, int index) {
        if (index + 3 <= messageChars.length && this.isValidHexCode(messageChars, index, 3)) {
            builder.append('\u00a7').append('x');
            for (int i = index; i < index + 3; ++i) {
                builder.append('\u00a7').append(messageChars[i]).append('\u00a7').append(messageChars[i]);
            }
            return true;
        }
        return false;
    }

    private boolean processSingleTag(StringBuilder builder, char[] messageChars, int index) {
        if (index + 6 <= messageChars.length && this.isValidHexCode(messageChars, index, 6)) {
            builder.append('\u00a7').append('x');
            for (int i = index; i < index + 6; ++i) {
                builder.append('\u00a7').append(messageChars[i]);
            }
            return true;
        }
        return false;
    }

    public boolean isValidHexCode(char[] chars, int start, int length) {
        int end = start + length;
        for (int i = start; i < end; ++i) {
            char c = chars[i];
            if (HEX_CHARS[c]) continue;
            return false;
        }
        return true;
    }

    private boolean isValidColorCharacter(char c) {
        return COLOR_CHARS_FLAGS[c];
    }

    private void appendRemainingColorTags(StringBuilder builder, boolean isColor, boolean isHashtag, boolean isDoubleTag) {
        if (isColor) {
            builder.append('&');
        } else if (isHashtag) {
            builder.append("&#");
        } else if (isDoubleTag) {
            builder.append("&##");
        }
    }

    static {
        int[] specialSymbols;
        int c;
        HEX_CHARS = new boolean[128];
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            LegacyAdvancedColorizer.HEX_CHARS[c] = true;
        }
        for (c = 97; c <= 102; c = (int)((char)(c + 1))) {
            LegacyAdvancedColorizer.HEX_CHARS[c] = true;
        }
        for (c = 65; c <= 70; c = (int)((char)(c + 1))) {
            LegacyAdvancedColorizer.HEX_CHARS[c] = true;
        }
        COLOR_CHARS_FLAGS = new boolean[128];
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            LegacyAdvancedColorizer.COLOR_CHARS_FLAGS[c] = true;
        }
        for (c = 97; c <= 102; c = (int)((char)(c + 1))) {
            LegacyAdvancedColorizer.COLOR_CHARS_FLAGS[c] = true;
        }
        for (c = 65; c <= 70; c = (int)((char)(c + 1))) {
            LegacyAdvancedColorizer.COLOR_CHARS_FLAGS[c] = true;
        }
        for (int sym : specialSymbols = new int[]{114, 82, 107, 108, 109, 110, 111, 75, 76, 77, 78, 79}) {
            LegacyAdvancedColorizer.COLOR_CHARS_FLAGS[sym] = true;
        }
    }
}

