/*
 * Decompiled with CFR 0.152.
 */
package ru.overwrite.protect.bukkit;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.time.LocalDateTime;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;
import ru.overwrite.protect.bukkit.ServerProtectorManager;
import ru.overwrite.protect.bukkit.api.ServerProtectorAPI;
import ru.overwrite.protect.bukkit.api.events.ServerProtectorPasswordEnterEvent;
import ru.overwrite.protect.bukkit.api.events.ServerProtectorPasswordFailEvent;
import ru.overwrite.protect.bukkit.api.events.ServerProtectorPasswordSuccessEvent;
import ru.overwrite.protect.bukkit.configuration.Config;
import ru.overwrite.protect.bukkit.configuration.data.BlockingSettings;
import ru.overwrite.protect.bukkit.configuration.data.EncryptionSettings;
import ru.overwrite.protect.bukkit.utils.Utils;

public final class PasswordHandler {
    private final ServerProtectorManager plugin;
    private final ServerProtectorAPI api;
    private final Config pluginConfig;
    private final Object2IntOpenHashMap<String> attempts = new Object2IntOpenHashMap();
    private final Map<String, BossBar> bossbars = new IdentityHashMap<String, BossBar>();

    public PasswordHandler(ServerProtectorManager plugin) {
        this.plugin = plugin;
        this.pluginConfig = plugin.getPluginConfig();
        this.api = plugin.getApi();
    }

    public void checkPassword(Player player, String input, boolean resync) {
        Runnable run = () -> {
            String pass;
            ServerProtectorPasswordEnterEvent enterEvent = new ServerProtectorPasswordEnterEvent(player, input);
            RegisteredListener[] listeners = enterEvent.getHandlers().getRegisteredListeners();
            if (this.pluginConfig.getApiSettings().callEventOnPasswordEnter() && listeners.length != 0 && !enterEvent.callEvent()) {
                return;
            }
            String playerPass = this.pluginConfig.getPerPlayerPasswords().get(player.getName());
            if (playerPass == null) {
                this.failedPassword(player);
                return;
            }
            EncryptionSettings encryptionSettings = this.pluginConfig.getEncryptionSettings();
            String salt = null;
            if (encryptionSettings.enableEncryption()) {
                salt = playerPass.split(":")[0];
                v0 = Utils.encryptPassword(input, salt, encryptionSettings.encryptMethods());
            } else {
                v0 = pass = input;
            }
            if (pass.equals(playerPass)) {
                this.correctPassword(player);
                return;
            }
            List<List<String>> oldMethods = encryptionSettings.oldEncryptMethods();
            if (encryptionSettings.enableEncryption() && !oldMethods.isEmpty()) {
                for (int i = 0; i < oldMethods.size(); ++i) {
                    List<String> oldEncryptMethod = oldMethods.get(i);
                    String oldgenPass = Utils.encryptPassword(input, salt, oldEncryptMethod);
                    if (!oldgenPass.equals(playerPass)) continue;
                    this.correctPassword(player);
                    return;
                }
            }
            this.failedPassword(player);
            if (this.pluginConfig.getPunishSettings().enableAttempts() && this.isAttemptsMax(player.getName())) {
                this.plugin.checkFail(player.getName(), this.pluginConfig.getCommands().failedPass());
            }
        };
        if (resync) {
            this.plugin.getRunner().runPlayer(run, player);
        } else {
            run.run();
        }
    }

    private boolean isAttemptsMax(String playerName) {
        int playerAttempts = this.attempts.getInt((Object)playerName);
        return playerAttempts >= this.pluginConfig.getPunishSettings().maxAttempts();
    }

    public void failedPassword(Player player) {
        ServerProtectorPasswordFailEvent failEvent;
        RegisteredListener[] listeners;
        if (!this.plugin.isCalledFromAllowedApplication()) {
            return;
        }
        String playerName = player.getName();
        if (this.pluginConfig.getPunishSettings().enableAttempts()) {
            this.attempts.addTo((Object)playerName, 1);
        }
        if ((listeners = (failEvent = new ServerProtectorPasswordFailEvent(player, this.attempts.getInt((Object)playerName))).getHandlers().getRegisteredListeners()).length != 0 && !failEvent.callEvent()) {
            return;
        }
        player.sendMessage(this.pluginConfig.getMessages().incorrect());
        if (this.pluginConfig.getMessageSettings().sendTitle()) {
            Utils.sendTitleMessage(this.pluginConfig.getTitles().incorrect(), player);
        }
        if (this.pluginConfig.getSoundSettings().enableSounds()) {
            Utils.sendSound(this.pluginConfig.getSoundSettings().onPasFail(), player);
        }
        if (this.pluginConfig.getLoggingSettings().loggingPas()) {
            this.plugin.logAction(this.pluginConfig.getLogMessages().failed(), player, LocalDateTime.now());
        }
        if (this.pluginConfig.getBroadcasts() != null) {
            this.plugin.sendAlert(player, this.pluginConfig.getBroadcasts().failed());
        }
    }

    public void correctPassword(Player player) {
        BossBar playerBossBar;
        if (!this.plugin.isCalledFromAllowedApplication()) {
            return;
        }
        ServerProtectorPasswordSuccessEvent successEvent = new ServerProtectorPasswordSuccessEvent(player);
        RegisteredListener[] listeners = successEvent.getHandlers().getRegisteredListeners();
        if (listeners.length != 0 && !successEvent.callEvent()) {
            return;
        }
        String playerName = player.getName();
        this.api.uncapturePlayer(playerName);
        player.sendMessage(this.pluginConfig.getMessages().correct());
        if (this.pluginConfig.getMessageSettings().sendTitle()) {
            Utils.sendTitleMessage(this.pluginConfig.getTitles().correct(), player);
        }
        this.plugin.getPerPlayerTime().removeInt((Object)playerName);
        this.api.clearRejoins(playerName);
        if (this.pluginConfig.getSoundSettings().enableSounds()) {
            Utils.sendSound(this.pluginConfig.getSoundSettings().onPasCorrect(), player);
        }
        if (this.pluginConfig.getEffectSettings().enableEffects()) {
            this.plugin.removeEffects(player);
        }
        this.showPlayer(player);
        this.api.authorisePlayer(player);
        if (this.pluginConfig.getSessionSettings().sessionTimeEnabled()) {
            this.plugin.getRunner().runDelayedAsync(() -> {
                if (!this.api.isAuthorised(player)) {
                    this.api.deauthorisePlayer(player);
                }
            }, (long)this.pluginConfig.getSessionSettings().sessionTime() * 20L);
        }
        if (this.pluginConfig.getLoggingSettings().loggingPas()) {
            this.plugin.logAction(this.pluginConfig.getLogMessages().passed(), player, LocalDateTime.now());
        }
        if (this.pluginConfig.getBossbarSettings().enableBossbar() && (playerBossBar = this.bossbars.get(playerName)) != null) {
            playerBossBar.removeAll();
            this.bossbars.remove(playerName);
        }
        if (this.pluginConfig.getBroadcasts() != null) {
            this.plugin.sendAlert(player, this.pluginConfig.getBroadcasts().passed());
        }
    }

    private void showPlayer(Player player) {
        BlockingSettings blockingSettings = this.pluginConfig.getBlockingSettings();
        if (!blockingSettings.hideOnEntering() && !blockingSettings.hideOtherOnEntering()) {
            return;
        }
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            if (blockingSettings.hideOnEntering()) {
                onlinePlayer.showPlayer((Plugin)this.plugin, player);
            }
            if (!blockingSettings.hideOtherOnEntering()) continue;
            player.showPlayer((Plugin)this.plugin, onlinePlayer);
        }
    }

    @Generated
    public Object2IntOpenHashMap<String> getAttempts() {
        return this.attempts;
    }

    @Generated
    public Map<String, BossBar> getBossbars() {
        return this.bossbars;
    }
}

