/*
 * Decompiled with CFR 0.152.
 */
package ru.overwrite.protect.bukkit;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.bukkit.potion.PotionEffect;
import ru.overwrite.protect.bukkit.PasswordHandler;
import ru.overwrite.protect.bukkit.api.CaptureReason;
import ru.overwrite.protect.bukkit.api.ServerProtectorAPI;
import ru.overwrite.protect.bukkit.commands.PasCommand;
import ru.overwrite.protect.bukkit.commands.UspCommand;
import ru.overwrite.protect.bukkit.configuration.Config;
import ru.overwrite.protect.bukkit.configuration.data.BlockingSettings;
import ru.overwrite.protect.bukkit.configuration.data.SecureSettings;
import ru.overwrite.protect.bukkit.configuration.data.SystemMessages;
import ru.overwrite.protect.bukkit.listeners.ChatListener;
import ru.overwrite.protect.bukkit.listeners.CommandSendListener;
import ru.overwrite.protect.bukkit.listeners.ConnectionListener;
import ru.overwrite.protect.bukkit.listeners.MainListener;
import ru.overwrite.protect.bukkit.listeners.TabCompleteListener;
import ru.overwrite.protect.bukkit.logging.Logger;
import ru.overwrite.protect.bukkit.logging.impl.BukkitLogger;
import ru.overwrite.protect.bukkit.logging.impl.PaperLogger;
import ru.overwrite.protect.bukkit.task.TaskManager;
import ru.overwrite.protect.bukkit.task.runner.Runner;
import ru.overwrite.protect.bukkit.task.runner.impl.BukkitRunner;
import ru.overwrite.protect.bukkit.task.runner.impl.PaperRunner;
import ru.overwrite.protect.bukkit.utils.FakePlugin;
import ru.overwrite.protect.bukkit.utils.PAPIUtils;
import ru.overwrite.protect.bukkit.utils.PluginMessage;
import ru.overwrite.protect.bukkit.utils.Utils;

public class ServerProtectorManager
extends JavaPlugin {
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("'['dd-MM-yyyy']' HH:mm:ss -");
    private final Logger pluginLogger = Utils.FOLIA ? new PaperLogger(this) : new BukkitLogger(this);
    private boolean paper;
    private FileConfiguration messageFile;
    private FileConfiguration dataFile;
    private String dataFileName;
    private String dataFilePath;
    private final Config pluginConfig = new Config(this);
    private final ServerProtectorAPI api = new ServerProtectorAPI(this);
    private final PasswordHandler passwordHandler = new PasswordHandler(this);
    private final Runner runner = Utils.FOLIA ? new PaperRunner(this) : new BukkitRunner(this);
    private PluginMessage pluginMessage;
    private final Object2IntOpenHashMap<String> perPlayerTime = new Object2IntOpenHashMap();
    private File logFile;
    public final Server server = this.getServer();
    private boolean safe;
    private final Map<String, Collection<PotionEffect>> oldEffects = new IdentityHashMap<String, Collection<PotionEffect>>();

    protected void checkPaper() {
        if (this.server.getName().equals("CraftBukkit")) {
            SystemMessages systemMessages = this.pluginConfig.getSystemMessages();
            this.runner.runPeriodical(() -> {
                this.pluginLogger.info(systemMessages.baselineWarn());
                this.pluginLogger.info(systemMessages.paper1());
                this.pluginLogger.info(systemMessages.paper2());
                this.pluginLogger.info(systemMessages.baselineWarn());
            }, 0L, 36000L);
            return;
        }
        this.paper = true;
    }

    protected void checkSafe(PluginManager pluginManager) {
        if (this.server.spigot().getConfig().getBoolean("settings.bungeecord")) {
            if (pluginManager.isPluginEnabled("BungeeGuard") || pluginManager.isPluginEnabled("SafeNET")) {
                this.safe = true;
                return;
            }
            this.logUnsafe();
            return;
        }
        this.safe = true;
    }

    public void logUnsafe() {
        SystemMessages systemMessages = this.pluginConfig.getSystemMessages();
        this.pluginLogger.info(systemMessages.baselineWarn());
        this.pluginLogger.info(systemMessages.bungeecord1());
        this.pluginLogger.info(systemMessages.bungeecord2());
        this.pluginLogger.info(systemMessages.bungeecord3());
        this.pluginLogger.info(systemMessages.baselineWarn());
    }

    protected void setupLogger(FileConfiguration config) {
        ConfigurationSection fileSettings = config.getConfigurationSection("file-settings");
        boolean fullPath = fileSettings.getBoolean("use-full-path");
        String logFilePath = fullPath ? fileSettings.getString("log-file-path") : this.getDataFolder().getPath();
        this.logFile = new File(logFilePath, fileSettings.getString("log-file"));
    }

    protected void setupProxy(ConfigurationSection mainSettings) {
        if (mainSettings.getBoolean("proxy", false)) {
            Messenger messenger = this.server.getMessenger();
            messenger.registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
            this.pluginMessage = new PluginMessage(this);
            messenger.registerIncomingPluginChannel((Plugin)this, "BungeeCord", (PluginMessageListener)this.pluginMessage);
        }
    }

    protected void loadConfigs(FileConfiguration config) {
        Utils.setupColorizer(config.getConfigurationSection("main-settings"));
        ConfigurationSection fileSettings = config.getConfigurationSection("file-settings");
        boolean fullPath = fileSettings.getBoolean("use-full-path", false);
        String absolutePath = this.getDataFolder().getAbsolutePath();
        this.dataFilePath = fullPath ? fileSettings.getString("data-file-path") : absolutePath;
        this.dataFileName = fileSettings.getString("data-file");
        this.dataFile = this.pluginConfig.getFile(this.dataFilePath, this.dataFileName);
        this.pluginConfig.save(this.dataFilePath, this.dataFile, this.dataFileName, false);
        this.messageFile = this.pluginConfig.getFile(absolutePath, "message.yml");
        this.pluginConfig.save(absolutePath, this.messageFile, "message.yml", false);
        this.setupPluginConfig(config);
        this.pluginConfig.setupPasswords(this.dataFile);
    }

    public void reloadConfigs() {
        this.runner.runAsync(() -> {
            this.reloadConfig();
            FileConfiguration config = this.getConfig();
            Utils.setupColorizer(config.getConfigurationSection("main-settings"));
            String absolutePath = this.getDataFolder().getAbsolutePath();
            this.messageFile = this.pluginConfig.getFile(absolutePath, "message.yml");
            ConfigurationSection fileSettings = config.getConfigurationSection("file-settings");
            boolean fullPath = fileSettings.getBoolean("use-full-path", false);
            this.dataFilePath = fullPath ? fileSettings.getString("data-file-path") : absolutePath;
            this.dataFileName = fileSettings.getString("data-file");
            this.dataFile = this.pluginConfig.getFile(this.dataFilePath, this.dataFileName);
            this.setupPluginConfig(config);
            this.pluginConfig.setupPasswords(this.dataFile);
        });
    }

    private void setupPluginConfig(FileConfiguration config) {
        this.pluginConfig.loadAccessData(config);
        this.pluginConfig.setupExcluded(config);
        FileConfiguration configFile = this.pluginConfig.getFile(this.dataFilePath, "config.yml");
        this.pluginConfig.loadMainSettings(config, configFile);
        this.pluginConfig.loadEncryptionSettings(config, configFile);
        this.pluginConfig.loadSecureSettings(config, configFile);
        this.pluginConfig.loadApiSettings(config, configFile);
        this.pluginConfig.loadGeyserSettings(config, configFile);
        this.pluginConfig.loadAdditionalChecks(config, configFile);
        this.pluginConfig.loadPunishSettings(config, configFile);
        this.pluginConfig.loadSessionSettings(config, configFile);
        this.pluginConfig.loadMessageSettings(config, configFile);
        this.pluginConfig.loadBossbarSettings(config, configFile);
        this.pluginConfig.loadSoundSettings(config, configFile);
        this.pluginConfig.loadEffects(config, configFile);
        this.pluginConfig.loadLoggingSettings(config, configFile);
        this.pluginConfig.loadFailCommands(config, configFile);
        this.pluginConfig.loadMsgMessages(this.messageFile);
        this.pluginConfig.loadUspMessages(this.messageFile);
        this.pluginConfig.loadLogFormats(this.messageFile);
        this.pluginConfig.loadSystemMessages(this.messageFile);
        ConfigurationSection messageSettings = config.getConfigurationSection("message-settings");
        if (messageSettings.getBoolean("send-titles")) {
            this.pluginConfig.loadTitleMessages(this.messageFile);
        }
        if (messageSettings.getBoolean("enable-broadcasts") || messageSettings.getBoolean("enable-console-broadcasts")) {
            this.pluginConfig.loadBroadcastMessages(this.messageFile);
        }
    }

    protected void registerListeners(PluginManager pluginManager) {
        Plugin fakePlugin;
        ServerProtectorManager plugin = this;
        if (this.paper && this.pluginConfig.getSecureSettings().useFakePlugin() && (fakePlugin = FakePlugin.createFakePlugin()) != null) {
            plugin = fakePlugin;
        }
        pluginManager.registerEvents((Listener)new ChatListener(this), (Plugin)plugin);
        pluginManager.registerEvents((Listener)new ConnectionListener(this), (Plugin)plugin);
        pluginManager.registerEvents((Listener)new MainListener(this), (Plugin)plugin);
        if (this.pluginConfig.getBlockingSettings().blockTabComplete()) {
            if (this.paper) {
                pluginManager.registerEvents((Listener)new TabCompleteListener(this), (Plugin)plugin);
            }
            if (Utils.SUB_VERSION >= 13) {
                pluginManager.registerEvents((Listener)new CommandSendListener(this), (Plugin)plugin);
            }
        }
    }

    protected void registerCommands(PluginManager pluginManager, ConfigurationSection mainSettings) {
        if (this.paper && mainSettings.getBoolean("use-command", true)) {
            try {
                CommandMap commandMap = this.server.getCommandMap();
                Constructor constructor = PluginCommand.class.getDeclaredConstructor(String.class, Plugin.class);
                constructor.setAccessible(true);
                PluginCommand command = (PluginCommand)constructor.newInstance(new Object[]{mainSettings.getString("pas-command", "pas"), this});
                command.setExecutor((CommandExecutor)new PasCommand(this));
                commandMap.register(this.getDescription().getName(), (Command)command);
            }
            catch (Exception ex) {
                this.pluginLogger.info("Unable to register password command! " + ex.getMessage());
                pluginManager.disablePlugin((Plugin)this);
            }
        } else {
            this.pluginLogger.info("Command for password entering will not be registered.");
        }
        PluginCommand uspCommand = this.getCommand("ultimateserverprotector");
        UspCommand uspCommandClass = new UspCommand(this);
        uspCommand.setExecutor((CommandExecutor)uspCommandClass);
    }

    public void startTasks(FileConfiguration config) {
        SecureSettings secureSettings;
        TaskManager taskManager = new TaskManager(this);
        taskManager.startMainCheck(this.pluginConfig.getMainSettings().checkInterval());
        taskManager.startCapturesMessages(config);
        if (this.pluginConfig.getPunishSettings().enableTime()) {
            taskManager.startCapturesTimer();
        }
        if ((secureSettings = this.pluginConfig.getSecureSettings()).enableNotAdminPunish()) {
            taskManager.startAdminCheck();
        }
        if (secureSettings.enableOpWhitelist()) {
            taskManager.startOpCheck();
        }
        if (secureSettings.enablePermissionBlacklist()) {
            taskManager.startPermsCheck();
        }
    }

    protected void checkForUpdates(ConfigurationSection mainSettings) {
        if (!mainSettings.getBoolean("update-checker", true)) {
            return;
        }
        Utils.checkUpdates(this, version -> {
            SystemMessages systemMessages = this.pluginConfig.getSystemMessages();
            this.pluginLogger.info(systemMessages.baselineDefault());
            if (this.getDescription().getVersion().equals(version)) {
                this.pluginLogger.info(systemMessages.updateLatest());
            } else {
                this.pluginLogger.info(systemMessages.updateOutdated1());
                this.pluginLogger.info(systemMessages.updateOutdated2());
                this.pluginLogger.info(systemMessages.updateOutdated3());
            }
            this.pluginLogger.info(systemMessages.baselineDefault());
        });
    }

    public void checkFail(String playerName, List<String> commands) {
        if (commands.isEmpty()) {
            return;
        }
        this.runner.run(() -> {
            for (String command : commands) {
                this.server.dispatchCommand((CommandSender)this.server.getConsoleSender(), command.replace("%player%", playerName));
                if (!this.pluginConfig.getLoggingSettings().loggingCommandExecution()) continue;
                LocalDateTime date = LocalDateTime.now();
                this.logToFile(this.pluginConfig.getLogMessages().command().replace("%player%", playerName).replace("%cmd%", command).replace("%date%", date.format(TIME_FORMATTER)));
            }
        });
    }

    public void giveEffects(Player player) {
        this.runner.runPlayer(() -> {
            if (!player.getActivePotionEffects().isEmpty()) {
                this.oldEffects.put(player.getName(), player.getActivePotionEffects());
            }
            player.addPotionEffects(this.pluginConfig.getEffectSettings().effects());
        }, player);
    }

    public void removeEffects(Player player) {
        this.runner.runPlayer(() -> {
            for (PotionEffect effect : player.getActivePotionEffects()) {
                player.removePotionEffect(effect.getType());
            }
            if (this.oldEffects.isEmpty()) {
                return;
            }
            Collection<PotionEffect> effects = this.oldEffects.get(player.getName());
            if (effects != null) {
                player.addPotionEffects(effects);
            }
            this.oldEffects.remove(player.getName());
        }, player);
    }

    public void applyHide(Player player) {
        this.runner.runPlayer(() -> {
            BlockingSettings blockingSettings = this.pluginConfig.getBlockingSettings();
            if (!blockingSettings.hideOnEntering() && !blockingSettings.hideOtherOnEntering()) {
                return;
            }
            for (Player onlinePlayer : this.server.getOnlinePlayers()) {
                if (blockingSettings.hideOnEntering()) {
                    onlinePlayer.hidePlayer((Plugin)this, player);
                }
                if (!blockingSettings.hideOtherOnEntering()) continue;
                player.hidePlayer((Plugin)this, onlinePlayer);
            }
        }, player);
    }

    protected void logEnableDisable(String msg, LocalDateTime date) {
        if (this.getConfig().getBoolean("logging-settings.logging-enable-disable", true)) {
            this.logToFile(msg.replace("%date%", date.format(TIME_FORMATTER)));
        }
    }

    public CaptureReason checkPermissions(Player player) {
        if (player.isOp()) {
            return CaptureReason.OPERATOR_REASON;
        }
        if (player.hasPermission("serverprotector.protect")) {
            return CaptureReason.DEFAULT_PERMISSION_REASON;
        }
        for (String perm : this.pluginConfig.getAccessData().perms()) {
            if (!player.hasPermission(perm)) continue;
            return new CaptureReason(perm);
        }
        return null;
    }

    public boolean isAdmin(String nick) {
        return this.pluginConfig.getPerPlayerPasswords().containsKey(nick);
    }

    public void sendAlert(Player player, String msg) {
        if (this.api.isExcluded(player, this.pluginConfig.getExcludedPlayers().alert())) {
            return;
        }
        msg = msg.replace("%player%", player.getName()).replace("%ip%", Utils.getIp(player));
        if (this.pluginConfig.getMainSettings().papiSupport()) {
            msg = PAPIUtils.parsePlaceholders(player, msg);
        }
        if (this.pluginConfig.getMessageSettings().enableBroadcasts()) {
            for (Player onlinePlayer : this.server.getOnlinePlayers()) {
                if (!onlinePlayer.hasPermission("serverprotector.admin") || player == onlinePlayer) continue;
                onlinePlayer.sendMessage(msg);
            }
            if (this.pluginMessage != null) {
                this.pluginMessage.sendCrossProxy(player, msg);
            }
        }
        if (this.pluginConfig.getMessageSettings().enableConsoleBroadcasts()) {
            this.server.getConsoleSender().sendMessage(msg);
        }
    }

    public void logAction(String message, Player player, LocalDateTime date) {
        this.runner.runAsync(() -> this.logToFile(message.replace("%player%", player.getName()).replace("%ip%", Utils.getIp(player)).replace("%date%", date.format(TIME_FORMATTER))));
    }

    public void logToFile(String message) {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.logFile, true));){
            bufferedWriter.write(message);
            bufferedWriter.newLine();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public boolean isCalledFromAllowedApplication() {
        StackWalker walker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
        List callStack = walker.walk(frames -> frames.map(StackWalker.StackFrame::getDeclaringClass).collect(Collectors.toList()));
        String className = ((Class)callStack.get(2)).getName();
        if (className.startsWith("ru.overwrite.protect.bukkit")) {
            return true;
        }
        List<String> allowedAuthApiCallsPackages = this.pluginConfig.getApiSettings().allowedAuthApiCallsPackages();
        if (allowedAuthApiCallsPackages.isEmpty()) {
            this.pluginLogger.warn("Found illegal method call from " + className);
            return false;
        }
        for (int i = 0; i < allowedAuthApiCallsPackages.size(); ++i) {
            String allowed = allowedAuthApiCallsPackages.get(i);
            if (!className.startsWith(allowed)) continue;
            return true;
        }
        this.pluginLogger.warn("Found illegal method call from " + className);
        return false;
    }

    @Generated
    public Logger getPluginLogger() {
        return this.pluginLogger;
    }

    @Generated
    public boolean isPaper() {
        return this.paper;
    }

    @Generated
    public FileConfiguration getMessageFile() {
        return this.messageFile;
    }

    @Generated
    public FileConfiguration getDataFile() {
        return this.dataFile;
    }

    @Generated
    public String getDataFileName() {
        return this.dataFileName;
    }

    @Generated
    public String getDataFilePath() {
        return this.dataFilePath;
    }

    @Generated
    public Config getPluginConfig() {
        return this.pluginConfig;
    }

    @Generated
    public ServerProtectorAPI getApi() {
        return this.api;
    }

    @Generated
    public PasswordHandler getPasswordHandler() {
        return this.passwordHandler;
    }

    @Generated
    public Runner getRunner() {
        return this.runner;
    }

    @Generated
    public PluginMessage getPluginMessage() {
        return this.pluginMessage;
    }

    @Generated
    public Object2IntOpenHashMap<String> getPerPlayerTime() {
        return this.perPlayerTime;
    }

    @Generated
    public boolean isSafe() {
        return this.safe;
    }

    @Generated
    public void setDataFile(FileConfiguration dataFile) {
        this.dataFile = dataFile;
    }
}

