/*
 * Decompiled with CFR 0.152.
 */
package ru.overwrite.protect.bukkit.api;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.jetbrains.annotations.NotNull;
import ru.overwrite.protect.bukkit.ServerProtectorManager;
import ru.overwrite.protect.bukkit.configuration.Config;
import ru.overwrite.protect.bukkit.logging.Logger;
import ru.overwrite.protect.bukkit.utils.Utils;

public final class ServerProtectorAPI {
    private final ServerProtectorManager plugin;
    private final Config pluginConfig;
    private final Logger pluginLogger;
    private final Set<String> captured = new HashSet<String>();
    private final Map<String, String> sessions = new HashMap<String, String>();
    private final Set<String> saved = new HashSet<String>();
    private final Object2IntOpenHashMap<String> rejoins = new Object2IntOpenHashMap();

    public ServerProtectorAPI(@NotNull ServerProtectorManager plugin) {
        this.plugin = plugin;
        this.pluginConfig = plugin.getPluginConfig();
        this.pluginLogger = plugin.getPluginLogger();
    }

    public boolean isAnybodyCaptured() {
        return !this.captured.isEmpty();
    }

    public boolean isCaptured(@NotNull Player player) {
        return this.isCaptured(player.getName());
    }

    public boolean isCaptured(@NotNull String playerName) {
        if (!this.isAnybodyCaptured()) {
            return false;
        }
        return this.captured.contains(playerName);
    }

    public void capturePlayer(@NotNull Player player) {
        this.capturePlayer(player.getName());
    }

    public void capturePlayer(@NotNull String playerName) {
        if (this.isCaptured(playerName)) {
            this.warning("Unable to capture " + playerName + " Reason: Already captured");
            return;
        }
        this.captured.add(playerName);
    }

    public void uncapturePlayer(@NotNull Player player) {
        this.uncapturePlayer(player.getName());
    }

    public void uncapturePlayer(@NotNull String playerName) {
        if (!this.plugin.isCalledFromAllowedApplication()) {
            this.warning("Unable to uncapture " + playerName + " Reason: Action not allowed");
            return;
        }
        if (!this.captured.remove(playerName)) {
            this.warning("Unable to uncapture " + playerName + " Reason: Not captured");
        }
    }

    public boolean isExcluded(@NotNull Player player, @NotNull List<String> list) {
        return this.pluginConfig.getSecureSettings().enableExcludedPlayers() && !list.isEmpty() && list.contains(player.getName());
    }

    public boolean isExcluded(@NotNull String playerName, @NotNull List<String> list) {
        return this.pluginConfig.getSecureSettings().enableExcludedPlayers() && !list.isEmpty() && list.contains(playerName);
    }

    public boolean isAuthorised(@NotNull Player player) {
        return this.isAuthorised(player.getName(), Utils.getIp(player));
    }

    public boolean isAuthorised(@NotNull Player player, @NotNull String ip) {
        return this.isAuthorised(player.getName(), ip);
    }

    public boolean isAuthorised(@NotNull String playerName, @NotNull String ip) {
        return this.pluginConfig.getSessionSettings().session() ? this.hasSession(playerName, ip) : this.saved.contains(playerName);
    }

    public boolean hasSession(@NotNull Player player) {
        return this.hasSession(player.getName(), Utils.getIp(player));
    }

    public boolean hasSession(@NotNull Player player, @NotNull String ip) {
        return this.hasSession(player.getName(), ip);
    }

    public boolean hasSession(@NotNull String playerName, @NotNull String ip) {
        if (this.sessions.isEmpty()) {
            return false;
        }
        String sessionIp = this.sessions.get(playerName);
        return sessionIp != null && sessionIp.equals(ip);
    }

    public void authorisePlayer(@NotNull Player player) {
        this.authorisePlayer(player.getName(), Utils.getIp(player));
    }

    public void authorisePlayer(@NotNull Player player, @NotNull String ip) {
        this.authorisePlayer(player.getName(), ip);
    }

    public void authorisePlayer(@NotNull String playerName, @NotNull String ip) {
        if (!this.plugin.isCalledFromAllowedApplication()) {
            this.warning("Unable to authorise " + playerName + " Reason: Action not allowed");
            return;
        }
        if (this.isAuthorised(playerName, ip)) {
            this.warning("Unable to authorise " + playerName + " Reason: Already authorised");
            return;
        }
        if (this.pluginConfig.getSessionSettings().session()) {
            this.sessions.put(playerName, ip);
            return;
        }
        this.saved.add(playerName);
    }

    public void deauthorisePlayer(@NotNull Player player) {
        this.deauthorisePlayer(player.getName(), Utils.getIp(player));
    }

    public void deauthorisePlayer(@NotNull Player player, @NotNull String ip) {
        this.deauthorisePlayer(player.getName(), ip);
    }

    public void deauthorisePlayer(@NotNull String playerName, @NotNull String ip) {
        if (!this.plugin.isCalledFromAllowedApplication()) {
            this.warning("Unable to deauthorise " + playerName + " Reason: Action not allowed");
            return;
        }
        if (!this.isAuthorised(playerName, ip)) {
            this.warning("Unable to deauthorise " + playerName + " Reason: Is not authorised");
            return;
        }
        if (this.pluginConfig.getSessionSettings().session()) {
            this.sessions.remove(playerName);
            return;
        }
        this.saved.remove(playerName);
    }

    public void unsavePlayer(@NotNull Player player) {
        this.unsavePlayer(player.getName());
    }

    public void unsavePlayer(@NotNull String playerName) {
        this.saved.remove(playerName);
    }

    public void handleInteraction(@NotNull Player player, @NotNull Cancellable e) {
        if (this.isCaptured(player)) {
            e.setCancelled(true);
        }
    }

    public int getPlayerRejoins(@NotNull Player player) {
        return this.getPlayerRejoins(player.getName());
    }

    public int getPlayerRejoins(@NotNull String playerName) {
        return this.rejoins.getInt((Object)playerName);
    }

    public int addRejoin(@NotNull Player player, int amount) {
        return this.addRejoin(player.getName(), amount);
    }

    public int addRejoin(@NotNull String playerName, int amount) {
        return this.rejoins.addTo((Object)playerName, amount);
    }

    public void clearRejoins(@NotNull Player player) {
        this.clearRejoins(player.getName());
    }

    public void clearRejoins(@NotNull String playerName) {
        this.rejoins.removeInt((Object)playerName);
    }

    public void clearCaptured() {
        if (!this.plugin.isCalledFromAllowedApplication()) {
            this.warning("Unable to clear captured players. Reason: Action not allowed");
            return;
        }
        this.captured.clear();
    }

    public void clearSessions() {
        if (!this.plugin.isCalledFromAllowedApplication()) {
            this.warning("Unable to clear active sessions. Reason: Action not allowed");
            return;
        }
        this.sessions.clear();
    }

    public void clearSaved() {
        if (!this.plugin.isCalledFromAllowedApplication()) {
            this.warning("Unable to clear saved players. Reason: Action not allowed");
            return;
        }
        this.saved.clear();
    }

    private void warning(String message) {
        if (!this.pluginConfig.getMainSettings().suppressApiWarnings()) {
            this.pluginLogger.warn(message);
        }
    }
}

