/*
 * Decompiled with CFR 0.152.
 */
package ru.overwrite.protect.bukkit.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import ru.overwrite.protect.bukkit.ServerProtectorManager;
import ru.overwrite.protect.bukkit.commands.subcommands.AbstractSubCommand;
import ru.overwrite.protect.bukkit.commands.subcommands.AddipSubcommand;
import ru.overwrite.protect.bukkit.commands.subcommands.AddopSubcommand;
import ru.overwrite.protect.bukkit.commands.subcommands.DebugPrintSubcommand;
import ru.overwrite.protect.bukkit.commands.subcommands.EncryptSubcommand;
import ru.overwrite.protect.bukkit.commands.subcommands.GenpassSubcommand;
import ru.overwrite.protect.bukkit.commands.subcommands.LogoutSubcommand;
import ru.overwrite.protect.bukkit.commands.subcommands.RebootSubcommand;
import ru.overwrite.protect.bukkit.commands.subcommands.ReloadSubcommand;
import ru.overwrite.protect.bukkit.commands.subcommands.RemipSubcommand;
import ru.overwrite.protect.bukkit.commands.subcommands.RemopSubcommand;
import ru.overwrite.protect.bukkit.commands.subcommands.RempassSubcommand;
import ru.overwrite.protect.bukkit.commands.subcommands.SetpassSubcommand;
import ru.overwrite.protect.bukkit.commands.subcommands.UpdateSubcommand;
import ru.overwrite.protect.bukkit.configuration.Config;
import ru.overwrite.protect.bukkit.configuration.data.UspMessages;

public final class UspCommand
implements TabExecutor {
    private final ServerProtectorManager plugin;
    private final Config pluginConfig;
    private final Map<String, AbstractSubCommand> subCommands = new HashMap<String, AbstractSubCommand>(16, 1.0f);

    public UspCommand(ServerProtectorManager plugin) {
        this.plugin = plugin;
        this.pluginConfig = plugin.getPluginConfig();
        this.registerSubCommands(plugin);
    }

    private void registerSubCommands(ServerProtectorManager plugin) {
        this.registerSubCommand(new LogoutSubcommand(plugin));
        this.registerSubCommand(new ReloadSubcommand(plugin));
        this.registerSubCommand(new RebootSubcommand(plugin));
        this.registerSubCommand(new EncryptSubcommand(plugin));
        this.registerSubCommand(new GenpassSubcommand(plugin));
        this.registerSubCommand(new SetpassSubcommand(plugin));
        this.registerSubCommand(new AddopSubcommand(plugin));
        this.registerSubCommand(new AddipSubcommand(plugin));
        this.registerSubCommand(new RempassSubcommand(plugin));
        this.registerSubCommand(new RemopSubcommand(plugin));
        this.registerSubCommand(new RemipSubcommand(plugin));
        this.registerSubCommand(new UpdateSubcommand(plugin));
        this.registerSubCommand(new DebugPrintSubcommand(plugin));
    }

    private void registerSubCommand(AbstractSubCommand subCmd) {
        this.subCommands.put(subCmd.getName(), subCmd);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, String[] args) {
        if (args.length == 0) {
            this.sendHelp(sender, label);
            return true;
        }
        AbstractSubCommand subCommand = this.subCommands.get(args[0].toLowerCase());
        if (subCommand != null) {
            if (subCommand.isAdminCommand()) {
                if (!this.pluginConfig.getMainSettings().enableAdminCommands()) {
                    this.sendHelp(sender, label);
                    return false;
                }
                if (this.pluginConfig.getSecureSettings().onlyConsoleUsp() && !(sender instanceof ConsoleCommandSender)) {
                    sender.sendMessage(this.pluginConfig.getUspMessages().consoleOnly());
                    return false;
                }
            }
            if (!sender.hasPermission(subCommand.getPermission())) {
                this.sendHelp(sender, label);
                return false;
            }
            return subCommand.execute(sender, label, args);
        }
        if (sender.hasPermission("serverprotector.protect")) {
            this.sendHelp(sender, label);
            return true;
        }
        sender.sendMessage("\u00a76\u2756 \u00a77Running \u00a7c\u00a7lUltimateServerProtector " + this.plugin.getDescription().getVersion() + "\u00a77 by \u00a75OverwriteMC");
        return true;
    }

    private void sendHelp(CommandSender sender, String label) {
        UspMessages uspMessages = this.pluginConfig.getUspMessages();
        this.sendCmdMessage(sender, uspMessages.usage(), label, "protect");
        this.sendCmdMessage(sender, uspMessages.usageLogout(), label, "protect");
        if (!sender.hasPermission("admin")) {
            return;
        }
        this.sendCmdMessage(sender, uspMessages.usageReload(), label, "reload");
        this.sendCmdMessage(sender, uspMessages.usageReboot(), label, "reboot");
        if (this.pluginConfig.getEncryptionSettings().enableEncryption()) {
            this.sendCmdMessage(sender, uspMessages.usageEncrypt(), label, "encrypt");
        }
        if (!this.pluginConfig.getMainSettings().enableAdminCommands()) {
            sender.sendMessage(uspMessages.otherDisabled());
            return;
        }
        this.sendCmdMessage(sender, uspMessages.setPassUsage(), label, "setpass");
        this.sendCmdMessage(sender, uspMessages.usageRemPass(), label, "rempass");
        this.sendCmdMessage(sender, uspMessages.usageAddOp(), label, "addop");
        this.sendCmdMessage(sender, uspMessages.usageRemOp(), label, "remop");
        this.sendCmdMessage(sender, uspMessages.usageAddIp(), label, "addip");
        this.sendCmdMessage(sender, uspMessages.usageRemIp(), label, "remip");
    }

    private void sendCmdMessage(CommandSender sender, String msg, String label, String permission) {
        if (sender.hasPermission("serverprotector." + permission)) {
            sender.sendMessage(msg.replace("%cmd%", label));
        }
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (this.pluginConfig.getSecureSettings().onlyConsoleUsp() && !(sender instanceof ConsoleCommandSender)) {
            return List.of();
        }
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions.add("logout");
            completions.add("reload");
            completions.add("reboot");
            if (this.pluginConfig.getEncryptionSettings().enableEncryption()) {
                completions.add("encrypt");
            }
            if (this.pluginConfig.getMainSettings().enableAdminCommands()) {
                completions.add("setpass");
                completions.add("rempass");
                completions.add("addop");
                completions.add("remop");
                completions.add("addip");
                completions.add("remip");
                completions.add("debug");
            }
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("debug")) {
            completions.add("printconfigdata");
            completions.add("checkplayer");
        }
        return this.getResult(args, completions);
    }

    private List<String> getResult(String[] args, List<String> completions) {
        if (completions.isEmpty()) {
            return completions;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < completions.size(); ++i) {
            String c = completions.get(i);
            if (!StringUtil.startsWithIgnoreCase((String)c, (String)args[args.length - 1])) continue;
            result.add(c);
        }
        return result;
    }
}

