/*
 * Decompiled with CFR 0.152.
 */
package ru.overwrite.protect.bukkit.commands.subcommands;

import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import ru.overwrite.protect.bukkit.ServerProtectorManager;
import ru.overwrite.protect.bukkit.commands.subcommands.AbstractSubCommand;
import ru.overwrite.protect.bukkit.logging.Logger;

public class DebugPrintSubcommand
extends AbstractSubCommand {
    public DebugPrintSubcommand(ServerProtectorManager plugin) {
        super(plugin, "debug", "serverprotector.debug", true);
    }

    @Override
    public boolean execute(CommandSender sender, String label, String[] args) {
        Logger logger = this.plugin.getPluginLogger();
        if (args.length < 2) {
            sender.sendMessage("\u00a7cSpecify option");
            return true;
        }
        switch (args[1]) {
            case "printconfigdata": {
                logger.info(this.pluginConfig.getSystemMessages().baselineDefault());
                logger.info("\u00a7eExcluded players: " + this.pluginConfig.getExcludedPlayers().toString());
                logger.info("\u00a76Access data: " + this.pluginConfig.getAccessData().toString());
                logger.info("\u00a7eAPI settings: " + this.pluginConfig.getApiSettings().toString());
                logger.info("\u00a76Blocking settings: " + this.pluginConfig.getBlockingSettings().toString());
                logger.info("\u00a7eCommands: " + this.pluginConfig.getCommands().toString());
                logger.info("\u00a76Effect settings: " + this.pluginConfig.getEffectSettings().toString());
                logger.info("\u00a7eEncryption settings: " + this.pluginConfig.getEncryptionSettings().toString());
                logger.info("\u00a76Geyser settings: " + this.pluginConfig.getGeyserSettings().toString());
                logger.info("\u00a7eLogging settings: " + this.pluginConfig.getLoggingSettings().toString());
                logger.info("\u00a7eMain settings: " + this.pluginConfig.getMainSettings().toString());
                logger.info("\u00a7eMessage settings: " + this.pluginConfig.getMessageSettings().toString());
                logger.info("\u00a76Punish settings: " + this.pluginConfig.getPunishSettings().toString());
                logger.info("\u00a7eSecure settings: " + this.pluginConfig.getSecureSettings().toString());
                logger.info("\u00a76Session settings: " + this.pluginConfig.getSessionSettings().toString());
                logger.info("\u00a7eSound settings: " + this.pluginConfig.getSoundSettings().toString());
                logger.info(this.pluginConfig.getSystemMessages().baselineDefault());
                break;
            }
            case "checkplayer": {
                if (args.length < 3) {
                    sender.sendMessage("\u00a7cPlayer not provided");
                    break;
                }
                Player playerToCheck = Bukkit.getPlayer((String)args[2]);
                if (playerToCheck == null) {
                    sender.sendMessage("\u00a7cPlayer not found: " + args[2]);
                    break;
                }
                logger.info("\u00a76Is captured: " + this.api.isCaptured(playerToCheck));
                logger.info("\u00a76Is authorised: " + this.api.isAuthorised(playerToCheck));
                logger.info("\u00a76Has session: " + this.api.hasSession(playerToCheck));
                logger.info("\u00a76Is admin (has password): " + this.plugin.isAdmin(playerToCheck.getName()));
                if (!this.pluginConfig.getSecureSettings().enableExcludedPlayers()) break;
                logger.info("\u00a76Is excluded from adminPass: " + this.api.isExcluded(playerToCheck, this.pluginConfig.getExcludedPlayers().adminPass()));
                logger.info("\u00a76Is excluded from opWhitelist: " + this.api.isExcluded(playerToCheck, this.pluginConfig.getExcludedPlayers().opWhitelist()));
                logger.info("\u00a76Is excluded from ipWhitelist: " + this.api.isExcluded(playerToCheck, this.pluginConfig.getExcludedPlayers().ipWhitelist()));
                logger.info("\u00a76Is excluded from blacklistedPerms: " + this.api.isExcluded(playerToCheck, this.pluginConfig.getExcludedPlayers().blacklistedPerms()));
                logger.info("\u00a76Is excluded from alerts: " + this.api.isExcluded(playerToCheck, this.pluginConfig.getExcludedPlayers().alert()));
                break;
            }
            default: {
                sender.sendMessage("\u00a7cUnknown type: " + args[1]);
                return false;
            }
        }
        return true;
    }
}

