/*
 * Decompiled with CFR 0.152.
 */
package ru.overwrite.protect.bukkit.commands.subcommands;

import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import ru.overwrite.protect.bukkit.ServerProtectorManager;
import ru.overwrite.protect.bukkit.commands.subcommands.AbstractSubCommand;
import ru.overwrite.protect.bukkit.configuration.data.EncryptionSettings;
import ru.overwrite.protect.bukkit.configuration.data.UspMessages;
import ru.overwrite.protect.bukkit.utils.Utils;

public class SetpassSubcommand
extends AbstractSubCommand {
    public SetpassSubcommand(ServerProtectorManager plugin) {
        super(plugin, "setpass", "serverprotector.setpass", true);
    }

    @Override
    public boolean execute(CommandSender sender, String label, String[] args) {
        UspMessages uspMessages = this.pluginConfig.getUspMessages();
        if (args.length > 1) {
            String nickname = args[1];
            if (Utils.SUB_VERSION >= 16) {
                OfflinePlayer targetPlayer = Bukkit.getOfflinePlayerIfCached((String)nickname);
                if (targetPlayer == null) {
                    sender.sendMessage(uspMessages.playerNotFound().replace("%nick%", nickname));
                    return true;
                }
                nickname = targetPlayer.getName();
            }
            if (this.plugin.isAdmin(nickname)) {
                sender.sendMessage(uspMessages.alreadyInConfig());
                return true;
            }
            if (args.length < 4) {
                this.addAdmin(nickname, args[2]);
                sender.sendMessage(uspMessages.playerAdded().replace("%nick%", nickname));
                return true;
            }
        }
        this.sendCmdUsage(sender, uspMessages.setPassUsage(), label);
        return true;
    }

    private void addAdmin(String nick, String pas) {
        FileConfiguration dataFile = this.pluginConfig.getFile(this.plugin.getDataFilePath(), this.plugin.getDataFileName());
        EncryptionSettings encryptionSettings = this.pluginConfig.getEncryptionSettings();
        if (!encryptionSettings.enableEncryption()) {
            dataFile.set("data." + nick + ".pass", (Object)pas);
        } else if (encryptionSettings.autoEncryptPasswords()) {
            String encryptedPas = Utils.encryptPassword(pas, Utils.generateSalt(encryptionSettings.saltLength()), encryptionSettings.encryptMethods());
            dataFile.set("data." + nick + ".encrypted-pass", (Object)encryptedPas);
        } else {
            dataFile.set("data." + nick + ".encrypted-pass", (Object)pas);
        }
        this.pluginConfig.save(this.plugin.getDataFilePath(), dataFile, this.plugin.getDataFileName(), true);
        this.plugin.setDataFile(dataFile);
        this.pluginConfig.setupPasswords(dataFile);
    }
}

