/*
 * Decompiled with CFR 0.152.
 */
package ru.overwrite.protect.bukkit.configuration;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import ru.overwrite.protect.bukkit.ServerProtectorManager;
import ru.overwrite.protect.bukkit.configuration.data.AccessData;
import ru.overwrite.protect.bukkit.configuration.data.ApiSettings;
import ru.overwrite.protect.bukkit.configuration.data.BlockingSettings;
import ru.overwrite.protect.bukkit.configuration.data.BossbarSettings;
import ru.overwrite.protect.bukkit.configuration.data.Broadcasts;
import ru.overwrite.protect.bukkit.configuration.data.Commands;
import ru.overwrite.protect.bukkit.configuration.data.EffectSettings;
import ru.overwrite.protect.bukkit.configuration.data.EncryptionSettings;
import ru.overwrite.protect.bukkit.configuration.data.ExcludedPlayers;
import ru.overwrite.protect.bukkit.configuration.data.GeyserSettings;
import ru.overwrite.protect.bukkit.configuration.data.LogMessages;
import ru.overwrite.protect.bukkit.configuration.data.LoggingSettings;
import ru.overwrite.protect.bukkit.configuration.data.MainSettings;
import ru.overwrite.protect.bukkit.configuration.data.MessageSettings;
import ru.overwrite.protect.bukkit.configuration.data.Messages;
import ru.overwrite.protect.bukkit.configuration.data.PunishSettings;
import ru.overwrite.protect.bukkit.configuration.data.SecureSettings;
import ru.overwrite.protect.bukkit.configuration.data.SessionSettings;
import ru.overwrite.protect.bukkit.configuration.data.SoundSettings;
import ru.overwrite.protect.bukkit.configuration.data.SystemMessages;
import ru.overwrite.protect.bukkit.configuration.data.Titles;
import ru.overwrite.protect.bukkit.configuration.data.UspMessages;
import ru.overwrite.protect.bukkit.logging.Logger;
import ru.overwrite.protect.bukkit.utils.Utils;

public final class Config {
    private final ServerProtectorManager plugin;
    private final Logger pluginLogger;
    private Map<String, String> perPlayerPasswords;
    private MainSettings mainSettings;
    private EncryptionSettings encryptionSettings;
    private GeyserSettings geyserSettings;
    private BlockingSettings blockingSettings;
    private SessionSettings sessionSettings;
    private PunishSettings punishSettings;
    private SecureSettings secureSettings;
    private ApiSettings apiSettings;
    private MessageSettings messageSettings;
    private BossbarSettings bossbarSettings;
    private SoundSettings soundSettings;
    private EffectSettings effectSettings;
    private LoggingSettings loggingSettings;
    private Commands commands;
    private AccessData accessData;
    private ExcludedPlayers excludedPlayers;
    private UspMessages uspMessages;
    private Messages messages;
    private Titles titles;
    private Broadcasts broadcasts;
    private LogMessages logMessages;
    private SystemMessages systemMessages;

    public Config(ServerProtectorManager plugin) {
        this.plugin = plugin;
        this.pluginLogger = plugin.getPluginLogger();
    }

    public void setupPasswords(FileConfiguration dataFile) {
        ConfigurationSection data = dataFile.getConfigurationSection("data");
        boolean shouldSave = false;
        Set keys = data.getKeys(false);
        HashMap<String, String> perPlayerPasswords = new HashMap<String, String>(keys.size());
        for (String nick : keys) {
            String playerNick;
            String string = playerNick = !this.geyserSettings.prefix().isBlank() && this.geyserSettings.nicknames().contains(nick) ? this.geyserSettings.prefix() + nick : nick;
            if (!this.encryptionSettings.enableEncryption()) {
                perPlayerPasswords.put(playerNick, data.getString(nick + ".pass"));
                continue;
            }
            if (this.encryptionSettings.autoEncryptPasswords() && data.getString(nick + ".pass") != null) {
                String encryptedPas = Utils.encryptPassword(data.getString(nick + ".pass"), Utils.generateSalt(this.encryptionSettings.saltLength()), this.encryptionSettings.encryptMethods());
                data.set(nick + ".encrypted-pass", (Object)encryptedPas);
                data.set(nick + ".pass", null);
                perPlayerPasswords.put(playerNick, encryptedPas);
                shouldSave = true;
                this.plugin.setDataFile(dataFile);
                continue;
            }
            perPlayerPasswords.put(playerNick, data.getString(nick + ".encrypted-pass"));
        }
        this.perPlayerPasswords = Map.copyOf(perPlayerPasswords);
        if (shouldSave) {
            this.save(this.plugin.getDataFilePath(), dataFile, this.plugin.getDataFileName(), false);
        }
    }

    public void loadMainSettings(FileConfiguration config, FileConfiguration configFile) {
        ConfigurationSection mainSettings = config.getConfigurationSection("main-settings");
        if (mainSettings == null) {
            this.pluginLogger.warn("Configuration section main-settings not found!");
            ConfigurationSection section = configFile.createSection("main-settings");
            section.set("serializer", (Object)"LEGACY");
            section.set("prefix", (Object)"[UltimateServerProtector]");
            section.set("pas-command", (Object)"pas");
            section.set("use-command", (Object)true);
            section.set("enable-admin-commands", (Object)false);
            section.set("check-interval", (Object)40);
            section.set("papi-support", (Object)false);
            section.set("suppress-api-warnings", (Object)false);
            this.save(this.plugin.getDataFilePath(), configFile, "config.yml", false);
            this.pluginLogger.info("Created section main-settings");
            mainSettings = section;
        }
        this.mainSettings = new MainSettings(mainSettings.getString("prefix", "[UltimateServerProtector]"), mainSettings.getString("pas-command", "pas"), mainSettings.getBoolean("use-command", true), mainSettings.getBoolean("enable-admin-commands", false), mainSettings.getLong("check-interval", 40L), mainSettings.getBoolean("papi-support", false), mainSettings.getBoolean("suppress-api-warnings", false));
    }

    public void loadEncryptionSettings(FileConfiguration config, FileConfiguration configFile) {
        ConfigurationSection encryptionSettings = config.getConfigurationSection("encryption-settings");
        if (encryptionSettings == null) {
            this.pluginLogger.warn("Configuration section encryption-settings not found!");
            ConfigurationSection section = configFile.createSection("encryption-settings");
            section.set("enable-encryption", (Object)false);
            section.set("encrypt-method", (Object)"");
            section.set("old-encrypt-methods", List.of());
            section.set("salt-length", (Object)24);
            section.set("auto-encrypt-passwords", (Object)true);
            this.save(this.plugin.getDataFilePath(), configFile, "config.yml", false);
            this.pluginLogger.info("Created section encryption-settings");
            encryptionSettings = section;
        }
        this.encryptionSettings = new EncryptionSettings(encryptionSettings.getBoolean("enable-encryption", false), this.getEncryptionMethods(encryptionSettings), encryptionSettings.getInt("salt-length", 24), encryptionSettings.getBoolean("auto-encrypt-passwords", true), this.getOldEncryptionMethods(encryptionSettings));
    }

    private List<String> getEncryptionMethods(ConfigurationSection section) {
        String encryptionMethod = section.getString("encrypt-method", "").trim();
        if (encryptionMethod.isEmpty()) {
            return List.of();
        }
        return this.parseEncryptionMethod(encryptionMethod);
    }

    private List<List<String>> getOldEncryptionMethods(ConfigurationSection section) {
        List oldEncryptionMethods = section.getStringList("old-encrypt-methods");
        if (oldEncryptionMethods.isEmpty()) {
            return List.of();
        }
        ArrayList<List<String>> result = new ArrayList<List<String>>(oldEncryptionMethods.size());
        for (String encryptionMethod : oldEncryptionMethods) {
            result.add(this.parseEncryptionMethod(encryptionMethod));
        }
        return List.copyOf(result);
    }

    private List<String> parseEncryptionMethod(String encryptionMethod) {
        String[] parts = encryptionMethod.split(";");
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = parts[i].trim().toUpperCase();
        }
        return List.of(parts);
    }

    public void loadGeyserSettings(FileConfiguration config, FileConfiguration configFile) {
        ConfigurationSection geyserSettings = config.getConfigurationSection("geyser-settings");
        if (geyserSettings == null) {
            this.pluginLogger.warn("Configuration section geyser-settings not found!");
            ConfigurationSection section = configFile.createSection("geyser-settings");
            section.set("geyser-prefix", (Object)".");
            section.set("geyser-nicknames", List.of("test99999"));
            this.save(this.plugin.getDataFilePath(), configFile, "config.yml", false);
            this.pluginLogger.info("Created section geyser-settings");
            geyserSettings = section;
        }
        this.geyserSettings = new GeyserSettings(geyserSettings.getString("geyser-prefix", "."), Set.copyOf(geyserSettings.getStringList("geyser-nicknames")));
    }

    public void loadAdditionalChecks(FileConfiguration config, FileConfiguration configFile) {
        ConfigurationSection blockingSettings = config.getConfigurationSection("blocking-settings");
        if (blockingSettings == null) {
            this.pluginLogger.warn("Configuration section blocking-settings not found!");
            ConfigurationSection section = configFile.createSection("blocking-settings");
            section.set("block-item-drop", (Object)true);
            section.set("block-item-pickup", (Object)true);
            section.set("block-tab-complete", (Object)true);
            section.set("block-damage", (Object)true);
            section.set("block-damaging-entity", (Object)true);
            section.set("block-inventory-open", (Object)false);
            section.set("hide-on-entering", (Object)true);
            section.set("hide-other-on-entering", (Object)true);
            section.set("allow-orientation-change", (Object)false);
            this.save(this.plugin.getDataFilePath(), configFile, "config.yml", false);
            this.pluginLogger.info("Created section blocking-settings");
            blockingSettings = section;
        }
        this.blockingSettings = new BlockingSettings(blockingSettings.getBoolean("block-item-drop", true), blockingSettings.getBoolean("block-item-pickup", true), blockingSettings.getBoolean("block-tab-complete", true), blockingSettings.getBoolean("block-damage", true), blockingSettings.getBoolean("block-damaging-entity", true), blockingSettings.getBoolean("block-inventory-open", false), blockingSettings.getBoolean("hide-on-entering", true), blockingSettings.getBoolean("hide-other-on-entering", true), blockingSettings.getBoolean("allow-orientation-change", false));
    }

    public void loadSessionSettings(FileConfiguration config, FileConfiguration configFile) {
        ConfigurationSection sessionSettings = config.getConfigurationSection("session-settings");
        if (sessionSettings == null) {
            this.pluginLogger.warn("Configuration section session-settings not found!");
            ConfigurationSection section = configFile.createSection("session-settings");
            section.set("session", (Object)true);
            section.set("session-time-enabled", (Object)true);
            section.set("session-time", (Object)21600);
            this.save(this.plugin.getDataFilePath(), configFile, "config.yml", false);
            this.pluginLogger.info("Created section session-settings");
            sessionSettings = section;
        }
        this.sessionSettings = new SessionSettings(sessionSettings.getBoolean("session", true), sessionSettings.getBoolean("session-time-enabled", true), sessionSettings.getInt("session-time", 21600));
    }

    public void loadPunishSettings(FileConfiguration config, FileConfiguration configFile) {
        ConfigurationSection punishSettings = config.getConfigurationSection("punish-settings");
        if (punishSettings == null) {
            this.pluginLogger.warn("Configuration section punish-settings not found!");
            ConfigurationSection section = configFile.createSection("punish-settings");
            section.set("enable-attempts", (Object)true);
            section.set("max-attempts", (Object)3);
            section.set("enable-time", (Object)true);
            section.set("time", (Object)60);
            section.set("enable-rejoin", (Object)true);
            section.set("max-rejoins", (Object)3);
            this.save(this.plugin.getDataFilePath(), configFile, "config.yml", false);
            this.pluginLogger.info("Created section punish-settings");
            punishSettings = section;
        }
        this.punishSettings = new PunishSettings(punishSettings.getBoolean("enable-attempts", true), punishSettings.getInt("max-attempts", 3), punishSettings.getBoolean("enable-time", true), punishSettings.getInt("time", 60), punishSettings.getBoolean("enable-rejoin", true), punishSettings.getInt("max-rejoins", 3));
    }

    public void loadSecureSettings(FileConfiguration config, FileConfiguration configFile) {
        ConfigurationSection secureSettings = config.getConfigurationSection("secure-settings");
        if (secureSettings == null) {
            this.pluginLogger.warn("Configuration section secure-settings not found!");
            ConfigurationSection section = configFile.createSection("secure-settings");
            section.set("enable-op-whitelist", (Object)false);
            section.set("enable-notadmin-punish", (Object)false);
            section.set("enable-permission-blacklist", (Object)false);
            section.set("enable-ip-whitelist", (Object)false);
            section.set("only-console-usp", (Object)false);
            section.set("enable-excluded-players", (Object)false);
            section.set("use-fake-plugin", (Object)true);
            this.save(this.plugin.getDataFilePath(), configFile, "config.yml", false);
            this.pluginLogger.info("Created section secure-settings");
            secureSettings = section;
        }
        this.secureSettings = new SecureSettings(secureSettings.getBoolean("enable-op-whitelist", false), secureSettings.getBoolean("enable-notadmin-punish", false), secureSettings.getBoolean("enable-permission-blacklist", false), secureSettings.getBoolean("enable-ip-whitelist", false), secureSettings.getBoolean("only-console-usp", false), secureSettings.getBoolean("enable-excluded-players", false), secureSettings.getBoolean("use-fake-plugin", true));
    }

    public void loadApiSettings(FileConfiguration config, FileConfiguration configFile) {
        ConfigurationSection apiSettings = config.getConfigurationSection("api-settings");
        if (apiSettings == null) {
            this.pluginLogger.warn("Configuration section api-settings not found!");
            ConfigurationSection section = configFile.createSection("api-settings");
            section.set("allow-cancel-capture-event", (Object)false);
            section.set("call-event-on-password-enter", (Object)false);
            section.set("allowed-auth-api-calls-packages", List.of());
            this.save(this.plugin.getDataFilePath(), configFile, "config.yml", false);
            this.pluginLogger.info("Created section api-settings");
            apiSettings = section;
        }
        this.apiSettings = new ApiSettings(apiSettings.getBoolean("allow-cancel-capture-event", false), apiSettings.getBoolean("call-event-on-password-enter", false), List.copyOf(apiSettings.getStringList("allowed-auth-api-calls-packages")));
    }

    public void loadMessageSettings(FileConfiguration config, FileConfiguration configFile) {
        ConfigurationSection messageSettings = config.getConfigurationSection("message-settings");
        if (messageSettings == null) {
            this.pluginLogger.warn("Configuration section message-settings not found!");
            ConfigurationSection section = configFile.createSection("message-settings");
            section.set("send-titles", (Object)true);
            section.set("enable-broadcasts", (Object)true);
            section.set("enable-console-broadcasts", (Object)true);
            this.save(this.plugin.getDataFilePath(), configFile, "config.yml", false);
            this.pluginLogger.info("Created section message-settings");
            messageSettings = section;
        }
        this.messageSettings = new MessageSettings(messageSettings.getBoolean("send-titles", true), messageSettings.getBoolean("enable-broadcasts", true), messageSettings.getBoolean("enable-console-broadcasts", true));
    }

    public void loadBossbarSettings(FileConfiguration config, FileConfiguration configFile) {
        ConfigurationSection bossbarSettings = config.getConfigurationSection("bossbar-settings");
        if (bossbarSettings == null) {
            this.pluginLogger.warn("Configuration section bossbar-settings not found!");
            ConfigurationSection section = configFile.createSection("bossbar-settings");
            section.set("enable-bossbar", (Object)false);
            section.set("bar-color", (Object)"RED");
            section.set("bar-style", (Object)"SEGMENTED_12");
            this.save(this.plugin.getDataFilePath(), configFile, "config.yml", false);
            this.pluginLogger.info("Created section bossbar-settings");
            bossbarSettings = section;
        }
        ConfigurationSection bossbar = this.plugin.getMessageFile().getConfigurationSection("bossbar");
        String bossbarMessage = this.getMessage(bossbar, "message");
        this.bossbarSettings = new BossbarSettings(bossbarSettings.getBoolean("enable-bossbar", true), BarColor.valueOf((String)bossbarSettings.getString("bar-color", "RED")), BarStyle.valueOf((String)bossbarSettings.getString("bar-style", "SEGMENTED_12")), bossbarMessage);
    }

    public void loadSoundSettings(FileConfiguration config, FileConfiguration configFile) {
        ConfigurationSection soundSettings = config.getConfigurationSection("sound-settings");
        if (soundSettings == null) {
            this.pluginLogger.warn("Configuration section sound-settings not found!");
            ConfigurationSection section = configFile.createSection("sound-settings");
            section.set("enable-sounds", (Object)false);
            section.set("on-capture", (Object)"ENTITY_ITEM_BREAK;1.0;1.0");
            section.set("on-pas-fail", (Object)"ENTITY_VILLAGER_NO;1.0;1.0");
            section.set("on-pas-correct", (Object)"ENTITY_PLAYER_LEVELUP;1.0;1.0");
            this.save(this.plugin.getDataFilePath(), configFile, "config.yml", false);
            this.pluginLogger.info("Created section sound-settings");
            soundSettings = section;
        }
        this.soundSettings = new SoundSettings(soundSettings.getBoolean("enable-sounds"), soundSettings.getString("on-capture", "ENTITY_ITEM_BREAK;1.0;1.0").split(";"), soundSettings.getString("on-pas-fail", "ENTITY_VILLAGER_NO;1.0;1.0").split(";"), soundSettings.getString("on-pas-correct", "ENTITY_PLAYER_LEVELUP;1.0;1.0").split(";"));
    }

    public void loadEffects(FileConfiguration config, FileConfiguration configFile) {
        ConfigurationSection effectSettings = config.getConfigurationSection("effect-settings");
        if (effectSettings == null) {
            this.pluginLogger.warn("Configuration section effect-settings not found!");
            ConfigurationSection section = configFile.createSection("effect-settings");
            section.set("enable-effects", (Object)true);
            section.set("effects", List.of("BLINDNESS;3"));
            this.save(this.plugin.getDataFilePath(), configFile, "config.yml", false);
            this.pluginLogger.info("Created section effect-settings");
            effectSettings = section;
        }
        List<PotionEffect> effectList = this.getEffectList(effectSettings.getStringList("effects"));
        this.effectSettings = new EffectSettings(effectSettings.getBoolean("enable-effects", true), effectList);
    }

    private List<PotionEffect> getEffectList(List<String> effects) {
        if (effects.isEmpty()) {
            return List.of();
        }
        ArrayList<PotionEffect> effectList = new ArrayList<PotionEffect>(effects.size());
        for (String effect : effects) {
            int level;
            int separatorIndex = effect.indexOf(59);
            String effectName = separatorIndex > 0 ? effect.substring(0, separatorIndex) : effect;
            PotionEffectType type = PotionEffectType.getByName((String)effectName.toUpperCase());
            int n = level = separatorIndex > 0 ? Integer.parseInt(effect.substring(separatorIndex + 1)) - 1 : 0;
            if (type == null) continue;
            effectList.add(new PotionEffect(type, Integer.MAX_VALUE, level));
        }
        return List.copyOf(effectList);
    }

    public void loadLoggingSettings(FileConfiguration config, FileConfiguration configFile) {
        ConfigurationSection loggingSettings = config.getConfigurationSection("logging-settings");
        if (loggingSettings == null) {
            this.pluginLogger.warn("Configuration section logging-settings not found!");
            ConfigurationSection section = configFile.createSection("logging-settings");
            section.set("logging-pas", (Object)true);
            section.set("logging-join", (Object)true);
            section.set("logging-enable-disable", (Object)true);
            section.set("logging-command-execution", (Object)true);
            this.save(this.plugin.getDataFilePath(), configFile, "config.yml", false);
            this.pluginLogger.info("Created section logging-settings");
            loggingSettings = section;
        }
        this.loggingSettings = new LoggingSettings(loggingSettings.getBoolean("logging-pas", true), loggingSettings.getBoolean("logging-join", true), loggingSettings.getBoolean("logging-enable-disable", true), loggingSettings.getBoolean("logging-command-execution", true));
    }

    public void loadFailCommands(FileConfiguration config, FileConfiguration configFile) {
        ConfigurationSection commands = config.getConfigurationSection("commands");
        if (commands == null) {
            this.pluginLogger.warn("Configuration section commands not found!");
            ConfigurationSection section = configFile.createSection("commands");
            section.set("not-in-config", List.of());
            section.set("not-in-opwhitelist", List.of());
            section.set("have-blacklisted-perm", List.of());
            section.set("not-admin-ip", List.of());
            section.set("failed-pass", List.of());
            section.set("failed-time", List.of());
            section.set("failed-rejoin", List.of());
            this.save(this.plugin.getDataFilePath(), configFile, "config.yml", false);
            this.pluginLogger.info("Created section main-settings");
            commands = section;
        }
        this.commands = new Commands(List.copyOf(commands.getStringList("not-in-config")), List.copyOf(commands.getStringList("not-in-opwhitelist")), List.copyOf(commands.getStringList("have-blacklisted-perm")), List.copyOf(commands.getStringList("not-admin-ip")), List.copyOf(commands.getStringList("failed-pass")), List.copyOf(commands.getStringList("failed-time")), List.copyOf(commands.getStringList("failed-rejoin")));
    }

    public void loadAccessData(FileConfiguration config) {
        Set<String> perms = Set.copyOf(config.getStringList("permissions"));
        List<String> allowedCommands = List.copyOf(config.getStringList("allowed-commands"));
        ConfigurationSection secureSettings = config.getConfigurationSection("secure-settings");
        List<String> opWhitelist = List.of();
        Set<String> blacklistedPerms = Set.of();
        Map<String, List<String>> ipWhitelist = Map.of();
        if (secureSettings.getBoolean("enable-op-whitelist")) {
            opWhitelist = List.copyOf(config.getStringList("op-whitelist"));
        }
        if (secureSettings.getBoolean("enable-permission-blacklist")) {
            blacklistedPerms = Set.copyOf(config.getStringList("blacklisted-perms"));
        }
        if (secureSettings.getBoolean("enable-ip-whitelist")) {
            ConfigurationSection ipwlSection = config.getConfigurationSection("ip-whitelist");
            Set keys = ipwlSection.getKeys(false);
            HashMap ipWhitelistTemp = new HashMap(keys.size());
            for (String ipwlPlayer : keys) {
                List ips = List.copyOf(ipwlSection.getStringList(ipwlPlayer));
                ipWhitelistTemp.put(ipwlPlayer, ips);
            }
            ipWhitelist = Map.copyOf(ipWhitelistTemp);
        }
        this.accessData = new AccessData(perms, allowedCommands, opWhitelist, blacklistedPerms, ipWhitelist);
    }

    public void setupExcluded(FileConfiguration config) {
        ConfigurationSection excludedPlayers = config.getConfigurationSection("excluded-players");
        this.excludedPlayers = new ExcludedPlayers(List.copyOf(excludedPlayers.getStringList("admin-pass")), List.copyOf(excludedPlayers.getStringList("op-whitelist")), List.copyOf(excludedPlayers.getStringList("ip-whitelist")), List.copyOf(excludedPlayers.getStringList("blacklisted-perms")), List.copyOf(excludedPlayers.getStringList("alert")));
    }

    public void loadUspMessages(FileConfiguration message) {
        ConfigurationSection uspmsg = message.getConfigurationSection("uspmsg");
        this.uspMessages = new UspMessages(this.getMessage(uspmsg, "consoleonly"), this.getMessage(uspmsg, "reloaded"), this.getMessage(uspmsg, "rebooted"), this.getMessage(uspmsg, "playernotfound"), this.getMessage(uspmsg, "alreadyinconfig"), this.getMessage(uspmsg, "playeronly"), this.getMessage(uspmsg, "logout"), this.getMessage(uspmsg, "notinconfig"), this.getMessage(uspmsg, "playeradded"), this.getMessage(uspmsg, "playerremoved"), this.getMessage(uspmsg, "ipadded"), this.getMessage(uspmsg, "setpassusage"), this.getMessage(uspmsg, "addopusage"), this.getMessage(uspmsg, "remopusage"), this.getMessage(uspmsg, "ipremoved"), this.getMessage(uspmsg, "remipusage"), this.getMessage(uspmsg, "addipusage"), this.getMessage(uspmsg, "rempassusage"), this.getMessage(uspmsg, "usage"), this.getMessage(uspmsg, "usage-logout"), this.getMessage(uspmsg, "usage-reload"), this.getMessage(uspmsg, "usage-reboot"), this.getMessage(uspmsg, "usage-encrypt"), this.getMessage(uspmsg, "usage-setpass"), this.getMessage(uspmsg, "usage-rempass"), this.getMessage(uspmsg, "usage-addop"), this.getMessage(uspmsg, "usage-remop"), this.getMessage(uspmsg, "usage-addip"), this.getMessage(uspmsg, "usage-remip"), this.getMessage(uspmsg, "otherdisabled"));
    }

    public void loadMsgMessages(FileConfiguration message) {
        ConfigurationSection msg = message.getConfigurationSection("msg");
        this.messages = new Messages(this.getMessage(msg, "message"), this.getMessage(msg, "incorrect"), this.getMessage(msg, "correct"), this.getMessage(msg, "noneed"), this.getMessage(msg, "cantbenull"), this.getMessage(msg, "playeronly"));
    }

    public void loadTitleMessages(FileConfiguration message) {
        ConfigurationSection titles = message.getConfigurationSection("titles");
        this.titles = new Titles(this.getMessage(titles, "message").split(";"), this.getMessage(titles, "incorrect").split(";"), this.getMessage(titles, "correct").split(";"));
    }

    public void loadBroadcastMessages(FileConfiguration message) {
        ConfigurationSection broadcasts = message.getConfigurationSection("broadcasts");
        this.broadcasts = new Broadcasts(this.getMessage(broadcasts, "failed"), this.getMessage(broadcasts, "passed"), this.getMessage(broadcasts, "joined"), this.getMessage(broadcasts, "captured"), this.getMessage(broadcasts, "disabled"));
    }

    public void loadLogFormats(FileConfiguration message) {
        ConfigurationSection logMessages = message.getConfigurationSection("log-format");
        this.logMessages = new LogMessages(this.getMessage(logMessages, "enabled"), this.getMessage(logMessages, "disabled"), this.getMessage(logMessages, "failed"), this.getMessage(logMessages, "passed"), this.getMessage(logMessages, "joined"), this.getMessage(logMessages, "captured"), this.getMessage(logMessages, "command"));
    }

    public void loadSystemMessages(FileConfiguration message) {
        ConfigurationSection system = message.getConfigurationSection("system");
        this.systemMessages = new SystemMessages(this.getMessage(system, "baseline-warn"), this.getMessage(system, "baseline-default"), this.getMessage(system, "paper-1"), this.getMessage(system, "paper-2"), this.getMessage(system, "bungeecord-1"), this.getMessage(system, "bungeecord-2"), this.getMessage(system, "bungeecord-3"), this.getMessage(system, "update-latest"), this.getMessage(system, "update-success-1"), this.getMessage(system, "update-success-2"), this.getMessage(system, "update-outdated-1"), this.getMessage(system, "update-outdated-2"), this.getMessage(system, "update-outdated-3"));
    }

    public String getMessage(ConfigurationSection section, String key) {
        if (section == null) {
            return Utils.COLORIZER.colorize("&4&lERROR&r: " + key + " does not exist!");
        }
        return Utils.COLORIZER.colorize(section.getString(key, "&4&lERROR&r: " + key + " does not exist!").replace("%prefix%", this.mainSettings.prefix()));
    }

    public FileConfiguration getFile(String path, String fileName) {
        File file = new File(path, fileName);
        if (!file.exists()) {
            this.plugin.saveResource(fileName, false);
        }
        return YamlConfiguration.loadConfiguration((File)file);
    }

    public void save(String path, FileConfiguration config, String fileName, boolean async) {
        Runnable runnable = () -> {
            try {
                config.save(new File(path, fileName));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        };
        if (async) {
            this.plugin.getRunner().runAsync(runnable);
            return;
        }
        runnable.run();
    }

    @Generated
    public Map<String, String> getPerPlayerPasswords() {
        return this.perPlayerPasswords;
    }

    @Generated
    public MainSettings getMainSettings() {
        return this.mainSettings;
    }

    @Generated
    public EncryptionSettings getEncryptionSettings() {
        return this.encryptionSettings;
    }

    @Generated
    public GeyserSettings getGeyserSettings() {
        return this.geyserSettings;
    }

    @Generated
    public BlockingSettings getBlockingSettings() {
        return this.blockingSettings;
    }

    @Generated
    public SessionSettings getSessionSettings() {
        return this.sessionSettings;
    }

    @Generated
    public PunishSettings getPunishSettings() {
        return this.punishSettings;
    }

    @Generated
    public SecureSettings getSecureSettings() {
        return this.secureSettings;
    }

    @Generated
    public ApiSettings getApiSettings() {
        return this.apiSettings;
    }

    @Generated
    public MessageSettings getMessageSettings() {
        return this.messageSettings;
    }

    @Generated
    public BossbarSettings getBossbarSettings() {
        return this.bossbarSettings;
    }

    @Generated
    public SoundSettings getSoundSettings() {
        return this.soundSettings;
    }

    @Generated
    public EffectSettings getEffectSettings() {
        return this.effectSettings;
    }

    @Generated
    public LoggingSettings getLoggingSettings() {
        return this.loggingSettings;
    }

    @Generated
    public Commands getCommands() {
        return this.commands;
    }

    @Generated
    public AccessData getAccessData() {
        return this.accessData;
    }

    @Generated
    public ExcludedPlayers getExcludedPlayers() {
        return this.excludedPlayers;
    }

    @Generated
    public UspMessages getUspMessages() {
        return this.uspMessages;
    }

    @Generated
    public Messages getMessages() {
        return this.messages;
    }

    @Generated
    public Titles getTitles() {
        return this.titles;
    }

    @Generated
    public Broadcasts getBroadcasts() {
        return this.broadcasts;
    }

    @Generated
    public LogMessages getLogMessages() {
        return this.logMessages;
    }

    @Generated
    public SystemMessages getSystemMessages() {
        return this.systemMessages;
    }
}

