/*
 * Decompiled with CFR 0.152.
 */
package ru.overwrite.protect.bukkit.listeners;

import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import ru.overwrite.protect.bukkit.PasswordHandler;
import ru.overwrite.protect.bukkit.ServerProtectorManager;
import ru.overwrite.protect.bukkit.api.ServerProtectorAPI;
import ru.overwrite.protect.bukkit.configuration.Config;

public class ChatListener
implements Listener {
    private final ServerProtectorManager plugin;
    private final ServerProtectorAPI api;
    private final PasswordHandler passwordHandler;
    private final Config pluginConfig;

    public ChatListener(ServerProtectorManager plugin) {
        this.plugin = plugin;
        this.pluginConfig = plugin.getPluginConfig();
        this.passwordHandler = plugin.getPasswordHandler();
        this.api = plugin.getApi();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onChat(AsyncPlayerChatEvent e) {
        Player player = e.getPlayer();
        if (!this.api.isCaptured(player)) {
            return;
        }
        if (!this.pluginConfig.getMainSettings().useCommand()) {
            String message = e.getMessage();
            this.passwordHandler.checkPassword(player, message, true);
        }
        e.setMessage("");
        e.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onCommand(PlayerCommandPreprocessEvent e) {
        Player player = e.getPlayer();
        if (!this.api.isCaptured(player)) {
            return;
        }
        String message = e.getMessage();
        String label = this.cutCommand(message);
        if (this.pluginConfig.getMainSettings().useCommand() && label.equalsIgnoreCase("/" + this.pluginConfig.getMainSettings().pasCommand())) {
            if (!this.plugin.isPaper()) {
                this.passwordHandler.checkPassword(player, this.cutArguments(message), false);
                e.setCancelled(true);
            }
            return;
        }
        List<String> allowedCommands = this.pluginConfig.getAccessData().allowedCommands();
        for (int i = 0; i < allowedCommands.size(); ++i) {
            String command = allowedCommands.get(i);
            if (!label.equalsIgnoreCase(command) && !message.equalsIgnoreCase(command)) continue;
            return;
        }
        e.setCancelled(true);
    }

    private String cutCommand(String str) {
        int index = str.indexOf(32);
        return index == -1 ? str : str.substring(0, index);
    }

    private String cutArguments(String str) {
        int index = str.indexOf(32);
        return index == -1 ? str : str.substring(index + 1);
    }
}

