/*
 * Decompiled with CFR 0.152.
 */
package ru.overwrite.protect.bukkit.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import ru.overwrite.protect.bukkit.ServerProtectorManager;
import ru.overwrite.protect.bukkit.utils.color.Colorizer;
import ru.overwrite.protect.bukkit.utils.color.impl.LegacyAdvancedColorizer;
import ru.overwrite.protect.bukkit.utils.color.impl.LegacyColorizer;
import ru.overwrite.protect.bukkit.utils.color.impl.MiniMessageColorizer;
import ru.overwrite.protect.bukkit.utils.color.impl.VanillaColorizer;

public final class Utils {
    public static final int SUB_VERSION;
    public static final boolean FOLIA;
    public static Colorizer COLORIZER;
    public static final char COLOR_CHAR = '\u00a7';
    private static final Set<String> SUPPORTED_HASH_TYPES;
    private static final SecureRandom random;
    private static final char[] CHARS;

    public static void setupColorizer(ConfigurationSection mainSettings) {
        COLORIZER = switch (mainSettings.getString("serializer", "LEGACY").toUpperCase()) {
            case "MINIMESSAGE" -> new MiniMessageColorizer();
            case "LEGACY" -> {
                if (SUB_VERSION >= 16) {
                    yield new LegacyColorizer();
                }
                yield new VanillaColorizer();
            }
            case "LEGACY_ADVANCED" -> new LegacyAdvancedColorizer();
            default -> new VanillaColorizer();
        };
    }

    public static String getIp(Player player) {
        return player.getAddress().getAddress().getHostAddress();
    }

    public static void sendTitleMessage(String[] titleMessages, Player player) {
        if (titleMessages[0].isEmpty()) {
            return;
        }
        if (titleMessages.length > 5) {
            Bukkit.getConsoleSender().sendMessage("Unable to send title. " + Arrays.toString(titleMessages));
            return;
        }
        String title = titleMessages[0];
        String subtitle = titleMessages.length >= 2 ? titleMessages[1] : "";
        int fadeIn = titleMessages.length >= 3 ? Integer.parseInt(titleMessages[2]) : 10;
        int stay = titleMessages.length >= 4 ? Integer.parseInt(titleMessages[3]) : 70;
        int fadeOut = titleMessages.length == 5 ? Integer.parseInt(titleMessages[4]) : 20;
        player.sendTitle(title, subtitle, fadeIn, stay, fadeOut);
    }

    public static void sendSound(String[] soundArgs, Player player) {
        if (soundArgs[0].isEmpty()) {
            return;
        }
        if (soundArgs.length > 3) {
            Bukkit.getConsoleSender().sendMessage("Unable to send sound. " + Arrays.toString(soundArgs));
            return;
        }
        Sound sound = Sound.valueOf((String)soundArgs[0]);
        float volume = soundArgs.length >= 2 ? Float.parseFloat(soundArgs[1]) : 1.0f;
        float pitch = soundArgs.length == 3 ? Float.parseFloat(soundArgs[2]) : 1.0f;
        player.playSound(player.getLocation(), sound, volume, pitch);
    }

    public static String translateAlternateColorCodes(char altColorChar, String textToTranslate) {
        char[] b = textToTranslate.toCharArray();
        int length = b.length - 1;
        for (int i = 0; i < length; ++i) {
            if (b[i] != altColorChar || !Utils.isValidColorCharacter(b[i + 1])) continue;
            b[i++] = 167;
            int n = i;
            b[n] = (char)(b[n] | 0x20);
        }
        return new String(b);
    }

    private static boolean isValidColorCharacter(char c) {
        return switch (c) {
            case '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'K', 'L', 'M', 'N', 'O', 'R', 'X', 'a', 'b', 'c', 'd', 'e', 'f', 'k', 'l', 'm', 'n', 'o', 'r', 'x' -> true;
            default -> false;
        };
    }

    public static void checkUpdates(ServerProtectorManager plugin, Consumer<String> consumer) {
        plugin.getRunner().runDelayedAsync(() -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(new URL("https://raw.githubusercontent.com/Overwrite987/UltimateServerProtector/master/VERSION").openStream()));){
                consumer.accept(reader.readLine().trim());
            }
            catch (IOException ex) {
                plugin.getPluginLogger().warn("Unable to check for updates: " + ex.getMessage());
            }
        }, 10L);
    }

    public static String encryptPassword(String password, String salt, List<String> hashTypes) {
        if (hashTypes.isEmpty()) {
            return password;
        }
        Object encryptedPassword = password;
        boolean salted = false;
        Iterator<String> iterator = hashTypes.iterator();
        while (iterator.hasNext()) {
            String hashType;
            switch (hashType = iterator.next()) {
                case "BASE64": {
                    encryptedPassword = Utils.encodeToBase64((String)encryptedPassword);
                    break;
                }
                case "SALT": {
                    if (salted) break;
                    encryptedPassword = salt + (String)encryptedPassword;
                    salted = true;
                    break;
                }
                default: {
                    if (SUPPORTED_HASH_TYPES.contains(hashType)) {
                        encryptedPassword = Utils.encryptToHash((String)encryptedPassword, hashType);
                        break;
                    }
                    throw new IllegalArgumentException("Unsupported hash type: " + hashType);
                }
            }
        }
        return salted ? salt + ":" + (String)encryptedPassword : encryptedPassword;
    }

    public static String generateSalt(int length) {
        byte[] saltBytes = new byte[(int)Math.ceil((double)length * 3.0 / 4.0)];
        random.nextBytes(saltBytes);
        return Base64.getEncoder().encodeToString(saltBytes);
    }

    public static String generatePassword(int length) {
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            sb.append(CHARS[random.nextInt(CHARS.length)]);
        }
        return sb.toString();
    }

    private static String encodeToBase64(String str) {
        return Base64.getEncoder().encodeToString(str.getBytes(StandardCharsets.UTF_8));
    }

    private static String encryptToHash(String str, String algorithm) {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            byte[] hash = digest.digest(str.getBytes(StandardCharsets.UTF_8));
            return Utils.bytesToHexString(hash);
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace();
            return str;
        }
    }

    private static String bytesToHexString(byte[] bytes) {
        StringBuilder hexString = new StringBuilder();
        for (byte b : bytes) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    @Generated
    private Utils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        boolean folia;
        SUB_VERSION = Integer.parseInt(Bukkit.getBukkitVersion().split("-")[0].split("\\.")[1]);
        try {
            Class.forName("io.papermc.paper.threadedregions.scheduler.AsyncScheduler");
            folia = true;
        }
        catch (ClassNotFoundException e) {
            folia = false;
        }
        FOLIA = folia;
        SUPPORTED_HASH_TYPES = Set.of("SHA224", "SHA256", "SHA384", "SHA512", "SHA-224", "SHA-256", "SHA-384", "SHA-512", "SHA3-224", "SHA3-256", "SHA3-384", "SHA3-512");
        random = new SecureRandom();
        CHARS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0'};
    }
}

