/*
 * Decompiled with CFR 0.152.
 */
package ru.overwrite.protect.bukkit.utils.color.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.overwrite.protect.bukkit.utils.Utils;
import ru.overwrite.protect.bukkit.utils.color.Colorizer;

public class LegacyColorizer
implements Colorizer {
    private static final Pattern HEX_PATTERN = Pattern.compile("&#([a-fA-F\\d]{6})");

    @Override
    public String colorize(String message) {
        if (message == null || message.isEmpty()) {
            return message;
        }
        Matcher matcher = HEX_PATTERN.matcher(message);
        StringBuilder builder = new StringBuilder(message.length() + 32);
        while (matcher.find()) {
            char[] group = matcher.group(1).toCharArray();
            matcher.appendReplacement(builder, "\u00a7x\u00a7" + group[0] + "\u00a7" + group[1] + "\u00a7" + group[2] + "\u00a7" + group[3] + "\u00a7" + group[4] + "\u00a7" + group[5]);
        }
        message = matcher.appendTail(builder).toString();
        return Utils.translateAlternateColorCodes('&', message);
    }
}

