/*
 * Decompiled with CFR 0.152.
 */
package me.enzonic.calculator;

import java.util.Locale;
import me.enzonic.calculator.EnzonicCalculator;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public final class CalculateCommand
implements CommandExecutor {
    private final EnzonicCalculator plugin;
    private int pos = -1;
    private int ch;
    private String s;

    public CalculateCommand(EnzonicCalculator plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /calculate <expression>");
            return true;
        }
        String expr = String.join((CharSequence)" ", args).toLowerCase(Locale.ROOT);
        try {
            double result = this.evaluate(expr);
            if (Double.isNaN(result) || Double.isInfinite(result)) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid expression or undefined result.");
            } else {
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Result: " + result);
            }
        }
        catch (Exception ex) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Error: " + ex.getMessage());
        }
        return true;
    }

    private double evaluate(String expr) {
        this.s = expr.replace("pi", Double.toString(Math.PI)).replace("e", Double.toString(Math.E));
        this.pos = -1;
        this.nextChar();
        double v = this.parseExpression();
        if (this.pos < this.s.length()) {
            throw new RuntimeException("Unexpected: " + (char)this.ch);
        }
        return v;
    }

    private void nextChar() {
        this.ch = ++this.pos < this.s.length() ? (int)this.s.charAt(this.pos) : -1;
    }

    private boolean eat(int charToEat) {
        while (this.ch == 32) {
            this.nextChar();
        }
        if (this.ch == charToEat) {
            this.nextChar();
            return true;
        }
        return false;
    }

    private double parseExpression() {
        double x = this.parseTerm();
        while (true) {
            if (this.eat(43)) {
                x += this.parseTerm();
                continue;
            }
            if (!this.eat(45)) break;
            x -= this.parseTerm();
        }
        return x;
    }

    private double parseTerm() {
        double x = this.parseFactor();
        while (true) {
            if (this.eat(42)) {
                x *= this.parseFactor();
                continue;
            }
            if (this.eat(47)) {
                x /= this.parseFactor();
                continue;
            }
            if (!this.eat(37)) break;
            x %= this.parseFactor();
        }
        return x;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private double parseFactor() {
        double x;
        if (this.eat(43)) {
            return this.parseFactor();
        }
        if (this.eat(45)) {
            return -this.parseFactor();
        }
        int startPos = this.pos;
        if (this.eat(40)) {
            x = this.parseExpression();
            this.eat(41);
        } else if (this.ch >= 48 && this.ch <= 57 || this.ch == 46) {
            while (this.ch >= 48 && this.ch <= 57 || this.ch == 46) {
                this.nextChar();
            }
            x = Double.parseDouble(this.s.substring(startPos, this.pos));
        } else {
            if (this.ch < 97) throw new RuntimeException("Unexpected: " + (char)this.ch);
            if (this.ch > 122) throw new RuntimeException("Unexpected: " + (char)this.ch);
            while (this.ch >= 97 && this.ch <= 122) {
                this.nextChar();
            }
            String func = this.s.substring(startPos, this.pos);
            if (!this.eat(40)) throw new RuntimeException("Expected '(' after " + func);
            x = this.parseExpression();
            this.eat(41);
            switch (func) {
                case "sqrt": {
                    x = Math.sqrt(x);
                    break;
                }
                case "sin": {
                    x = Math.sin(Math.toRadians(x));
                    break;
                }
                case "cos": {
                    x = Math.cos(Math.toRadians(x));
                    break;
                }
                case "tan": {
                    x = Math.tan(Math.toRadians(x));
                    break;
                }
                case "log": {
                    x = Math.log10(x);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown function: " + func);
                }
            }
        }
        if (!this.eat(94)) return x;
        return Math.pow(x, this.parseFactor());
    }
}

