/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.realmobsize.configuration;

import io.github._4drian3d.realmobsize.RealMobSize;
import io.github._4drian3d.realmobsize.configuration.Configuration;
import io.github._4drian3d.realmobsize.configuration.SizeMapSerializer;
import io.leangen.geantyref.TypeToken;
import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.bukkit.entity.EntityType;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.serialize.TypeSerializer;
import org.spongepowered.configurate.yaml.NodeStyle;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

public record ConfigurationLoader(AtomicReference<Configuration> configuration, YamlConfigurationLoader loader) {
    private static final String FILE_NAME = "realmobsize.yml";

    public static ConfigurationLoader load(Path folderPath, RealMobSize plugin) throws IOException {
        Path configPath;
        if (!Files.exists(folderPath, new LinkOption[0])) {
            Files.createDirectory(folderPath, new FileAttribute[0]);
        }
        if (!Files.exists(configPath = folderPath.resolve(FILE_NAME), new LinkOption[0])) {
            try (InputStream internalConfig = plugin.getResource(FILE_NAME);){
                Files.copy(Objects.requireNonNull(internalConfig, "Plugin Configuration"), configPath, new CopyOption[0]);
            }
        }
        YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(configPath)).defaultOptions(options -> options.serializers(builder -> builder.register((TypeToken)new TypeToken<Object2DoubleArrayMap<EntityType>>(){}, (TypeSerializer)SizeMapSerializer.INSTANCE)))).nodeStyle(NodeStyle.BLOCK).build();
        CommentedConfigurationNode node = (CommentedConfigurationNode)loader.load();
        Configuration config = (Configuration)node.get(Configuration.class);
        return new ConfigurationLoader(new AtomicReference<Configuration>(config), loader);
    }

    public Configuration instance() {
        return this.configuration.get();
    }

    public CompletableFuture<Configuration> reload() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                CommentedConfigurationNode node = (CommentedConfigurationNode)this.loader.load();
                Configuration newConfiguration = (Configuration)node.get(Configuration.class);
                this.configuration.set(newConfiguration);
                return newConfiguration;
            }
            catch (ConfigurateException exception) {
                throw new UncheckedIOException((IOException)((Object)exception));
            }
        });
    }
}

