/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.realmobsize.configuration;

import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import org.bukkit.entity.EntityType;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

@NullMarked
public enum SizeMapSerializer implements TypeSerializer<Object2DoubleArrayMap<EntityType>>
{
    INSTANCE;


    public Object2DoubleArrayMap<EntityType> deserialize(Type type, ConfigurationNode node) throws SerializationException {
        Map childrenMap = node.childrenMap();
        Object2DoubleArrayMap sizeMap = new Object2DoubleArrayMap(childrenMap.size());
        for (Map.Entry childrenNode : childrenMap.entrySet()) {
            EntityType entityType = EntityType.fromName((String)Objects.requireNonNull(childrenNode.getKey(), "Children Key").toString());
            if (entityType == null) {
                throw new SerializationException("Invalid Entity Type");
            }
            if (!entityType.isAlive() || !entityType.isSpawnable()) {
                throw new SerializationException("Invalid Entity Type provided. Must be a valid Mob EntityType type, provided: " + String.valueOf(entityType));
            }
            double size = ((ConfigurationNode)childrenNode.getValue()).getDouble();
            sizeMap.put((Object)entityType, size);
        }
        return sizeMap;
    }

    public void serialize(Type type, @Nullable Object2DoubleArrayMap<EntityType> obj, ConfigurationNode node) throws SerializationException {
        if (obj == null) {
            node.raw(null);
            return;
        }
        for (Object2DoubleMap.Entry sizeEntry : obj.object2DoubleEntrySet()) {
            node.node(new Object[]{((EntityType)sizeEntry.getKey()).name()}).set((Object)sizeEntry.getDoubleValue());
        }
    }
}

