/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.realmobsize.listener;

import io.github._4drian3d.realmobsize.RealMobSize;
import java.util.Objects;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public record EntitySpawnListener(RealMobSize plugin) implements EventExecutor,
Listener
{
    public void execute(@NotNull Listener listener, @NotNull Event event) {
        Mob mob;
        block8: {
            block7: {
                if (!(event instanceof CreatureSpawnEvent)) {
                    return;
                }
                CreatureSpawnEvent spawnEvent = (CreatureSpawnEvent)event;
                LivingEntity livingEntity = spawnEvent.getEntity();
                if (!(livingEntity instanceof Mob)) break block7;
                mob = (Mob)livingEntity;
                if (!spawnEvent.isCancelled()) break block8;
            }
            return;
        }
        AttributeInstance attributeInstance = mob.getAttribute(Attribute.SCALE);
        if (attributeInstance == null) {
            mob.registerAttribute(Attribute.SCALE);
            attributeInstance = mob.getAttribute(Attribute.SCALE);
        }
        Objects.requireNonNull(attributeInstance, "Attribute instance");
        if (attributeInstance.getBaseValue() != 1.0) {
            return;
        }
        double sizeToApply = this.plugin.configLoader().instance().sizeMap().getDouble((Object)mob.getType());
        if (sizeToApply <= 0.0) {
            return;
        }
        attributeInstance.setBaseValue(sizeToApply);
    }

    public static void register(RealMobSize plugin) {
        EntitySpawnListener listener = new EntitySpawnListener(plugin);
        plugin.getServer().getPluginManager().registerEvent(CreatureSpawnEvent.class, (Listener)listener, EventPriority.NORMAL, (EventExecutor)listener, (Plugin)plugin);
    }
}

