/*
 * Decompiled with CFR 0.152.
 */
package com.nosferk.cloudflaredtunnel;

import com.nosferk.cloudflaredtunnel.config.ModConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.ModInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudflaredTunnel
implements ModInitializer {
    public static final String MOD_ID = "cloudflared-tunnel";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"cloudflared-tunnel");
    private static int tunnelPort = -1;
    private static Process currentProcess = null;
    private static final List<String> outputLog = new ArrayList<String>();

    public void onInitialize() {
        LOGGER.info("Iniciando CloudflaredTunnel...");
        CloudflaredTunnel.startTunnel();
    }

    public static void startTunnel() {
        int port;
        ModConfig config = ModConfig.getInstance();
        tunnelPort = port = config.getPort();
        try {
            CloudflaredTunnel.stopTunnel();
            CloudflaredTunnel.startCloudflared(port, config.hostname);
        }
        catch (IOException e) {
            LOGGER.error("Erro ao iniciar cloudflared", (Throwable)e);
            CloudflaredTunnel.addToLog("ERRO: " + e.getMessage());
        }
        LOGGER.info("CloudflaredTunnel iniciado na porta {} com hostname {}", (Object)port, (Object)config.hostname);
        CloudflaredTunnel.addToLog("Tunnel iniciado na porta " + port + " com hostname " + config.hostname);
    }

    public static void stopTunnel() {
        if (currentProcess != null && currentProcess.isAlive()) {
            LOGGER.info("Parando tunnel anterior...");
            CloudflaredTunnel.addToLog("Parando tunnel anterior...");
            currentProcess.destroyForcibly();
            try {
                currentProcess.waitFor();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            currentProcess = null;
        }
    }

    public static int getTunnelPort() {
        return tunnelPort;
    }

    public static List<String> getOutputLog() {
        return new ArrayList<String>(outputLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addToLog(String message) {
        List<String> list = outputLog;
        synchronized (list) {
            outputLog.add("[" + LocalTime.now().toString() + "] " + message);
            if (outputLog.size() > 100) {
                outputLog.remove(0);
            }
        }
    }

    private static void startCloudflared(int port, String hostname) throws IOException {
        File exe = CloudflaredTunnel.getCloudflaredExecutable();
        if (exe == null) {
            LOGGER.error("N\u00e3o foi poss\u00edvel obter o cloudflared.exe");
            CloudflaredTunnel.addToLog("ERRO: N\u00e3o foi poss\u00edvel obter o cloudflared.exe");
            return;
        }
        LOGGER.info("Executando cloudflared na porta {} com hostname {}", (Object)port, (Object)hostname);
        CloudflaredTunnel.addToLog("Executando cloudflared na porta " + port + " com hostname " + hostname);
        ProcessBuilder builder = new ProcessBuilder(exe.getAbsolutePath(), "access", "tcp", "--hostname", hostname, "--url", "127.0.0.1:" + port);
        builder.redirectErrorStream(true);
        currentProcess = builder.start();
        new Thread(() -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(currentProcess.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    CloudflaredTunnel.addToLog(line);
                }
            }
            catch (IOException e) {
                CloudflaredTunnel.addToLog("Erro ao ler sa\u00edda: " + e.getMessage());
            }
        }).start();
    }

    private static File getCloudflaredExecutable() {
        File dataDir = new File("data");
        File exeInData = new File(dataDir, "cloudflared.exe");
        if (exeInData.exists()) {
            LOGGER.info("Usando cloudflared.exe existente em ./data/");
            return exeInData;
        }
        try {
            InputStream resourceStream;
            if (!dataDir.exists()) {
                dataDir.mkdirs();
            }
            if ((resourceStream = CloudflaredTunnel.class.getResourceAsStream("/cloudflared.exe")) == null) {
                LOGGER.error("cloudflared.exe n\u00e3o encontrado no JAR. Coloque o arquivo em src/main/resources/");
                return null;
            }
            LOGGER.info("Extraindo cloudflared.exe do JAR para ./data/");
            Path targetPath = Paths.get(exeInData.getAbsolutePath(), new String[0]);
            Files.copy(resourceStream, targetPath, StandardCopyOption.REPLACE_EXISTING);
            resourceStream.close();
            exeInData.setExecutable(true);
            LOGGER.info("cloudflared.exe extra\u00eddo com sucesso para ./data/");
            return exeInData;
        }
        catch (IOException e) {
            LOGGER.error("Erro ao extrair cloudflared.exe do JAR", (Throwable)e);
            return null;
        }
    }
}

