/*
 * Decompiled with CFR 0.152.
 */
package com.nosferk.cloudflaredtunnel.client.gui;

import com.nosferk.cloudflaredtunnel.CloudflaredTunnel;
import com.nosferk.cloudflaredtunnel.config.ModConfig;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class ConfigScreen
extends class_437 {
    private final class_437 parent;
    private final ModConfig config;
    private class_342 hostnameField;
    private class_342 fixedPortField;
    private class_342 serverNameField;
    private class_4286 useRandomPortCheckbox;
    private class_4286 autoAddServerCheckbox;
    private boolean showOutputTab = false;
    private int outputScrollOffset = 0;

    public ConfigScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"cloudflared-tunnel.config.title"));
        this.parent = parent;
        this.config = ModConfig.getInstance();
    }

    protected void method_25426() {
        int centerX = this.field_22789 / 2;
        int startY = 50;
        int spacing = 25;
        int fieldWidth = 200;
        if (this.showOutputTab) {
            this.renderOutputTab();
        } else {
            this.renderConfigTab(centerX, startY, spacing, fieldWidth);
        }
    }

    private void renderConfigTab(int centerX, int startY, int spacing, int fieldWidth) {
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Hostname:"), button -> {}).method_46434(centerX - fieldWidth / 2 - 70, startY, 60, 20).method_46431());
        this.hostnameField = new class_342(this.field_22793, centerX - fieldWidth / 2, startY, fieldWidth, 20, (class_2561)class_2561.method_43470((String)""));
        this.hostnameField.method_1852(this.config.hostname);
        this.method_25429((class_364)this.hostnameField);
        this.method_37063((class_364)this.hostnameField);
        this.useRandomPortCheckbox = class_4286.method_54787((class_2561)class_2561.method_43470((String)"Usar porta aleat\u00f3ria"), (class_327)this.field_22793).method_54789(centerX - fieldWidth / 2, startY += spacing).method_54794(this.config.useRandomPort).method_54788();
        this.method_37063((class_364)this.useRandomPortCheckbox);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Porta fixa:"), button -> {}).method_46434(centerX - fieldWidth / 2 - 80, startY += spacing, 70, 20).method_46431());
        this.fixedPortField = new class_342(this.field_22793, centerX - fieldWidth / 2, startY, fieldWidth, 20, (class_2561)class_2561.method_43470((String)""));
        this.fixedPortField.method_1852(String.valueOf(this.config.fixedPort));
        this.fixedPortField.method_1888(!this.config.useRandomPort);
        this.method_25429((class_364)this.fixedPortField);
        this.method_37063((class_364)this.fixedPortField);
        this.autoAddServerCheckbox = class_4286.method_54787((class_2561)class_2561.method_43470((String)"Adicionar servidor automaticamente"), (class_327)this.field_22793).method_54789(centerX - fieldWidth / 2, startY += spacing).method_54794(this.config.autoAddToServerList).method_54788();
        this.method_37063((class_364)this.autoAddServerCheckbox);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Nome do servidor:"), button -> {}).method_46434(centerX - fieldWidth / 2 - 110, startY += spacing, 100, 20).method_46431());
        this.serverNameField = new class_342(this.field_22793, centerX - fieldWidth / 2, startY, fieldWidth, 20, (class_2561)class_2561.method_43470((String)""));
        this.serverNameField.method_1852(this.config.serverName);
        this.serverNameField.method_1888(this.config.autoAddToServerList);
        this.method_25429((class_364)this.serverNameField);
        this.method_37063((class_364)this.serverNameField);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Salvar"), button -> this.save()).method_46434(centerX - 150, startY += spacing * 2, 70, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Recarregar Tunnel"), button -> this.reloadTunnel()).method_46434(centerX - 75, startY, 120, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancelar"), button -> this.method_25419()).method_46434(centerX + 50, startY, 70, 20).method_46431());
    }

    private void renderOutputTab() {
        int centerX = this.field_22789 / 2;
        int startY = 50;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Atualizar"), button -> {}).method_46434(centerX - 50, startY, 100, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2191"), button -> {
            this.outputScrollOffset = Math.max(0, this.outputScrollOffset - 1);
        }).method_46434(this.field_22789 - 30, startY + 30, 20, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2193"), button -> {
            List<String> log = CloudflaredTunnel.getOutputLog();
            int maxLines = (this.field_22790 - 120) / 12;
            this.outputScrollOffset = Math.min(Math.max(0, log.size() - maxLines), this.outputScrollOffset + 1);
        }).method_46434(this.field_22789 - 30, startY + 55, 20, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Fechar"), button -> this.method_25419()).method_46434(centerX - 50, this.field_22790 - 40, 100, 20).method_46431());
    }

    public void method_25393() {
        super.method_25393();
        if (!this.showOutputTab) {
            if (this.fixedPortField != null) {
                this.fixedPortField.method_1888(!this.useRandomPortCheckbox.method_20372());
            }
            if (this.serverNameField != null) {
                this.serverNameField.method_1888(this.autoAddServerCheckbox.method_20372());
            }
        }
    }

    private void save() {
        try {
            this.config.hostname = this.hostnameField.method_1882();
            this.config.useRandomPort = this.useRandomPortCheckbox.method_20372();
            this.config.autoAddToServerList = this.autoAddServerCheckbox.method_20372();
            this.config.serverName = this.serverNameField.method_1882();
            if (!this.config.useRandomPort) {
                int port = Integer.parseInt(this.fixedPortField.method_1882());
                if (port > 0 && port <= 65535) {
                    this.config.fixedPort = port;
                } else {
                    this.fixedPortField.method_1852(String.valueOf(this.config.fixedPort));
                }
            }
            this.config.save();
        }
        catch (NumberFormatException e) {
            this.fixedPortField.method_1852(String.valueOf(this.config.fixedPort));
        }
    }

    private void reloadTunnel() {
        this.save();
        new Thread(() -> {
            try {
                CloudflaredTunnel.startTunnel();
            }
            catch (Exception e) {
                CloudflaredTunnel.LOGGER.error("Erro ao recarregar tunnel", (Throwable)e);
            }
        }).start();
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25294(0, 0, this.field_22789, this.field_22790, Integer.MIN_VALUE);
        String title = this.showOutputTab ? "Sa\u00edda do Cloudflared Tunnel" : "Configura\u00e7\u00f5es do Cloudflared Tunnel";
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)title), this.field_22789 / 2, 35, 0xFFFFFF);
        if (this.showOutputTab) {
            this.renderOutputContent(context);
        }
        super.method_25394(context, mouseX, mouseY, delta);
    }

    private void renderOutputContent(class_332 context) {
        List<String> log = CloudflaredTunnel.getOutputLog();
        int y = 80;
        int maxLines = (this.field_22790 - 120) / 12;
        int startIndex = Math.max(0, Math.min(this.outputScrollOffset, log.size() - maxLines));
        int endIndex = Math.min(log.size(), startIndex + maxLines);
        context.method_25294(10, y - 5, this.field_22789 - 40, this.field_22790 - 50, Integer.MIN_VALUE);
        for (int i = startIndex; i < endIndex; ++i) {
            Object line = log.get(i);
            if (((String)line).length() > 80) {
                line = ((String)line).substring(0, 77) + "...";
            }
            context.method_25303(this.field_22793, (String)line, 15, y, 0xFFFFFF);
            y += 12;
        }
        if (log.size() > maxLines) {
            context.method_25303(this.field_22793, "Linha " + (startIndex + 1) + "-" + endIndex + " de " + log.size(), 15, this.field_22790 - 45, 0xAAAAAA);
        }
    }
}

