/*
 * Decompiled with CFR 0.152.
 */
package com.nosferk.cloudflaredtunnel.config;

import com.nosferk.cloudflaredtunnel.CloudflaredTunnel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.Random;

public class ModConfig {
    private static final Path CONFIG_PATH = Paths.get("config", "cloudflared-tunnel.properties");
    private static ModConfig INSTANCE;
    public boolean useRandomPort = true;
    public int fixedPort = 25565;
    public String hostname = "play.nosferk.com";
    public boolean autoAddToServerList = true;
    public String serverName = "Nosferk";

    public static ModConfig getInstance() {
        if (INSTANCE == null) {
            INSTANCE = ModConfig.load();
        }
        return INSTANCE;
    }

    public static ModConfig load() {
        ModConfig modConfig;
        File configFile = CONFIG_PATH.toFile();
        ModConfig config = new ModConfig();
        if (!configFile.exists()) {
            config.save();
            return config;
        }
        FileInputStream fis = new FileInputStream(configFile);
        try {
            Properties props = new Properties();
            props.load(fis);
            config.useRandomPort = Boolean.parseBoolean(props.getProperty("useRandomPort", "true"));
            config.fixedPort = Integer.parseInt(props.getProperty("fixedPort", "25565"));
            config.hostname = props.getProperty("hostname", "play.nosferk.com");
            config.autoAddToServerList = Boolean.parseBoolean(props.getProperty("autoAddToServerList", "true"));
            config.serverName = props.getProperty("serverName", "Nosferk");
            modConfig = config;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                CloudflaredTunnel.LOGGER.error("Erro ao carregar configura\u00e7\u00e3o, usando padr\u00e3o", (Throwable)e);
                config.save();
                return config;
            }
        }
        fis.close();
        return modConfig;
    }

    public void save() {
        try {
            File configFile = CONFIG_PATH.toFile();
            configFile.getParentFile().mkdirs();
            Properties props = new Properties();
            props.setProperty("useRandomPort", String.valueOf(this.useRandomPort));
            props.setProperty("fixedPort", String.valueOf(this.fixedPort));
            props.setProperty("hostname", this.hostname);
            props.setProperty("autoAddToServerList", String.valueOf(this.autoAddToServerList));
            props.setProperty("serverName", this.serverName);
            try (FileOutputStream fos = new FileOutputStream(configFile);){
                props.store(fos, "Cloudflared Tunnel Configuration");
            }
            CloudflaredTunnel.LOGGER.info("Configura\u00e7\u00e3o salva em {}", (Object)CONFIG_PATH);
        }
        catch (Exception e) {
            CloudflaredTunnel.LOGGER.error("Erro ao salvar configura\u00e7\u00e3o", (Throwable)e);
        }
    }

    public int getPort() {
        if (this.useRandomPort) {
            return 25500 + new Random().nextInt(100);
        }
        return this.fixedPort;
    }
}

