/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.resourcepandas.client;

import com.mrbysco.resourcepandas.entity.ResourcePandaEntity;
import com.mrbysco.resourcepandas.registry.PandaRegistry;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public class ClientHelper {
    private static final HashMap<ResourceLocation, ResourcePandaEntity> pandaCache = new HashMap();

    public static ResourcePandaEntity getResourcePanda(ResourceLocation id) {
        return pandaCache.computeIfAbsent(id, key -> {
            ResourcePandaEntity resourcePanda;
            ClientLevel level;
            CompoundTag nbt = new CompoundTag();
            nbt.putString("id", BuiltInRegistries.ENTITY_TYPE.getKey(PandaRegistry.RESOURCE_PANDA.get()).toString());
            Minecraft mc = Minecraft.getInstance();
            Object object = level = mc.hasSingleplayerServer() && mc.getSingleplayerServer() != null ? (Level)mc.getSingleplayerServer().getAllLevels().iterator().next() : mc.level;
            if (level != null && (resourcePanda = (ResourcePandaEntity)EntityType.loadEntityRecursive((CompoundTag)nbt, (Level)level, (EntitySpawnReason)EntitySpawnReason.LOAD, Function.identity())) != null) {
                resourcePanda.setResourceDataById(id);
                resourcePanda.setTransformed(true);
                return resourcePanda;
            }
            return null;
        });
    }
}

