/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.resourcepandas.client.renderer;

import com.mrbysco.resourcepandas.client.renderer.ResourceLayer;
import com.mrbysco.resourcepandas.client.state.ResourcePandaRenderState;
import com.mrbysco.resourcepandas.entity.ResourcePandaEntity;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.PandaRenderer;
import net.minecraft.client.renderer.entity.state.PandaRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.Panda;

public class ResourcePandaRenderer
extends PandaRenderer {
    private static final ResourceLocation OVERLAY_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"resourcepandas", (String)"textures/entity/panda/resource_overlay.png");

    public ResourcePandaRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.addLayer(new ResourceLayer(this, OVERLAY_TEXTURE, context.getModelSet()));
    }

    public PandaRenderState createRenderState() {
        return new ResourcePandaRenderState();
    }

    public void extractRenderState(Panda panda, PandaRenderState renderState, float partialTick) {
        super.extractRenderState(panda, renderState, partialTick);
        if (panda instanceof ResourcePandaEntity) {
            ResourcePandaEntity resourcePanda = (ResourcePandaEntity)panda;
            if (renderState instanceof ResourcePandaRenderState) {
                ResourcePandaRenderState resourceState = (ResourcePandaRenderState)renderState;
                resourceState.isConverting = !resourcePanda.isTransformed();
                resourceState.isConverted = resourcePanda.isTransformed();
                resourceState.hasResourceVariant = resourcePanda.hasResourceVariant();
                resourceState.id = resourcePanda.getId();
                resourceState.alpha = (int)(resourcePanda.getAlpha() * 255.0f);
                resourceState.hexColor = resourcePanda.getHexColor();
            }
        }
    }

    protected boolean isShaking(PandaRenderState renderState) {
        if (renderState instanceof ResourcePandaRenderState) {
            ResourcePandaRenderState resourceState = (ResourcePandaRenderState)renderState;
            return renderState.isFullyFrozen || resourceState.isConverting;
        }
        return false;
    }
}

