/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.resourcepandas.compat.jei;

import com.mrbysco.resourcepandas.compat.jei.panda.PandaCategory;
import com.mrbysco.resourcepandas.recipe.PandaCache;
import com.mrbysco.resourcepandas.recipe.PandaRecipe;
import com.mrbysco.resourcepandas.registry.PandaRegistry;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"resourcepandas", (String)"jei_plugin");
    public static final IRecipeType<RecipeHolder<PandaRecipe>> PANDA_RECIPE_TYPE = JEIPlugin.createPandaType();
    @Nullable
    private IRecipeCategory<RecipeHolder<PandaRecipe>> pandaCategory;

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        IRecipeCategory[] iRecipeCategoryArray = new IRecipeCategory[1];
        this.pandaCategory = new PandaCategory(guiHelper);
        iRecipeCategoryArray[0] = this.pandaCategory;
        registration.addRecipeCategories(iRecipeCategoryArray);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addCraftingStation(PANDA_RECIPE_TYPE, new ItemStack[]{new ItemStack((ItemLike)PandaRegistry.RESOURCE_PANDA_SPAWN_EGG.get())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(PANDA_RECIPE_TYPE, PandaCache.PANDA_RECIPES);
    }

    public static <R extends Recipe<?>> IRecipeType<RecipeHolder<R>> createPandaType() {
        Class<RecipeHolder> holderClass = RecipeHolder.class;
        return IRecipeType.create((String)"resourcepandas", (String)"panda_recipe", holderClass);
    }
}

