/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.resourcepandas.compat.jei.panda;

import com.mrbysco.resourcepandas.client.ClientHelper;
import com.mrbysco.resourcepandas.compat.jei.JEIPlugin;
import com.mrbysco.resourcepandas.entity.ResourcePandaEntity;
import com.mrbysco.resourcepandas.recipe.PandaRecipe;
import com.mrbysco.resourcepandas.util.RenderHelper;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotRichTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeType;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3x2fStack;
import org.joml.Vector2f;

public class PandaCategory
implements IRecipeCategory<RecipeHolder<PandaRecipe>> {
    protected static final int X_FIRST_ITEM = 0;
    protected static final int X_OUTPUT_ITEM = 96;
    protected static final int Y_ITEM_DISTANCE = 13;
    private final IDrawableStatic icon;

    public PandaCategory(IGuiHelper guiHelper) {
        ResourceLocation iconLocation = ResourceLocation.fromNamespaceAndPath((String)"resourcepandas", (String)"textures/gui/panda_icon.png");
        this.icon = guiHelper.createDrawable(iconLocation, 0, 0, 16, 16);
    }

    public IRecipeType<RecipeHolder<PandaRecipe>> getRecipeType() {
        return JEIPlugin.PANDA_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"resourcepandas.pandas.title");
    }

    public int getWidth() {
        return 112;
    }

    public int getHeight() {
        return 40;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<PandaRecipe> recipeHolder, IFocusGroup focuses) {
        PandaRecipe recipe = (PandaRecipe)recipeHolder.value();
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 0, 13).add(recipe.getIngredient())).setStandardSlotBackground();
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 96, 13).add(recipe.getResult())).addRichTooltipCallback((IRecipeSlotRichTooltipCallback)new OutputTooltip(recipe)).setStandardSlotBackground();
    }

    public void draw(RecipeHolder<PandaRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        PandaRecipe recipe = (PandaRecipe)recipeHolder.value();
        Matrix3x2fStack poseStack = guiGraphics.pose();
        ResourcePandaEntity resourcePanda = ClientHelper.getResourcePanda(recipeHolder.id().location());
        if (resourcePanda != null) {
            Vector2f position = new Vector2f(56.0f, 36.0f);
            position = poseStack.transformPosition(position);
            int x = Math.round(position.x);
            int y = Math.round(position.y);
            RenderHelper.renderEntity(guiGraphics, x, y, 20.0, 38.0 - mouseX, 80.0 - mouseY, (LivingEntity)resourcePanda);
        }
        poseStack.pushMatrix();
        poseStack.translate(1.0f, 0.0f);
        Font font = Minecraft.getInstance().font;
        String text = recipe.getName();
        if (font.width(text) > 122) {
            poseStack.scale(0.75f, 0.75f);
        }
        guiGraphics.drawString(font, text, 0, 0, 8, false);
        poseStack.popMatrix();
    }

    public static class OutputTooltip
    implements IRecipeSlotRichTooltipCallback {
        private final PandaRecipe recipe;

        public OutputTooltip(PandaRecipe recipe) {
            this.recipe = recipe;
        }

        public void onRichTooltip(@NotNull IRecipeSlotView recipeSlotView, ITooltipBuilder tooltip) {
            tooltip.add((FormattedText)Component.translatable((String)"resourcepandas.gui.jei.pandas.tooltip", (Object[])new Object[]{Math.round(100.0f * this.recipe.getChance())}).withStyle(ChatFormatting.YELLOW));
        }
    }
}

