/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.resourcepandas.datagen;

import com.mrbysco.resourcepandas.Reference;
import com.mrbysco.resourcepandas.client.ResourceColor;
import com.mrbysco.resourcepandas.datagen.builder.ResourceRecipeBuilder;
import com.mrbysco.resourcepandas.registry.PandaRegistry;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber
public class ResourceDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        generator.addProvider(true, (DataProvider)new ResourceModelProvider(packOutput));
        generator.addProvider(true, (DataProvider)new ResourceRecipeProvider.Runner(packOutput, event.getLookupProvider()));
    }

    public static class ResourceModelProvider
    extends ModelProvider {
        public ResourceModelProvider(PackOutput packOutput) {
            super(packOutput, "resourcepandas");
        }

        protected void registerModels(@NotNull BlockModelGenerators blockModels, @NotNull ItemModelGenerators itemModels) {
            ResourceLocation baseTexture = Reference.modLoc("item/panda_spawn_egg");
            ResourceLocation customOverlay = Reference.modLoc("item/panda_spawn_egg_overlay");
            ResourceLocation layeredModel = itemModels.generateLayeredItem((Item)PandaRegistry.RESOURCE_PANDA_SPAWN_EGG.get(), customOverlay, baseTexture);
            itemModels.itemModelOutput.accept((Item)PandaRegistry.RESOURCE_PANDA_SPAWN_EGG.get(), ItemModelUtils.tintedModel((ResourceLocation)layeredModel, (ItemTintSource[])new ItemTintSource[]{new ResourceColor(), ItemModelUtils.constantTint((int)0x1B1B22)}));
        }
    }

    public static class ResourceRecipeProvider
    extends RecipeProvider {
        private final HolderGetter<Item> items;

        public ResourceRecipeProvider(HolderLookup.Provider provider, RecipeOutput recipeOutput) {
            super(provider, recipeOutput);
            this.items = provider.lookupOrThrow(Registries.ITEM);
        }

        protected void buildRecipes() {
            this.resource(this.tag((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_COAL), (ItemLike)Items.COAL, 1).name("Coal").color("#363636").alpha(1.0f).chance(0.6f).save(this.output, ResourceLocation.fromNamespaceAndPath((String)"resourcepandas", (String)"coal_panda"));
            this.resource(this.tag((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_COPPER), (ItemLike)Items.COPPER_INGOT, 1).name("Copper").color("#e77c56").alpha(1.0f).chance(0.6f).save(this.output, ResourceLocation.fromNamespaceAndPath((String)"resourcepandas", (String)"copper_panda"));
            this.resource(this.tag((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_DIAMOND), (ItemLike)Items.DIAMOND, 1).name("Diamond").color("#a1fbe8").alpha(1.0f).chance(0.11f).save(this.output, ResourceLocation.fromNamespaceAndPath((String)"resourcepandas", (String)"diamond_panda"));
            this.resource(this.tag((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_EMERALD), (ItemLike)Items.EMERALD, 1).name("Emerald").color("#17dd62").alpha(1.0f).chance(0.08f).save(this.output, ResourceLocation.fromNamespaceAndPath((String)"resourcepandas", (String)"emerald_panda"));
            this.resource(this.tag((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_GOLD), (ItemLike)Items.GOLD_NUGGET, 1).name("Gold").color("#f8d26a").alpha(1.0f).chance(0.5f).save(this.output, ResourceLocation.fromNamespaceAndPath((String)"resourcepandas", (String)"gold_panda"));
            this.resource(this.tag((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_IRON), (ItemLike)Items.IRON_NUGGET, 1).name("Iron").color("#d9dfe7").alpha(1.0f).chance(0.6f).save(this.output, ResourceLocation.fromNamespaceAndPath((String)"resourcepandas", (String)"iron_panda"));
            this.resource(this.tag((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_LAPIS), (ItemLike)Items.LAPIS_LAZULI, 1).name("Lapis").color("#345ec3").alpha(1.0f).chance(0.6f).save(this.output, ResourceLocation.fromNamespaceAndPath((String)"resourcepandas", (String)"lapis_panda"));
            this.resource(this.tag((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_NETHERITE), (ItemLike)Items.NETHERITE_SCRAP, 1).name("Netherite").color("#4c4143").alpha(1.0f).chance(0.06f).save(this.output, ResourceLocation.fromNamespaceAndPath((String)"resourcepandas", (String)"netherite_panda"));
            this.resource(Ingredient.of((ItemLike)Blocks.QUARTZ_BLOCK), (ItemLike)Items.QUARTZ, 1).name("Quartz").color("#ddd4c6").alpha(1.0f).chance(0.6f).save(this.output, ResourceLocation.fromNamespaceAndPath((String)"resourcepandas", (String)"quartz_panda"));
            this.resource(this.tag((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_REDSTONE), (ItemLike)Items.REDSTONE, 1).name("Redstone").color("#aa0f01").alpha(1.0f).chance(0.6f).save(this.output, ResourceLocation.fromNamespaceAndPath((String)"resourcepandas", (String)"redstone_panda"));
        }

        private ResourceRecipeBuilder resource(Ingredient input, ItemLike output, int count) {
            return ResourceRecipeBuilder.resource(this.items, input, output, count);
        }

        protected Ingredient tag(TagKey<Item> tag) {
            return Ingredient.of((HolderSet)this.items.getOrThrow(tag));
        }

        public static class Runner
        extends RecipeProvider.Runner {
            public Runner(PackOutput output, CompletableFuture<HolderLookup.Provider> completableFuture) {
                super(output, completableFuture);
            }

            protected RecipeProvider createRecipeProvider(HolderLookup.Provider provider, RecipeOutput recipeOutput) {
                return new ResourceRecipeProvider(provider, recipeOutput);
            }

            public String getName() {
                return "Resource Pandas Recipes";
            }
        }
    }
}

