/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.resourcepandas.entity;

import com.mrbysco.resourcepandas.Reference;
import com.mrbysco.resourcepandas.item.PandaDataComponents;
import com.mrbysco.resourcepandas.recipe.PandaRecipe;
import com.mrbysco.resourcepandas.recipe.PandaRecipes;
import com.mrbysco.resourcepandas.registry.PandaRegistry;
import com.mrbysco.resourcepandas.util.ResourceData;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Panda;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.CommonHooks;
import org.jetbrains.annotations.Nullable;

public class ResourcePandaEntity
extends Panda {
    private static final RecipeHolder<PandaRecipe> MISSING_RECIPE = new RecipeHolder(ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)Reference.modLoc("missing")), (Recipe)new PandaRecipe("Missing", Ingredient.of((ItemLike)Items.EGG), new ItemStack((ItemLike)Items.EGG), "#ffd79a", 1.0f, 2.0f));
    private static final EntityDataAccessor<Optional<ResourceData>> RESOURCE_DATA = SynchedEntityData.defineId(ResourcePandaEntity.class, PandaRegistry.RESOURCE_DATA.get());
    private static final EntityDataAccessor<Boolean> TRANSFORMED = SynchedEntityData.defineId(ResourcePandaEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private int resourceTransformationTime;
    private RecipeHolder<PandaRecipe> cachedRecipe;

    public ResourcePandaEntity(EntityType<? extends ResourcePandaEntity> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder genAttributeMap() {
        return Panda.createAttributes();
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(8, (Goal)new ResourceSneezingGoal(this));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(RESOURCE_DATA, Optional.empty());
        builder.define(TRANSFORMED, (Object)false);
    }

    public Component getName() {
        return !this.hasCustomName() ? Component.literal((String)String.format("%s", this.getResourceName())).append(super.getName()) : super.getName();
    }

    @Nullable
    public ItemStack getPickResult() {
        ItemStack stack = PandaRegistry.RESOURCE_PANDA_SPAWN_EGG.toStack();
        Optional<ResourceData> optionalData = this.getResourceData();
        if (optionalData.isPresent()) {
            stack.set(PandaDataComponents.RESOURCE_TYPE, (Object)optionalData.get().id());
            stack.set(PandaDataComponents.COLOR, (Object)Integer.decode("0x" + optionalData.get().hexColor().replaceFirst("#", "")));
        } else {
            stack.set(PandaDataComponents.COLOR, (Object)Integer.decode("0x" + ResourceData.MISSING.hexColor().replaceFirst("#", "")));
        }
        return stack;
    }

    public Optional<ResourceData> getResourceData() {
        return (Optional)this.entityData.get(RESOURCE_DATA);
    }

    public void setResourceDataById(ResourceLocation variant) {
        RecipeHolder<PandaRecipe> recipeHolder = this.getRecipeFromID(variant);
        if (recipeHolder != null) {
            this.setResourceData(ResourceData.fromRecipe(recipeHolder));
        }
    }

    public void setResourceData(@Nullable ResourceData data) {
        if (data == null) {
            this.entityData.set(RESOURCE_DATA, Optional.empty());
        } else {
            this.entityData.set(RESOURCE_DATA, Optional.of(data));
        }
        this.getPandaRecipe();
    }

    public String getHexColor() {
        return this.getResourceData().map(ResourceData::hexColor).orElse("#FFFFFF");
    }

    public float getAlpha() {
        return this.getResourceData().map(ResourceData::alpha).orElse(Float.valueOf(1.0f)).floatValue();
    }

    public boolean isTransformed() {
        return (Boolean)this.entityData.get(TRANSFORMED);
    }

    public String getResourceName() {
        return this.getResourceData().map(ResourceData::name).orElse("");
    }

    public void setTransformed(Boolean transformed) {
        this.entityData.set(TRANSFORMED, (Object)transformed);
    }

    public void startTransforming(int transformationTime) {
        this.resourceTransformationTime = transformationTime;
        this.setTransformed(false);
    }

    protected void onTransformed() {
        this.setTransformed(true);
        this.setMainGene(Panda.Gene.WEAK);
        this.setHiddenGene(Panda.Gene.WEAK);
        if (!this.isSilent()) {
            this.level().levelEvent((Entity)((Player)null), 1040, this.blockPosition(), 0);
        }
    }

    public boolean hasResourceVariant() {
        return this.getResourceData().isPresent();
    }

    public boolean canBreed() {
        return false;
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    public void tick() {
        if (!this.level().isClientSide() && this.isAlive() && !this.isNoAi() && !this.isTransformed()) {
            --this.resourceTransformationTime;
            if (this.resourceTransformationTime < 0) {
                this.onTransformed();
            }
        }
        super.tick();
    }

    protected void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        if (this.getResourceData().isPresent()) {
            output.store("resource_data", ResourceData.CODEC, (Object)this.getResourceData().get());
        }
        output.putBoolean("Transformed", this.isTransformed());
    }

    public void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        Optional resourceData = input.read("resource_data", ResourceData.CODEC);
        if (resourceData.isPresent()) {
            this.setResourceData((ResourceData)resourceData.get());
        } else {
            this.setResourceData(null);
        }
        this.setTransformed(input.getBooleanOr("Transformed", false));
    }

    public RecipeHolder<PandaRecipe> getPandaRecipe() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.getResourceData().isPresent()) {
                ResourceLocation dataId = this.getResourceData().get().id();
                if (this.cachedRecipe == null || !this.cachedRecipe.id().location().equals((Object)dataId)) {
                    Collection recipes = serverLevel.recipeAccess().recipeMap().byType((RecipeType)PandaRecipes.PANDA_RECIPE_TYPE.get());
                    for (RecipeHolder recipe : recipes) {
                        if (!recipe.id().location().equals((Object)dataId)) continue;
                        this.cachedRecipe = recipe;
                        return this.cachedRecipe;
                    }
                    this.cachedRecipe = null;
                    return null;
                }
                return this.cachedRecipe;
            }
        }
        return null;
    }

    private RecipeHolder<PandaRecipe> getRecipeFromID(ResourceLocation id) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Collection recipes = serverLevel.recipeAccess().recipeMap().byType((RecipeType)PandaRecipes.PANDA_RECIPE_TYPE.get());
            for (RecipeHolder recipe : recipes) {
                if (!recipe.id().location().equals((Object)id)) continue;
                return recipe;
            }
        }
        return null;
    }

    public void afterSneeze() {
        Level panda2;
        Vec3 vector3d = this.getDeltaMovement();
        this.level().addParticle((ParticleOptions)ParticleTypes.SNEEZE, this.getX() - (double)(this.getBbWidth() + 1.0f) * 0.5 * (double)Mth.sin((float)(this.yBodyRot * ((float)Math.PI / 180))), this.getEyeY() - (double)0.1f, this.getZ() + (double)(this.getBbWidth() + 1.0f) * 0.5 * (double)Mth.cos((float)(this.yBodyRot * ((float)Math.PI / 180))), vector3d.x, 0.0, vector3d.z);
        this.playSound(SoundEvents.PANDA_SNEEZE, 1.0f, 1.0f);
        for (Level panda2 : this.level().getEntitiesOfClass(Panda.class, this.getBoundingBox().inflate(10.0))) {
            if (panda2.isBaby() || !panda2.onGround() || panda2.isInWater() || !panda2.canPerformAction()) continue;
            this.jump((Panda)panda2);
        }
        panda2 = this.level();
        if (panda2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)panda2;
            if (this.random.nextFloat() <= ((PandaRecipe)this.getPandaRecipe().value()).getChance() && serverLevel.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
                PandaRecipe recipe = (PandaRecipe)this.getPandaRecipe().value();
                this.spawnAtLocation(serverLevel, recipe.getResult());
            }
        }
    }

    public void jump(Panda panda) {
        float f = 0.42f * this.getJumpFactor(panda);
        MobEffectInstance jumpEffect = panda.getEffect(MobEffects.JUMP_BOOST);
        if (jumpEffect != null) {
            f += 0.1f * (float)(jumpEffect.getAmplifier() + 1);
        }
        Vec3 vector3d = panda.getDeltaMovement();
        panda.setDeltaMovement(vector3d.x, (double)f, vector3d.z);
        if (panda.isSprinting()) {
            float f1 = panda.getYRot() * ((float)Math.PI / 180);
            panda.setDeltaMovement(panda.getDeltaMovement().add((double)(-Mth.sin((float)f1) * 0.2f), 0.0, (double)(Mth.cos((float)f1) * 0.2f)));
        }
        panda.hasImpulse = true;
        CommonHooks.onLivingJump((LivingEntity)panda);
    }

    protected float getJumpFactor(Panda panda) {
        float f = panda.level().getBlockState(panda.blockPosition()).getBlock().getJumpFactor();
        float f1 = panda.level().getBlockState(this.getPositionUnderneath(panda)).getBlock().getJumpFactor();
        return (double)f == 1.0 ? f1 : f;
    }

    protected BlockPos getPositionUnderneath(Panda panda) {
        return BlockPos.containing((double)panda.position().x, (double)(panda.getBoundingBox().minY - 0.5000001), (double)panda.position().z);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyIn, EntitySpawnReason reason, @Nullable SpawnGroupData spawnDataIn) {
        SpawnGroupData entityData = super.finalizeSpawn(levelAccessor, difficultyIn, reason, spawnDataIn);
        this.setMainGene(Panda.Gene.WEAK);
        this.setHiddenGene(Panda.Gene.WEAK);
        if (reason == EntitySpawnReason.SPAWN_ITEM_USE || reason == EntitySpawnReason.SPAWNER) {
            this.setTransformed(true);
        } else {
            this.startTransforming(300);
        }
        return entityData;
    }

    static class ResourceSneezingGoal
    extends Goal {
        private final ResourcePandaEntity resourcePanda;

        public ResourceSneezingGoal(ResourcePandaEntity pandaIn) {
            this.resourcePanda = pandaIn;
        }

        public boolean canUse() {
            if (this.resourcePanda.canPerformAction()) {
                if (this.resourcePanda.isTransformed() && this.resourcePanda.isWeak() && this.resourcePanda.getRandom().nextInt(500) == 1) {
                    return true;
                }
                return this.resourcePanda.getRandom().nextInt(6000) == 1;
            }
            return false;
        }

        public boolean canContinueToUse() {
            return false;
        }

        public void start() {
            this.resourcePanda.sneeze(true);
        }
    }
}

