/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.resourcepandas.handler;

import com.mrbysco.resourcepandas.entity.ResourcePandaEntity;
import com.mrbysco.resourcepandas.recipe.PandaRecipes;
import com.mrbysco.resourcepandas.registry.PandaRegistry;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Panda;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class ConversionHandler {
    @SubscribeEvent
    public void interactEvent(PlayerInteractEvent.EntityInteractSpecific event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack heldStack = event.getItemStack();
            Entity target = event.getTarget();
            if (target.getType() == EntityType.PANDA && target instanceof Panda) {
                ResourcePandaEntity resourcePanda;
                Panda panda = (Panda)target;
                SingleRecipeInput inventory = new SingleRecipeInput(heldStack);
                RecipeHolder recipe = serverLevel.recipeAccess().getRecipeFor((RecipeType)PandaRecipes.PANDA_RECIPE_TYPE.get(), (RecipeInput)inventory, level).orElse(null);
                if (recipe != null && (resourcePanda = (ResourcePandaEntity)panda.convertTo(PandaRegistry.RESOURCE_PANDA.get(), ConversionParams.single((Mob)panda, (boolean)true, (boolean)true), cow -> EventHooks.onLivingConvert((LivingEntity)panda, (LivingEntity)cow))) != null) {
                    resourcePanda.setResourceDataById(recipe.id().location());
                    resourcePanda.startTransforming(300);
                    level.playSound((Entity)((Player)null), event.getPos(), SoundEvents.PANDA_EAT, SoundSource.NEUTRAL, 0.5f + 0.5f * (float)resourcePanda.getRandom().nextInt(2), (resourcePanda.getRandom().nextFloat() - resourcePanda.getRandom().nextFloat()) * 0.2f + 1.0f);
                    if (!event.getEntity().getAbilities().instabuild) {
                        heldStack.shrink(1);
                    }
                }
            }
        }
    }
}

